/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.tiani.jvision.main.Colors;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetPanel;
import com.tiani.jvision.patinfo.PatLabelPopup;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class PatLabel
extends JLabel {
    final IPatientRepresentation patientRepresentation;
    private final DisplaySetPanel displaySetPanel;
    private boolean isSelected;
    private boolean isMouseOver;

    PatLabel(DisplaySetPanel displaySetPanel, IPatientRepresentation iPatientRepresentation) {
        this.displaySetPanel = displaySetPanel;
        this.patientRepresentation = iPatientRepresentation;
        this.setCursor(new Cursor(12));
        this.setForeground(Color.white);
        this.addMouseListener(new RepaintingPopupmenuMouseListener());
        ComponentFactory.instance.scaleFont(this);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isMouseOver) {
            int n = this.getBounds().height;
            graphics.setColor(this.getForeground());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = fontMetrics.stringWidth(this.getText());
            int n3 = fontMetrics.getAscent() - fontMetrics.getDescent();
            int n4 = n / 2 + n3 / 2 + 2;
            graphics.drawLine(0, n4, n2 - 1, n4);
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
    }

    public IPatientRepresentation getPatient() {
        return this.patientRepresentation;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
        if (this.isSelected) {
            this.setBackground(Colors.patLabelColorSelectBack);
            this.setForeground(Colors.patLabelColorSelectFront);
            this.setOpaque(true);
        } else {
            this.setForeground(Color.white);
            this.setOpaque(false);
        }
    }

    private class RepaintingPopupmenuMouseListener
    extends MouseAdapter {
        private RepaintingPopupmenuMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            PatLabel.this.isMouseOver = true;
            PatLabel.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            PatLabel.this.isMouseOver = false;
            PatLabel.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (ModifierKeys.isLMB((MouseEvent)mouseEvent)) {
                if (DataSelectionManager.getInstance().getCurrentPatient() == PatLabel.this.patientRepresentation) {
                    PatLabel.this.displaySetPanel.activateDisplaySetTab();
                } else {
                    DataSelectionManager.getInstance().setCurrentPatient(PatLabel.this.patientRepresentation);
                }
                DataSelectionManager.getInstance().patientClicked(PatLabel.this.patientRepresentation, mouseEvent.getModifiersEx());
            } else if (ModifierKeys.isRMB((MouseEvent)mouseEvent)) {
                new PatLabelPopup(PatLabel.this).show(PatLabel.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

