/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.PatLabel;
import com.tiani.jvision.patinfo.PatScrollPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class PatLabelPopup
implements ActionListener {
    private JPopupMenu popup;
    private JMenuItem itemRemove;
    private JMenuItem itemRemoveAll;
    private JMenuItem itemRemoveAllButCurrentPatient;
    private JMenuItem itemSort;
    private PatLabel patLabel;

    PatLabelPopup(PatLabel patLabel) {
        this.patLabel = patLabel;
        this.itemRemove = ComponentFactory.instance.createMenuItem(MessageFormat.format(Messages.getString("SEQPANEL_POPUP_DELETE_PAT_WITH_CONTEXT"), PatScrollPane.formatPatientName(patLabel.getPatient())));
        this.itemRemoveAll = ComponentFactory.instance.createMenuItem(Messages.getString("SEQPANEL_POPUP_DELETE_ALL_PAT"));
        this.itemRemoveAllButCurrentPatient = ComponentFactory.instance.createMenuItem(MessageFormat.format(Messages.getString("SEQPANEL_POPUP_DELETE_ALL_BUT_CURRENT_PATIENT"), PatScrollPane.formatPatientName(DataSelectionManager.getInstance().getCurrentPatient())));
        this.itemSort = ComponentFactory.instance.createMenuItem(Messages.getString("SEQPANEL_POPUP_SORT_PAT"));
        this.popup = new JPopupMenu();
        this.popup.add(this.itemRemove);
        this.popup.add(this.itemRemoveAll);
        this.popup.add(this.itemRemoveAllButCurrentPatient);
        this.popup.addSeparator();
        this.popup.add(this.itemSort);
        this.itemRemove.addActionListener(this);
        this.itemRemoveAll.addActionListener(this);
        this.itemRemoveAllButCurrentPatient.addActionListener(this);
        this.itemSort.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.itemRemove) {
            DataManager.getInstance().removePatient(this.patLabel.getPatient().getPatientData().getKey(), true, false);
        } else if (actionEvent.getSource() == this.itemRemoveAll) {
            DataManager.getInstance().removeAllPatients(true, false);
        } else if (actionEvent.getSource() == this.itemRemoveAllButCurrentPatient) {
            DataManager.getInstance().removeAllButCurrentPatient();
        } else if (actionEvent.getSource() == this.itemSort) {
            DataManager.getInstance().sortPatients();
        }
    }

    void show(Component component, int n, int n2) {
        this.popup.show(component, n, n2);
    }
}

