/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IPatientData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DisplaySetPanel;
import com.tiani.jvision.patinfo.PatLabel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.dcm4che3.data.PersonName;

class PatScrollPane
extends JScrollPane {
    private static final long serialVersionUID = -5360468395635131678L;
    private static final int rowHeight = GUI.getScaledDiagnosticInt((int)20);
    private static final int patientWidth = GUI.getScaledDiagnosticInt((int)250);
    private static final int rowWidth = GUI.getScaledDiagnosticInt((int)600);
    private JPanel panel = null;
    private List<PatLabel> patients = new ArrayList<PatLabel>();
    private PatLabel selectedPat;
    private PatientUpdatingDataManagerListener listener;
    private final DisplaySetPanel displaySetPanel;

    PatScrollPane(DisplaySetPanel displaySetPanel) {
        this.displaySetPanel = displaySetPanel;
        this.listener = new PatientUpdatingDataManagerListener();
        this.getHorizontalScrollBar().setUnitIncrement(10);
        this.getVerticalScrollBar().setUnitIncrement(rowHeight);
        this.getHorizontalScrollBar().setBlockIncrement(10);
        this.getVerticalScrollBar().setBlockIncrement(rowHeight);
        this.setVerticalScrollBarPolicy(20);
        this.addPatients();
        this.panel = new JPanel();
        this.panel.setLayout(null);
        this.getViewport().add(this.panel);
        DataManager.getInstance().addListener(this.listener);
    }

    private PatLabel getPatLabel(IPatientRepresentation iPatientRepresentation) {
        for (PatLabel patLabel : this.patients) {
            if (!patLabel.getPatient().equals(iPatientRepresentation)) continue;
            return patLabel;
        }
        return null;
    }

    void selectedPatientChanged(IPatientRepresentation iPatientRepresentation) {
        if (this.selectedPat != null) {
            this.selectedPat.setSelected(false);
        }
        for (PatLabel patLabel : this.patients) {
            if (patLabel.patientRepresentation != iPatientRepresentation) continue;
            this.selectedPat = patLabel;
            break;
        }
        if (this.selectedPat != null) {
            this.selectedPat.setSelected(true);
        }
    }

    public synchronized void updatePatients() {
        if (this.patients.size() != DataManager.getInstance().getPatientCount()) {
            ALogger.getLogger(PatScrollPane.class).warn("Inconsistency detected, resetting");
            this.patients.clear();
            this.addPatients();
        }
        this.panel.removeAll();
        this.setLayout();
        if (this.getParent() != null && this.getParent().getParent() != null && ((DisplaySetPanel)this.getParent().getParent()).getTabPane() != null) {
            ((DisplaySetPanel)this.getParent().getParent()).getTabPane().doLayout();
            ((DisplaySetPanel)this.getParent().getParent()).getTabPane().validate();
            ((DisplaySetPanel)this.getParent().getParent()).getTabPane().repaint();
        }
    }

    private void addPatients() {
        for (IPatientRepresentation iPatientRepresentation : DataManager.getInstance().getPatientRepresentations()) {
            this.patients.add(new PatLabel(this.displaySetPanel, iPatientRepresentation));
        }
    }

    private void layoutVertical(int n) {
        this.panel.setPreferredSize(new Dimension(n, rowHeight * this.patients.size()));
        int n2 = 0;
        for (PatLabel patLabel : this.patients) {
            if (patLabel == null) continue;
            patLabel.setText(PatScrollPane.formatPatientName(patLabel.getPatient()));
            patLabel.setBounds(0, n2, rowWidth, rowHeight);
            n2 += rowHeight;
            this.panel.add(patLabel);
        }
    }

    @Override
    public void doLayout() {
        this.setLayout();
        super.doLayout();
    }

    private void setLayout() {
        if (JVision2.getMainFrame().getPaletteOrientation().isHorizontal()) {
            this.layoutHorizontal();
        } else {
            this.layoutVertical(rowWidth);
        }
    }

    private void layoutHorizontal() {
        if (this.getWidth() <= 0) {
            return;
        }
        int n = 0;
        int n2 = this.getWidth();
        int n3 = n2 / patientWidth;
        if (n3 > 0) {
            if (this.patients.size() > 0) {
                n = this.patients.size() / n3;
            }
            if (this.patients.size() % n3 != 0) {
                ++n;
            }
        }
        this.panel.setPreferredSize(new Dimension(100, (rowHeight + 5) * n));
        this.setVerticalScrollBarPolicy(20);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (PatLabel patLabel : this.patients) {
            if (patLabel == null) continue;
            patLabel.setText(PatScrollPane.formatPatientName(patLabel.getPatient()));
            patLabel.setBounds(n5, n4, patientWidth, rowHeight);
            if (++n6 == n3) {
                n4 += rowHeight + 5;
                n5 = 0;
                n6 = 0;
            } else {
                n5 += patientWidth;
            }
            this.panel.add(patLabel);
        }
    }

    static String formatPatientName(IPatientRepresentation iPatientRepresentation) {
        try {
            return PersonNameUtilities.personNameToHRReverseShort((PersonName)iPatientRepresentation.getPatientData().getPatientName());
        }
        catch (Exception exception) {
            return "UNAVAILABLE";
        }
    }

    private class PatientUpdatingDataManagerListener
    extends DataManagerListenerAdapter {
        private PatientUpdatingDataManagerListener() {
        }

        @Override
        public void patientAdded(IPatientRepresentation iPatientRepresentation) {
            if (iPatientRepresentation != null && iPatientRepresentation.getPatientData() != null) {
                PatLabel patLabel = new PatLabel(PatScrollPane.this.displaySetPanel, iPatientRepresentation);
                PatScrollPane.this.patients.add(patLabel);
                PatScrollPane.this.updatePatients();
            }
        }

        @Override
        public void patientRemoved(IPatientRepresentation iPatientRepresentation, boolean bl) {
            PatLabel patLabel = PatScrollPane.this.getPatLabel(iPatientRepresentation);
            PatScrollPane.this.patients.remove(patLabel);
            PatScrollPane.this.updatePatients();
        }

        @Override
        public void patientsSorted(Comparator<IPatientData> comparator) {
            Collections.sort(PatScrollPane.this.patients, (patLabel, patLabel2) -> comparator.compare(patLabel.getPatient().getPatientData(), patLabel2.getPatient().getPatientData()));
            PatScrollPane.this.updatePatients();
        }
    }
}

