/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.hanging;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.mvc.AbstractSelectionController;
import com.agfa.pacs.impaxee.gui.mvc.IMutableSelectionModel;
import com.agfa.pacs.impaxee.gui.mvc.IPopupMenuAction;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionComponent;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionView;
import com.agfa.pacs.impaxee.gui.mvc.SComboBox;
import com.agfa.pacs.impaxee.gui.mvc.SList;
import com.agfa.pacs.impaxee.gui.mvc.SelectionList;
import com.agfa.pacs.impaxee.gui.mvc.SelectionView;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.xml.Snapshot;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.SinglePatientHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.UserDefinedHangingProtocolRuntime;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.jna.wintools.TouchUtils;
import com.agfa.pacs.listtext.lta.base.session.SessionDeleter;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.security.permission.Permissions;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IStudyData;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorCellRenderer;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.hanging.HangingAction;
import com.tiani.jvision.patinfo.hanging.snapshots.SnapshotController;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import org.dcm4che3.data.Attributes;

public class HangingController
extends AbstractSelectionController<IHanging>
implements ListCellRenderer<IHanging> {
    private static final ALogger log = ALogger.getLogger(HangingController.class);
    private static final HangingController INSTANCE = new HangingController();
    private static final HangingCellRenderer DEFAULT_CELL_RENDERER = new HangingCellRenderer();
    private static final BlinkingListCellRenderer BLINKING_CELL_RENDERER = new BlinkingListCellRenderer();
    private static final String MULTI_PATIENT_HP = DataSelectionManager.getInstance().getMultiPatientHPId();

    private HangingController() {
        DataSelectionManager.getInstance().addListener(new SelectionChangeListener());
        DataManager.getInstance().addListener(new DataUpdateListener());
    }

    public static HangingController getInstance() {
        return INSTANCE;
    }

    public static JComponent createHangingView() {
        ISelectionComponent iSelectionComponent;
        JComponent jComponent;
        boolean bl = JVision2.getMainFrame().getPaletteOrientation().isHorizontal();
        if (Config.impaxee.workstation.HANGINGPANEL.useComboBox.get() && !bl || Product.isCDViewer() || TouchUtils.supportsTouchInput()) {
            jComponent = new JComboBox();
            ComponentFactory.instance.scaleFont(jComponent);
            ((JComboBox)jComponent).setRenderer(HangingController.getInstance());
            iSelectionComponent = new SComboBox(jComponent, null);
        } else {
            jComponent = new SelectionList<IHanging>(HangingController.getInstance());
            iSelectionComponent = new SList(jComponent, null, bl);
        }
        jComponent = new SelectionView<IHanging>(HangingController.getInstance(), iSelectionComponent, "North");
        jComponent.add(SnapshotController.createSnapshotView(), "Center");
        return jComponent;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.checkMultiPatientHPInitialization((IHanging)this.getSelectedElement());
    }

    public void reInit() {
        this.refresh();
        for (ISelectionView iSelectionView : this.getViews()) {
            Component component = iSelectionView.getUIComponent();
            component.revalidate();
            component.repaint();
        }
    }

    @Override
    public void selectionActivated(Component component, int n) {
        IHanging iHanging = (IHanging)this.getElementAt(n);
        this.checkMultiPatientHPInitialization(iHanging);
        if (!CompareUtils.equals((Object)iHanging, (Object)DataSelectionManager.getInstance().getActiveHanging())) {
            try {
                CursorUtil.setWaitCursor((Component)component);
                IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
                if (iPatientRepresentation == null) {
                    return;
                }
                assert (HangingUtil.belongsToCurrentPatient(iHanging)) : "The selected hanging does not belong to the current patient";
                if (iHanging != null) {
                    DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, iHanging, true, false);
                } else {
                    log.error("No hanging selected.");
                }
            }
            finally {
                CursorUtil.resetWaitCursor((Component)component);
            }
        }
    }

    private void checkMultiPatientHPInitialization(IHanging iHanging) {
        if (HangingController.isMultiPatientHP(iHanging)) {
            BLINKING_CELL_RENDERER.startBlinking();
        } else {
            BLINKING_CELL_RENDERER.stopBlinking();
        }
    }

    @Override
    public void selectionDeactivated() {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null) {
            DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, null, true, false);
        }
    }

    void saveHanging(boolean bl) {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        assert (iHanging != null) : "There must be a current hanging state for action saveHanging";
        if (iHanging instanceof IHangingSession) {
            HangingUtil.saveSession((IHangingSession)iHanging, bl);
        }
    }

    void editCurrentHanging() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging instanceof UserDefinedHangingProtocolRuntime) {
            HangingUtil.editUserDefinedHanging((UserDefinedHangingProtocolRuntime)iHanging);
        }
    }

    void saveAsNewHangingProtocol() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging instanceof SinglePatientHangingProtocolRuntime) {
            SinglePatientHangingProtocolRuntime singlePatientHangingProtocolRuntime = (SinglePatientHangingProtocolRuntime)iHanging;
            HangingProtocol hangingProtocol = new HangingProtocol();
            hangingProtocol.setName(HPRegistry.getInstance().createUniqueName(Messages.getString("HangingController.NewHP")));
            Snapshot snapshot = new Snapshot("1");
            snapshot.setOrderHanging(null);
            snapshot.setConditionalHanging(new ConditionalHanging());
            hangingProtocol.getHangingDefinition().addSnapshot(snapshot);
            UserDefinedHangingProtocolRuntime userDefinedHangingProtocolRuntime = new UserDefinedHangingProtocolRuntime(singlePatientHangingProtocolRuntime.getStudyContainer(), hangingProtocol, singlePatientHangingProtocolRuntime.getSplitAndSortRuntime());
            ((HangingDefinitionRuntime)userDefinedHangingProtocolRuntime.getHangingDefinition()).getSnapshot(0).capture();
            ((HangingDefinitionRuntime)userDefinedHangingProtocolRuntime.getHangingDefinition()).getSnapshot(0).setCacheDisplaySets(false);
            ((HangingDefinitionRuntime)userDefinedHangingProtocolRuntime.getHangingDefinition()).getSnapshot(0).setUseRuntimeForSave(true);
            userDefinedHangingProtocolRuntime.setCreatedBy(URLProviderFactory.getProvider().getLoginInformation().getUserFullName());
            userDefinedHangingProtocolRuntime.setLastModifiedBy(URLProviderFactory.getProvider().getLoginInformation().getUserFullName());
            HangingCondition hangingCondition2 = new HangingCondition();
            hangingCondition2.setName(String.valueOf(Messages.getString("HangingController.Rule")) + 1);
            userDefinedHangingProtocolRuntime.getHangingApplicability().addHangingCondition(hangingCondition2);
            if (HangingUtil.editUserDefinedHanging(userDefinedHangingProtocolRuntime)) {
                HPRegistry.getInstance().addElement(hangingProtocol);
                userDefinedHangingProtocolRuntime.setPriority(hangingProtocol.getPriority());
                IPatientRepresentation iPatientRepresentation = userDefinedHangingProtocolRuntime.getStudyContainer().getPatientRepresentation();
                iPatientRepresentation.addHanging(userDefinedHangingProtocolRuntime);
                DataManager.getInstance().notifyPatientRepresentationModified(userDefinedHangingProtocolRuntime.getStudyContainer().getPatientRepresentation());
                ((HangingDefinitionRuntime)userDefinedHangingProtocolRuntime.getHangingDefinition()).getSnapshot(0).setCacheDisplaySets(true);
                DataSelectionManager.getInstance().setActiveHanging(userDefinedHangingProtocolRuntime.getStudyContainer().getPatientRepresentation(), userDefinedHangingProtocolRuntime.getIdentifier());
            }
        }
    }

    @Override
    protected boolean isPopupMenuEnabled() {
        return !Product.isCDViewer() && !Product.isReducedVersion();
    }

    @Override
    protected IPopupMenuAction[] getPopupMenuActions() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        boolean bl = iHanging != null;
        boolean bl2 = bl && iHanging instanceof UserDefinedHangingProtocolRuntime;
        boolean bl3 = bl && iHanging instanceof Session;
        boolean bl4 = bl3 && Permissions.getInstance().isAllowed("ImageArea/AllowedToCreateAndSaveSessions");
        boolean bl5 = bl2 && !Product.isCDViewer();
        boolean bl6 = bl && iHanging instanceof SinglePatientHangingProtocolRuntime && Permissions.getInstance().isAllowed("ImageArea/AllowedToEditHangingProtocols") && DataSelectionManager.getInstance().getCurrentPatient() != null;
        ArrayList<HangingAction> arrayList = new ArrayList<HangingAction>();
        if (HangingUtil.isCreateSessionPossible(iHanging)) {
            arrayList.add(HangingAction.NEW_SESSION);
            arrayList.add(HangingAction.NEW_SESSION_MULTI_SNAPSHOT);
        }
        if (bl6) {
            arrayList.add(HangingAction.NEW_HANGING);
        }
        if (bl4) {
            arrayList.add(HangingAction.SAVE);
            arrayList.add(HangingAction.SAVE_NO_WORKLIST);
        }
        if (this.canEnableEditHangingAction(iHanging)) {
            arrayList.add(HangingAction.UPDATE);
            arrayList.add(HangingAction.DELETE);
        }
        if (bl3 && SessionDeleter.hasPermission()) {
            arrayList.add(HangingAction.DELETE_SESSION);
        }
        if (bl5) {
            arrayList.add(HangingAction.HIDE);
        }
        if (iHanging == null) {
            ArrayList<HangingAction> arrayList2 = new ArrayList<HangingAction>(1);
            arrayList2.add(HangingAction.NEW_SESSION);
            arrayList2.add(HangingAction.NEW_HANGING);
            arrayList.retainAll(arrayList2);
        }
        return arrayList.toArray(new IPopupMenuAction[arrayList.size()]);
    }

    private boolean canEnableEditHangingAction(IHanging iHanging) {
        return Permissions.getInstance().isAllowed("ImageArea/AllowedToEditHangingProtocols") && iHanging instanceof UserDefinedHangingProtocolRuntime;
    }

    @Override
    protected void initDataModel(IMutableSelectionModel<IHanging> iMutableSelectionModel) {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        IHanging iHanging = null;
        if (iPatientRepresentation != null) {
            iHanging = iPatientRepresentation.getActiveHanging();
        }
        if (iPatientRepresentation != null) {
            int n = 0;
            while (n < iPatientRepresentation.countHangings()) {
                IHanging iHanging2 = iPatientRepresentation.getHanging(n);
                iMutableSelectionModel.addElement(iHanging2);
                if (iHanging2 == iHanging) {
                    iMutableSelectionModel.setSelectedIndex(n);
                }
                ++n;
            }
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends IHanging> jList, IHanging iHanging, int n, boolean bl, boolean bl2) {
        HangingCellRenderer hangingCellRenderer = DEFAULT_CELL_RENDERER;
        if (HangingController.isMultiPatientHP(iHanging)) {
            hangingCellRenderer = BLINKING_CELL_RENDERER;
        }
        return ((MultiMonitorCellRenderer)hangingCellRenderer).getListCellRendererComponent(jList, iHanging, n, bl, bl2);
    }

    static String createToolTip(IHanging iHanging) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iHanging == null) {
            return null;
        }
        IStudyContainer iStudyContainer = iHanging.getStudyContainer();
        stringBuilder.append("<html>");
        String string = iHanging.getVisibleHint();
        if (string != null) {
            stringBuilder.append("<i>");
            stringBuilder.append(string);
            stringBuilder.append("</i><br />");
        }
        stringBuilder.append("<b>");
        stringBuilder.append(String.valueOf(Messages.getString("HangingController.NameOfHanging")) + ": </b>");
        stringBuilder.append(iHanging.getVisibleName());
        if (iStudyContainer != null) {
            Date date;
            IStudyData iStudyData = iStudyContainer.getBaseStudy();
            if (iStudyData != null) {
                date = DateTimeUtils.getStudyDateTime((Attributes)iStudyData.getDicomObject());
                stringBuilder.append("<br><b>");
                stringBuilder.append(Messages.getString("HangingController.BaseStudy"));
                stringBuilder.append(": </b>");
                String string2 = iStudyData.getDicomObject().getString(528432);
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                if (date != null) {
                    stringBuilder.append(" [");
                    stringBuilder.append(DateTimeUtils.dateTime2String((Date)date));
                    stringBuilder.append(']');
                }
            }
            int n = 0;
            int n2 = 0;
            while (n2 < iStudyContainer.getRelevantPriorCount()) {
                date = iStudyContainer.getPriorInfo(n2);
                if (n >= 5) {
                    int n3 = iStudyContainer.getRelevantPriorCount() - n;
                    stringBuilder.append("<br><b>");
                    stringBuilder.append(Messages.getString("HangingController.RemainingPriors.1"));
                    stringBuilder.append(' ');
                    stringBuilder.append(n3);
                    stringBuilder.append(' ');
                    stringBuilder.append(Messages.getString("HangingController.RemainingPriors.2"));
                    stringBuilder.append("</b>");
                    break;
                }
                Date date2 = DateTimeUtils.getStudyDateTime((IDataInfo)date);
                stringBuilder.append("<br><b>");
                stringBuilder.append(n2 + 1);
                stringBuilder.append(". ");
                stringBuilder.append(Messages.getString("HangingController.Prior")).append(": </b>");
                String string3 = date.getAttributes().getString(528432);
                if (string3 != null) {
                    stringBuilder.append(string3);
                }
                if (date2 != null) {
                    stringBuilder.append(" [");
                    stringBuilder.append(DateTimeUtils.dateTime2String((Date)date2));
                    stringBuilder.append(']');
                }
                ++n;
                ++n2;
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    @Override
    protected void afterRefresh() {
        SnapshotController.getInstance().refresh();
    }

    public void repaintViews() {
        for (ISelectionView iSelectionView : this.getViews()) {
            iSelectionView.getUIComponent().repaint();
        }
    }

    private static boolean isMultiPatientHP(IHanging iHanging) {
        return iHanging != null && MULTI_PATIENT_HP.equals(iHanging.getIdentifier());
    }

    private static class BlinkingListCellRenderer
    extends HangingCellRenderer
    implements ActionListener {
        private static final int MINIMUM_COLOR_DIFFERENCE = -10;
        private final int foreground;
        private final int background = this.selectionBackgroundColor.getBlue();
        private Timer timer = null;
        private int direction;
        private int currentForeground;

        public BlinkingListCellRenderer() {
            this.foreground = this.selectionForegroundColor.getBlue();
        }

        @Override
        public void setSelected(boolean bl) {
        }

        void startBlinking() {
            if (this.timer == null) {
                this.timer = new Timer(26, this);
                this.timer.setCoalesce(true);
                this.timer.start();
                this.direction = -1;
                this.currentForeground = this.foreground;
                super.setSelected(true);
            }
        }

        void stopBlinking() {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            super.setSelected(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.currentForeground += 4 * this.direction;
            if (this.currentForeground > 255 || this.currentForeground < this.background + -10) {
                this.direction *= -1;
                return;
            }
            this.setForeground(new Color(this.currentForeground, this.currentForeground, this.currentForeground));
            HangingController.getInstance().repaintViews();
        }
    }

    private class DataUpdateListener
    extends DataManagerListenerAdapter {
        private DataUpdateListener() {
        }

        @Override
        public void patientRepresentationModified(IPatientRepresentation iPatientRepresentation) {
            if (iPatientRepresentation == DataSelectionManager.getInstance().getCurrentPatient()) {
                HangingController.this.refresh();
            }
        }

        @Override
        public void patientRemoved(IPatientRepresentation iPatientRepresentation, boolean bl) {
            if (log.isDebugEnabled()) {
                log.debug("patientRemoved: " + (iPatientRepresentation != null ? Integer.valueOf(iPatientRepresentation.hashCode()) : "null"));
            }
            HangingController.this.refresh();
        }

        @Override
        public void hangingStateRemoved(IHanging iHanging) {
            if (log.isDebugEnabled()) {
                log.debug("hangingStateRemoved: " + iHanging);
            }
            if (HangingUtil.belongsToCurrentPatient(iHanging)) {
                HangingController.this.refresh();
            }
        }
    }

    private static class HangingCellRenderer
    extends MultiMonitorCellRenderer<IHanging> {
        HangingCellRenderer() {
            super(1, 1);
        }

        @Override
        public MultiMonitorCellRenderer<IHanging> getListCellRendererComponent(JList<? extends IHanging> jList, IHanging iHanging, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, iHanging, n, bl, bl2);
            ((JLabel)component).setIcon(iHanging == null ? null : iHanging.getIcon());
            return component;
        }

        @Override
        protected String getText(IHanging iHanging) {
            return iHanging.toString();
        }

        @Override
        protected String getToolTipText(IHanging iHanging, String string) {
            return HangingController.createToolTip(iHanging);
        }
    }

    private class SelectionChangeListener
    extends DataSelectionListenerAdapter {
        private SelectionChangeListener() {
        }

        @Override
        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            if (log.isDebugEnabled()) {
                log.debug("newPatientSelected: " + (iPatientRepresentation2 != null ? iPatientRepresentation2.toLoggingString() : "null"));
            }
            HangingController.this.refresh();
        }

        @Override
        public void newHangingCaseSelected(IPatientRepresentation iPatientRepresentation, IHanging iHanging, IHanging iHanging2, boolean bl) {
            if (log.isDebugEnabled()) {
                log.debug("hangingCaseChanged: " + iHanging2);
            }
            HangingController.this.refresh();
        }
    }
}

