/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.hanging;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.hanging.HangingController;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class HangingProtocolActions
implements PActionProvider {
    public static final String PREVIOUS = "PREVIOUS_HANGING_PROTOCOL";
    public static final String NEXT = "NEXT_HANGING_PROTOCOL";
    private static final DataSelectionManager DATA_SELECTION_MANAGER = DataSelectionManager.getInstance();

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new NextHangingProtocolAction());
        arrayList.add(new PrevHangingProtocolAction());
        arrayList.add(new SwitchToHangingProtocolAction(true));
        arrayList.add(new SwitchToHangingProtocolAction(false));
        return arrayList;
    }

    private abstract class AbstractHangingProtocolAction
    extends AbstractPAction {
        private String name;

        AbstractHangingProtocolAction(String string) {
            this.name = string;
        }

        @Override
        public String getCaption() {
            return Messages.getString("HangingProtocolActions." + this.name + ".Caption");
        }

        @Override
        public String getGroupName() {
            return HANGINGS_GROUP;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("HangingProtocolActions." + this.name + ".ToolTip");
        }
    }

    private class NextHangingProtocolAction
    extends AbstractHangingProtocolAction {
        NextHangingProtocolAction() {
            super("NEXT");
        }

        @Override
        public String getID() {
            return HangingProtocolActions.NEXT;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(40, 1);
        }

        @Override
        protected boolean isEnabledImpl() {
            return HangingController.getInstance().isRelativeChangePossible(1);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            HangingController.getInstance().setSelectedItemRelative(1);
            return true;
        }
    }

    private class PrevHangingProtocolAction
    extends AbstractHangingProtocolAction {
        PrevHangingProtocolAction() {
            super("PREV");
        }

        @Override
        public String getID() {
            return HangingProtocolActions.PREVIOUS;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(38, 1);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            HangingController.getInstance().setSelectedItemRelative(-1);
            return true;
        }

        @Override
        protected boolean isEnabledImpl() {
            return HangingController.getInstance().isRelativeChangePossible(-1);
        }
    }

    private class SwitchToHangingProtocolAction
    extends AbstractHangingProtocolAction {
        private static final String FIRST_HP_NEXT_BASE_STUDY = "FIRST_HP_NEXT_BASE_STUDY";
        private static final String FIRST_HP_PREVIOUS_BASE_STUDY = "FIRST_HP_PREVIOUS_BASE_STUDY";
        private static final String MESSAGES_NEXT = "NextHPBaseStudy";
        private static final String MESSAGES_PREVIOUS = "PreviousHPBaseStudy";
        private boolean nextHangingProtocol;

        SwitchToHangingProtocolAction(boolean bl) {
            super(bl ? MESSAGES_NEXT : MESSAGES_PREVIOUS);
            this.nextHangingProtocol = bl;
        }

        @Override
        public String getID() {
            return this.nextHangingProtocol ? FIRST_HP_NEXT_BASE_STUDY : FIRST_HP_PREVIOUS_BASE_STUDY;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            IPatientRepresentation iPatientRepresentation = DATA_SELECTION_MANAGER.getCurrentPatient();
            if (iPatientRepresentation != null) {
                if (!this.nextHangingProtocol) {
                    this.getHangingOfPreviousBaseStudy(iPatientRepresentation);
                } else {
                    this.getHangingOfNextBaseStudy(iPatientRepresentation);
                }
            }
            return true;
        }

        private void getHangingOfNextBaseStudy(IPatientRepresentation iPatientRepresentation) {
            IStudyData iStudyData = DATA_SELECTION_MANAGER.getActiveHanging().getStudyContainer().getBaseStudy();
            int n = HangingController.getInstance().getSelectedIndex();
            while (n < iPatientRepresentation.countHangings()) {
                IStudyData iStudyData2;
                IHanging iHanging = iPatientRepresentation.getHanging(n);
                if (!(iHanging instanceof IHangingSession) && iStudyData != (iStudyData2 = iHanging.getStudyContainer().getBaseStudy())) {
                    HangingController.getInstance().setSelectedItemRelative(n - HangingController.getInstance().getSelectedIndex());
                    break;
                }
                ++n;
            }
        }

        private void getHangingOfPreviousBaseStudy(IPatientRepresentation iPatientRepresentation) {
            IStudyData iStudyData = DATA_SELECTION_MANAGER.getActiveHanging().getStudyContainer().getBaseStudy();
            IStudyData iStudyData2 = null;
            int n = -1;
            int n2 = 0;
            while (n2 < HangingController.getInstance().getSelectedIndex()) {
                IHanging iHanging = iPatientRepresentation.getHanging(n2);
                if (!(iHanging instanceof IHangingSession)) {
                    IStudyData iStudyData3 = iHanging.getStudyContainer().getBaseStudy();
                    if (iStudyData == iStudyData3) break;
                    if (iStudyData3 != iStudyData2) {
                        iStudyData2 = iStudyData3;
                        n = n2;
                    }
                }
                ++n2;
            }
            if (n != -1) {
                HangingController.getInstance().setSelectedItemRelative(n - HangingController.getInstance().getSelectedIndex());
            }
        }
    }
}

