/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.hanging;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractDynamicGroupPAction;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.awt.Component;
import java.util.ArrayList;

public class HangingProtocolSelectionAction
extends AbstractDynamicGroupPAction {
    private static final ALogger LOG = ALogger.getLogger(HangingProtocolSelectionAction.class);
    private static final DataSelectionManager DATA_SELECTION_MANAGER = DataSelectionManager.getInstance();

    @Override
    public String getID() {
        return "HP_SELECTION_ACTION";
    }

    @Override
    public String getGroupName() {
        return HANGINGS_GROUP;
    }

    @Override
    public String getCaption() {
        return Messages.getString("Action.SelectHangingProtocol");
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public PAction[] createSubactions() {
        ArrayList<BaseStudyHangingProtocolAction> arrayList = new ArrayList<BaseStudyHangingProtocolAction>();
        try {
            IStudyData iStudyData = DATA_SELECTION_MANAGER.getActiveHanging().getStudyContainer().getBaseStudy();
            IPatientRepresentation iPatientRepresentation = DATA_SELECTION_MANAGER.getCurrentPatient();
            if (iPatientRepresentation != null) {
                int n = 0;
                while (n < iPatientRepresentation.countHangings()) {
                    IHanging iHanging = iPatientRepresentation.getHanging(n);
                    if (iStudyData == iHanging.getStudyContainer().getBaseStudy()) {
                        arrayList.add(new BaseStudyHangingProtocolAction(iPatientRepresentation, iHanging));
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            LOG.debug("Failed to determine base study", (Throwable)exception);
        }
        return arrayList.toArray(new PAction[arrayList.size()]);
    }

    private static class BaseStudyHangingProtocolAction
    extends AnonymousPAction {
        private IPatientRepresentation patientRepresentation;
        private IHanging hanging;

        public BaseStudyHangingProtocolAction(IPatientRepresentation iPatientRepresentation, IHanging iHanging) {
            this.patientRepresentation = iPatientRepresentation;
            this.hanging = iHanging;
        }

        @Override
        public String getCaption() {
            return this.hanging.getVisibleName();
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            DATA_SELECTION_MANAGER.setActiveHanging(this.patientRepresentation, this.hanging.getIdentifier());
            return true;
        }
    }
}

