/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.hanging.snapshots;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.gui.mvc.AbstractSelectionController;
import com.agfa.pacs.impaxee.gui.mvc.IMutableSelectionModel;
import com.agfa.pacs.impaxee.gui.mvc.IPopupMenuAction;
import com.agfa.pacs.impaxee.gui.mvc.SelectionView;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.DefaultHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.MultiPatientHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.hanging.snapshots.SnapshotAction;
import com.tiani.jvision.patinfo.hanging.snapshots.SnapshotView;
import java.awt.Component;

public class SnapshotController
extends AbstractSelectionController<AbstractSnapshotRuntime>
implements IHanging.SnapshotModel.Listener {
    private static final SnapshotController INSTANCE = new SnapshotController();
    private AbstractSnapshotRuntime pastedSnapshot;
    private IHanging.SnapshotModel snapshotModel;

    private SnapshotController() {
    }

    public static SnapshotController getInstance() {
        return INSTANCE;
    }

    public static SelectionView<AbstractSnapshotRuntime> createSnapshotView() {
        return new SnapshotView(INSTANCE);
    }

    @Override
    protected boolean isPopupMenuEnabled() {
        return !Product.isCDViewer() && (Permissions.getInstance().isAllowed("ImageArea/AllowedToEditHangingProtocols") || Permissions.getInstance().isAllowed("ImageArea/AllowedToCreateAndSaveSessions"));
    }

    public void createSnapshot() {
        DataSelectionManager.getInstance().setBlockCapturing(true);
        IHanging iHanging = this.getCurrentHanging();
        AbstractSnapshotRuntime abstractSnapshotRuntime = iHanging.getSnapshotModel().newInstance();
        if (abstractSnapshotRuntime instanceof HangingProtocolSnapshotRuntime) {
            ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).setUseRuntimeForSave(true);
        }
        iHanging.getSnapshotModel().add(abstractSnapshotRuntime);
        DataSelectionManager.getInstance().setBlockCapturing(false);
    }

    public void updateSnapshot() {
        int n = this.getAndCheckPosition();
        IHanging iHanging = this.getCurrentHanging();
        iHanging.getSnapshotModel().update(n);
    }

    public void removeSnapshot() {
        IHanging iHanging = this.getCurrentHanging();
        iHanging.getSnapshotModel().delete(this.getAndCheckPosition());
    }

    public void cutSnapshot() {
        IHanging iHanging = this.getCurrentHanging();
        this.pastedSnapshot = iHanging.getSnapshotModel().remove(this.getAndCheckPosition());
    }

    public void pasteBeforeSnapshot() {
        this.paste(this.getAndCheckPosition());
    }

    public void pasteAfterSnapshot() {
        this.paste(this.getAndCheckPosition() + 1);
    }

    private void paste(int n) {
        this.insertSnapshot(this.getCurrentHanging(), this.getAndCheckClipboard(), n);
        this.clearClipboard();
    }

    @Override
    protected void initDataModel(IMutableSelectionModel<AbstractSnapshotRuntime> iMutableSelectionModel) {
        IHanging iHanging;
        if (this.snapshotModel != null) {
            this.snapshotModel.removeListener(this);
        }
        AbstractSnapshotRuntime abstractSnapshotRuntime = (iHanging = DataSelectionManager.getInstance().getActiveHanging()) != null ? DataSelectionManager.getInstance().getActiveSnapshot(iHanging) : null;
        IHanging.SnapshotModel snapshotModel = this.snapshotModel = iHanging != null ? iHanging.getSnapshotModel() : null;
        if (this.snapshotModel == null) {
            return;
        }
        this.snapshotModel.removeListener(this);
        int n = this.snapshotModel.size();
        int n2 = 0;
        while (n2 < n) {
            AbstractSnapshotRuntime abstractSnapshotRuntime2 = this.snapshotModel.get(n2);
            iMutableSelectionModel.addElement(abstractSnapshotRuntime2);
            if (abstractSnapshotRuntime2 == abstractSnapshotRuntime) {
                this.snapshotModel.select(n2);
                iMutableSelectionModel.setSelectedIndex(n2);
            }
            ++n2;
        }
        this.snapshotModel.addListener(this);
    }

    @Override
    protected void afterRefresh() {
    }

    @Override
    public void selectionActivated(Component component, int n) {
        if (this.snapshotModel.getSelectedIndex() != n) {
            try {
                CursorUtil.setWaitCursor((Component)component);
                IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
                DataSelectionManager.getInstance().setActiveSnapshot(iHanging, (AbstractSnapshotRuntime)this.getElementAt(n), false, iHanging instanceof IHangingSession && !((IHangingSession)iHanging).isSaved());
                this.snapshotModel.select(n);
            }
            finally {
                CursorUtil.resetWaitCursor((Component)component);
            }
        }
    }

    @Override
    public void selectionDeactivated() {
        DataSelectionManager.getInstance().setActiveSnapshot(DataSelectionManager.getInstance().getActiveHanging(), null, false, false);
        this.snapshotModel.select(-1);
    }

    @Override
    protected IPopupMenuAction[] getPopupMenuActions() {
        this.enableActions();
        return SnapshotAction.values();
    }

    private void enableActions() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        boolean bl = iHanging instanceof HangingProtocolRuntime && Permissions.getInstance().isAllowed("ImageArea/AllowedToEditHangingProtocols") || iHanging instanceof IHangingSession && Permissions.getInstance().isAllowed("ImageArea/AllowedToCreateAndSaveSessions");
        boolean bl2 = (bl &= !(iHanging instanceof DefaultHangingProtocolRuntime) && !(iHanging instanceof MultiPatientHangingProtocolRuntime)) && this.snapshotModel.getSelectedIndex() >= 0;
        boolean bl3 = bl2 && this.getElementCount() > 1;
        SnapshotAction.CREATE.getSwingAction().setEnabled(bl);
        SnapshotAction.REMOVE.getSwingAction().setEnabled(bl3);
        SnapshotAction.CUT.getSwingAction().setEnabled(bl3);
        SnapshotAction.PASTE_BEFORE.getSwingAction().setEnabled(bl2 && !this.isClipboardEmpty());
        SnapshotAction.PASTE_AFTER.getSwingAction().setEnabled(bl2 && !this.isClipboardEmpty());
    }

    private IHanging getCurrentHanging() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        assert (iHanging != null) : "There must be a current hanging state for all snapshot actions!";
        return iHanging;
    }

    private int getAndCheckPosition() {
        int n = this.snapshotModel.getSelectedIndex();
        assert (n >= 0) : "No snapshot item is selected!";
        assert (this.getElementAt(n) == DataSelectionManager.getInstance().getActiveSnapshot()) : "Selected snapshot is not the one in selection manager!";
        return n;
    }

    private AbstractSnapshotRuntime getAndCheckClipboard() {
        assert (!this.isClipboardEmpty()) : "No pasted item present!";
        return this.pastedSnapshot;
    }

    private boolean isClipboardEmpty() {
        return this.pastedSnapshot == null;
    }

    private void clearClipboard() {
        this.pastedSnapshot = null;
    }

    private void insertSnapshot(IHanging iHanging, AbstractSnapshotRuntime abstractSnapshotRuntime, int n) {
        if (n < 0 || n > iHanging.getSnapshotModel().size()) {
            n = iHanging.getSnapshotModel().size();
        }
        iHanging.getSnapshotModel().insertAt(n, abstractSnapshotRuntime);
    }

    @Override
    public void snapshotAdded(int n, AbstractSnapshotRuntime abstractSnapshotRuntime) {
        this.snapshotModel.removeListener(this);
        this.insertElementAt(n, abstractSnapshotRuntime);
        this.snapshotModel.addListener(this);
    }

    @Override
    public void snapshotRemoved(int n) {
        this.removeElementAt(n);
    }

    @Override
    public void snapshotSelected(int n, int n2) {
        this.selectElementAt(n);
    }

    @Override
    public void snapshotUpdated(int n) {
    }
}

