/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.hap.pacs.data.AgeUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.impaxee.Messages;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.studies.StudyAgeChecker;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.dcm4che3.data.Attributes;

public class StudyAge {
    private final LocalDateTime studyDate;
    private final boolean isVisibleInDemographics;

    public StudyAge(IStudyData iStudyData) {
        this.studyDate = StudyAge.getStudyDate(iStudyData);
        this.isVisibleInDemographics = !StudyAgeChecker.isEnabled() || StudyAgeChecker.isOldStudy(iStudyData);
    }

    static double getStudyAgeInHours(IStudyData iStudyData) {
        return StudyAge.getHoursSince(StudyAge.getStudyDate(iStudyData));
    }

    private static double getHoursSince(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return Double.NaN;
        }
        return ChronoUnit.HOURS.between(localDateTime, LocalDateTime.now());
    }

    static LocalDateTime getStudyDate(IStudyData iStudyData) {
        Date date = DateTimeUtils.getStudyDateTime((Attributes)iStudyData.getDicomObject());
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public double toHours() {
        return StudyAge.getHoursSince(this.studyDate);
    }

    public String toDemographicsString() {
        if (this.isVisibleInDemographics) {
            return this.toString(null);
        }
        return null;
    }

    public String toString() {
        return this.toString("NaN");
    }

    private String toString(String string) {
        if (this.studyDate == null) {
            return string;
        }
        long l = ChronoUnit.HOURS.between(this.studyDate, LocalDateTime.now());
        if (l < 24L) {
            return this.toString(l, "Hour");
        }
        AgeUtil.Age age = AgeUtil.calculateAge((LocalDate)this.studyDate.toLocalDate(), (LocalDate)LocalDate.now(), (long)60L, (long)0L, (long)24L);
        return this.toString(age.getValue(), age.getUnit().name());
    }

    private String toString(long l, String string) {
        return "" + l + ' ' + Messages.getString("StudyAge.TimePeriod." + string);
    }
}

