/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.integration.IntegrationFrameworkFactory;
import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.listtext.cycling.CycleListProviderFactory;
import com.agfa.pacs.listtext.cycling.ICycleListProvider;
import com.agfa.pacs.listtext.lta.priors.IPriorsHook;
import com.agfa.pacs.listtext.lta.priors.PriorHooksFactory;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.studies.StudyAge;
import com.tiani.util.message.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Tag;

public class StudyAgeChecker
extends DataSelectionListenerAdapter {
    public static final String STUDY_OBJECT_NAME = "Study";
    public static final String ATTRIBUTES_OBJECT_NAME = "Attributes";
    private static final ALogger LOGGER = ALogger.getLogger(StudyAgeChecker.class);
    private static final String SCRIPT = Config.impaxee.jvision.LOADING.StudyAgeCheck.Script.get();
    private static final int MESSAGE_POPUP_TIMEOUT = (int)Config.impaxee.jvision.LOADING.StudyAgeCheck.PopupTimeout.get();
    private static boolean isInitialized;

    private StudyAgeChecker() {
    }

    public static synchronized void init() {
        if (!isInitialized) {
            LOGGER.debug("Initializing study age checker");
            DataSelectionManager.getInstance().addListener(new StudyAgeChecker());
            isInitialized = true;
        }
    }

    @Override
    public void newActiveStudySelected(IStudyData iStudyData) {
        if (iStudyData != null) {
            IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey());
            ICycleListProvider iCycleListProvider = CycleListProviderFactory.getInstance().getCycleListProvider();
            if (iPatientRepresentation != null && !iCycleListProvider.isCurrentWorklistInConference()) {
                StudyAgeChecker.check(iPatientRepresentation);
            }
        }
    }

    public static boolean isEnabled() {
        return Config.impaxee.jvision.LOADING.StudyAgeCheck.isEnabled.get();
    }

    private static void check(IPatientRepresentation iPatientRepresentation) {
        ArrayList<IStudyContainer> arrayList = new ArrayList<IStudyContainer>(iPatientRepresentation.getStudyContainers());
        if (StudyAgeChecker.isEnabled() && StudyAgeChecker.hasOldStudies(arrayList)) {
            Message.showMessagePopup(Messages.getString("StudyAgeChecker.StudyTooOld"), MESSAGE_POPUP_TIMEOUT);
        }
        StudyAgeChecker.disableStudyAgeCheck(arrayList);
    }

    private static boolean hasOldStudies(Iterable<IStudyContainer> iterable) {
        for (IStudyContainer iStudyContainer : iterable) {
            if (!iStudyContainer.isStudyAgeCheckEnabled() || !StudyAgeChecker.isOldStudy(iStudyContainer.getBaseStudy())) continue;
            return true;
        }
        return false;
    }

    static boolean isOldStudy(IStudyData iStudyData) {
        try {
            HashMap<String, StudyInformation> hashMap = new HashMap<String, StudyInformation>();
            hashMap.put(STUDY_OBJECT_NAME, new StudyInformation((IStudyInfo)iStudyData.getQueryObject()));
            hashMap.put(ATTRIBUTES_OBJECT_NAME, (StudyInformation)new Attributes(iStudyData.getDicomObject()));
            hashMap.put(Tag.class.getSimpleName(), (StudyInformation)new Tag());
            Object object = IntegrationFrameworkFactory.getInstance().createScriptObject(SCRIPT, hashMap);
            if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                double d2 = StudyAge.getStudyAgeInHours(iStudyData);
                return !Double.isNaN(d2) && d < d2;
            }
            LOGGER.error("Illegal return value of type {} for study age limit: {}", (Object)StudyAgeChecker.getClass(object).getName(), object);
        }
        catch (Exception exception) {
            LOGGER.error("Determining study age limit failed", (Throwable)exception);
        }
        return false;
    }

    private static void disableStudyAgeCheck(Iterable<IStudyContainer> iterable) {
        for (IStudyContainer iStudyContainer : iterable) {
            iStudyContainer.disableStudyAgeCheck();
        }
    }

    private static Class<? extends Object> getClass(Object object) {
        return object == null ? Void.class : object.getClass();
    }

    static IPriorsHook initPriorsHook() {
        List list = PriorHooksFactory.getInstance().getPriorsHooks();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (IPriorsHook)list.get(0);
    }

    public static class StudyInformation {
        private static final IPriorsHook PRIORS_HOOK = StudyAgeChecker.initPriorsHook();
        private final IStudyInfo study;

        StudyInformation(IStudyInfo iStudyInfo) {
            this.study = iStudyInfo;
        }

        public List<String> getModalitiesInStudy() {
            String[] stringArray = DicomUtils.getModalitiesInStudy((IStudyInfo)this.study, (boolean)true);
            if (stringArray == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(stringArray);
        }

        public boolean isModality(String string) {
            return this.getModalitiesInStudy().contains(string.toUpperCase(Locale.ENGLISH));
        }

        public List<String> getBodyPartGroups() {
            return PRIORS_HOOK.getGroupNames(this.study);
        }

        public boolean isBodyPartGroup(String string) {
            for (String string2 : this.getBodyPartGroups()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
    }
}

