/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.ListenerSynchronizationFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.listtext.swingx.borders.CustomLineBorder;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.Modes;
import com.tiani.jvision.patinfo.studies.StudyTablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class StudyDividerPanel
extends JPanel {
    private static final IEventEngine engine = EventEngineFactory.getInstance();
    private static final String STUDY_DIVIDER_EVENT_PATH = "StudyDividerPanel.EventPath";
    private static final String STUDYLIST_EXPANDED_EVENT = "STUDYLIST_EXPANDED";
    private static final String STUDYLIST_COLLAPSED_EVENT = "STUDYLIST_COLLAPSED";
    private static final int STUDYLIST_EXPANDED_EVENT_ID = engine.getEventID("STUDYLIST_EXPANDED");
    private static final int STUDYLIST_COLLAPSED_EVENT_ID = engine.getEventID("STUDYLIST_COLLAPSED");
    private static final int BORDER_DISTANCE = GUI.getScaledDiagnosticInt((int)4);
    private static final ALogger log = ALogger.getLogger(StudyDividerPanel.class);
    private StudyTablePanel studyPanel;
    private JComponent seriesPanel;
    private JComponent hangingPanel;
    private JComponent patLabel;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JPanel dividerPanel;
    private JPanel groupPanel;
    private JComponent loadingIndicator;
    private DividerButton dividerButton;
    private boolean expanded;

    public StudyDividerPanel(JComponent jComponent, StudyTablePanel studyTablePanel, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4) {
        this.studyPanel = studyTablePanel;
        this.seriesPanel = jComponent2;
        this.hangingPanel = jComponent4;
        this.patLabel = jComponent;
        this.loadingIndicator = jComponent3;
        this.expanded = Config.impaxee.jvision.SEQPANEL.StudyListExpanded.get();
        if (JVision2.getMainFrame().getPaletteOrientation().isHorizontal()) {
            this.expanded = true;
        }
        this.createComponents();
        this.initComponents();
        this.installLayout();
        IEventListenerProvider iEventListenerProvider = EventEngineFactory.getInstance().createListenerProvider((IEventListener)new StudyListExpansionListener());
        engine.register(iEventListenerProvider, STUDY_DIVIDER_EVENT_PATH);
    }

    public JComponent getSeriesPanel() {
        return this.seriesPanel;
    }

    public JComponent getHangingPanel() {
        return this.hangingPanel;
    }

    private void createComponents() {
        this.topPanel = new JPanel();
        this.centerPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.groupPanel = new JPanel();
        this.dividerPanel = new JPanel();
        this.dividerButton = new DividerButton();
    }

    private void initComponents() {
        this.dividerPanel.setBorder(null);
        this.dividerButton.setBorder(null);
        StudyDividerPanel.resetBorderInComponentHierarchy(this.studyPanel);
        StudyDividerPanel.resetBorderInComponentHierarchy(this.seriesPanel);
        StudyDividerPanel.resetBorderInComponentHierarchy(this.hangingPanel);
        this.topPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.centerPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        Modes.PaletteOrientation paletteOrientation = JVision2.getMainFrame().getPaletteOrientation();
        int n = paletteOrientation.isHorizontal() ? BORDER_DISTANCE : 0;
        int n2 = paletteOrientation.isHorizontal() ? 0 : BORDER_DISTANCE;
        this.bottomPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(n2, n, 0, 0), BorderFactory.createLoweredBevelBorder()));
        this.setBorder(BorderFactory.createEmptyBorder(BORDER_DISTANCE, n / 2, BORDER_DISTANCE, 0));
        this.setExpanded(this.expanded, false, false);
    }

    private void installLayout() {
        this.topPanel.setLayout(new BorderLayout(0, 0));
        this.topPanel.add((Component)this.patLabel, "North");
        this.topPanel.add((Component)this.studyPanel, "Center");
        Modes.PaletteOrientation paletteOrientation = JVision2.getMainFrame().getPaletteOrientation();
        this.centerPanel.setLayout(new BorderLayout(0, 0));
        this.centerPanel.add((Component)this.seriesPanel, "Center");
        this.centerPanel.add((Component)this.loadingIndicator, paletteOrientation == Modes.PaletteOrientation.SOUTH ? "North" : "South");
        this.dividerPanel.setPreferredSize(new Dimension(10, 12));
        this.dividerPanel.setLayout(new BorderLayout(0, 0));
        this.dividerPanel.add((Component)this.dividerButton, "Center");
        this.bottomPanel.setLayout(new BorderLayout(0, 0));
        this.bottomPanel.add((Component)this.hangingPanel, "Center");
        this.groupPanel.setLayout(new BorderLayout(0, 0));
        this.groupPanel.add((Component)this.topPanel, "Center");
        if (!paletteOrientation.isHorizontal()) {
            this.groupPanel.add((Component)this.dividerPanel, "South");
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.groupPanel, paletteOrientation.isHorizontal() ? "West" : "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.bottomPanel, paletteOrientation.isHorizontal() ? "East" : "South");
    }

    private void setExpanded(boolean bl, boolean bl2, boolean bl3) {
        this.expanded = bl;
        if (bl) {
            this.dividerPanel.setBorder(null);
            this.topPanel.setVisible(true);
        } else {
            this.dividerPanel.setBorder((Border)new CustomLineBorder(false, true, false, false));
            this.topPanel.setVisible(false);
        }
        this.dividerButton.repaint();
        if (bl3) {
            Config.impaxee.jvision.SEQPANEL.StudyListExpanded.set(this.expanded);
        }
        if (bl2) {
            this.fireDividerEvent(bl ? STUDYLIST_EXPANDED_EVENT_ID : STUDYLIST_COLLAPSED_EVENT_ID);
        }
    }

    private void fireDividerEvent(int n) {
        IEvent iEvent = engine.createEvent(n, null, (Object)this, null, ActionInfo.SINGLE);
        iEvent.setDestination(null, STUDY_DIVIDER_EVENT_PATH);
        engine.sendEvent(iEvent);
    }

    private static void resetBorderInComponentHierarchy(Container container) {
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(null);
        }
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(null);
            }
            if (component instanceof Container) {
                StudyDividerPanel.resetBorderInComponentHierarchy((Container)component);
            }
            ++n2;
        }
    }

    private class DividerButton
    extends JButton {
        int[][] buffer;
        Color controlInfo;
        Color controlHighlight;
        Color controlDkShadow;

        public DividerButton() {
            int[][] nArrayArray = new int[5][];
            int[] nArray = new int[9];
            nArray[3] = 2;
            nArray[4] = 2;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[9];
            nArray2[2] = 2;
            nArray2[3] = 1;
            nArray2[4] = 1;
            nArray2[5] = 1;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[9];
            nArray3[1] = 2;
            nArray3[2] = 1;
            nArray3[3] = 1;
            nArray3[4] = 1;
            nArray3[5] = 1;
            nArray3[6] = 1;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[9];
            nArray4[0] = 2;
            nArray4[1] = 1;
            nArray4[2] = 1;
            nArray4[3] = 1;
            nArray4[4] = 1;
            nArray4[5] = 1;
            nArray4[6] = 1;
            nArray4[7] = 1;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[9];
            nArray5[1] = 3;
            nArray5[2] = 3;
            nArray5[3] = 3;
            nArray5[4] = 3;
            nArray5[5] = 3;
            nArray5[6] = 3;
            nArray5[7] = 3;
            nArray5[8] = 3;
            nArrayArray[4] = nArray5;
            this.buffer = nArrayArray;
            this.controlInfo = this.getControlInfo();
            this.controlHighlight = this.getControlHighlight();
            this.controlDkShadow = this.getControlDkShadow();
            this.setRequestFocusEnabled(false);
            this.setVerticalAlignment(0);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setToolTipText(this.getToolTipTextInt());
            this.addMouseListener(new MouseHighlightListener());
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    DividerButton.this.repaint();
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    DividerButton.this.repaint();
                }
            });
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DividerButton.this.resetHighlight();
                    StudyDividerPanel.this.setExpanded(!StudyDividerPanel.this.expanded, true, true);
                    DividerButton.this.setToolTipText(DividerButton.this.getToolTipTextInt());
                }
            });
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public void paint(Graphics graphics) {
            Color[] colorArray = new Color[]{this.getBackground(), this.controlInfo, this.controlHighlight, this.controlDkShadow};
            graphics.setColor(this.getBackground());
            if (this.isOpaque()) {
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.getModel().isPressed()) {
                colorArray[1] = colorArray[2];
            }
            int n = this.getInsets().left + this.getWidth() / 2;
            int n2 = this.getInsets().top + this.getHeight() / 2;
            int n3 = n - this.buffer[0].length / 2;
            int n4 = n2 - this.buffer.length / 2;
            int n5 = 1;
            while (n5 <= this.buffer[0].length) {
                int n6 = 1;
                while (n6 < this.buffer.length) {
                    if (this.buffer[n6 - 1][n5 - 1] != 0) {
                        graphics.setColor(colorArray[this.buffer[n6 - 1][n5 - 1]]);
                        if (StudyDividerPanel.this.expanded) {
                            graphics.drawLine(n3 + n5, n4 + n6, n3 + n5, n4 + n6);
                        } else {
                            graphics.drawLine(n3 + n5, n4 + this.buffer.length - n6, n3 + n5, n4 + this.buffer.length - n6);
                        }
                    }
                    ++n6;
                }
                ++n5;
            }
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        private String getToolTipTextInt() {
            return StudyDividerPanel.this.expanded ? Messages.getString("StudiesDivider.Expanded.ToolTipText") : Messages.getString("StudiesDivider.Collapsed.ToolTipText");
        }

        private Color getControlInfo() {
            Color color = UIManager.getColor("color.primary.4");
            if (color == null) {
                color = UIManager.getColor("infoText");
            }
            return color;
        }

        private Color getControlHighlight() {
            Color color = UIManager.getColor("color.primary.3");
            if (color == null) {
                color = UIManager.getColor("controlHighlight");
            }
            return color;
        }

        private Color getControlDkShadow() {
            Color color = Color.BLACK;
            if (color == null) {
                color = UIManager.getColor("controlDkShadow");
            }
            return color;
        }

        private void setHighlight() {
            this.controlInfo = ColorUtils.brighter((Color)this.controlInfo, (float)0.7f);
            this.controlHighlight = ColorUtils.brighter((Color)this.controlHighlight, (float)0.7f);
            this.controlDkShadow = ColorUtils.brighter((Color)this.controlDkShadow, (float)0.7f);
        }

        private void resetHighlight() {
            this.controlInfo = this.getControlInfo();
            this.controlHighlight = this.getControlHighlight();
            this.controlDkShadow = this.getControlDkShadow();
        }

        class MouseHighlightListener
        extends MouseAdapter {
            MouseHighlightListener() {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                DividerButton.this.setHighlight();
                DividerButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                DividerButton.this.resetHighlight();
                DividerButton.this.repaint();
            }
        }
    }

    private class StudyListExpansionListener
    implements IEventListener {
        private IListenerSynchronization sync = ListenerSynchronizationFactory.getInstance();

        private StudyListExpansionListener() {
        }

        public boolean handleEvent(IEvent iEvent) {
            Object object = iEvent.getSource();
            if (object instanceof StudyDividerPanel && object != StudyDividerPanel.this && (iEvent.getEventID() == STUDYLIST_EXPANDED_EVENT_ID || iEvent.getEventID() == STUDYLIST_COLLAPSED_EVENT_ID)) {
                boolean bl = iEvent.getEventID() == STUDYLIST_EXPANDED_EVENT_ID;
                try {
                    StudyDividerPanel.this.setExpanded(bl, false, false);
                }
                catch (Exception exception) {
                    log.error("Expanding/Collapsing study-list failed!", (Throwable)exception);
                }
            }
            return true;
        }

        public IListenerSynchronization getSync() {
            return this.sync;
        }
    }
}

