/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.runtime.UserDefinedHangingProtocolRuntime;
import com.agfa.pacs.impaxee.keyimages.KeyImageStudyExpansion;
import com.agfa.pacs.listtext.swingx.controls.treetable.AbstractCellEditor;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorTable;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.studies.StudyTableController;
import com.tiani.jvision.patinfo.studies.StudyTableData;
import com.tiani.jvision.patinfo.studies.StudyTableModel;
import com.tiani.jvision.patinfo.studies.StudyTableTransferable;
import com.tiani.jvision.patinfo.studies.SwitchPriorsGroupAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class StudyTable
extends MultiMonitorTable {
    private static final ALogger log = ALogger.getLogger(StudyTable.class);
    private StudyTableController controller;

    StudyTable(StudyTableController studyTableController) {
        super(new StudyTableModel(), new StudyTableColumnModel());
        this.controller = studyTableController;
        this.setOpaque(false);
        this.setBorder(null);
        this.setTableHeader(null);
        this.setShowVerticalLines(false);
        this.setSelectionMode(0);
        this.setAutoscrolls(false);
        this.setAutoResizeMode(3);
        this.setDefaultRenderer(String.class, new TextCellRenderer());
        this.setDefaultRenderer(Icon.class, new IconCellRenderer());
        this.setDefaultEditor(Icon.class, new IconCellEditor());
        if (!Product.isHeadless()) {
            this.setTransferHandler(new StudyTableRowTransferHandler());
            this.setDragEnabled(true);
            this.setDropTarget(null);
        }
        this.setShowHorizontalLines(true);
        this.setGridColor(UIManager.getColor("color.primary.2"));
        StudyTableMouseListener studyTableMouseListener = new StudyTableMouseListener(studyTableController);
        this.addMouseListener(studyTableMouseListener);
        this.addMouseMotionListener(studyTableMouseListener);
        ComponentFactory.instance.scaleFont(this);
    }

    @Override
    public StudyTableModel getModel() {
        return (StudyTableModel)super.getModel();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (JVision2.getMainFrame().getPaletteOrientation().isHorizontal()) {
            return new Dimension(GUI.getScaledDiagnosticInt((int)224), Integer.MAX_VALUE);
        }
        return new Dimension(Integer.MAX_VALUE, GUI.getScaledDiagnosticInt((int)160));
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    private class IconCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final String TOGGLE_VISIBILITY_ACTION = "TOGGLE_VISIBILITY";
        private static final String TOGGLE_EXPAND_ACTION = "TOGGLE_EXPAND";
        private static final String REMOVE_STUDY_ACTION = "REMOVE_STUDY";
        private static final String STUDY_ROW_KEY = "STUDY_ROW";
        private final CompoundBorder rolloverBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(UIManager.getColor("Label.foreground")));
        private JPanel panel;
        private JButton btn = new JButton();
        private JPanel btnPanel;

        public IconCellEditor() {
            this.btn.setHorizontalAlignment(0);
            this.btn.setVerticalAlignment(0);
            this.btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    Integer n = (Integer)((JButton)actionEvent.getSource()).getClientProperty(IconCellEditor.STUDY_ROW_KEY);
                    if (n != null && n >= 0) {
                        StudyTableData studyTableData = StudyTable.this.getModel().getStudyAt(n);
                        if (IconCellEditor.TOGGLE_VISIBILITY_ACTION.equals(string)) {
                            boolean bl = StudyTable.this.controller.isStudyOpen(studyTableData);
                            StudyTable.this.controller.setStudyOpen(studyTableData, !bl);
                        } else if (IconCellEditor.REMOVE_STUDY_ACTION.equals(string)) {
                            StudyTable.this.controller.removeStudy(studyTableData);
                        } else if (IconCellEditor.TOGGLE_EXPAND_ACTION.equals(string)) {
                            KeyImageStudyExpansion.getInstance().toggleExpansionState(studyTableData.getStudy());
                        }
                    }
                    IconCellEditor.this.stopCellEditing();
                }
            });
            this.btnPanel = new JPanel();
            this.btnPanel.setOpaque(false);
            this.btnPanel.setLayout(new BorderLayout(0, 0));
            this.btnPanel.add((Component)this.btn, "Center");
            this.panel = new JPanel();
            this.panel.setOpaque(false);
            this.panel.setLayout(new BorderLayout(0, 0));
            this.panel.add((Component)this.btnPanel, "North");
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            switch (n2) {
                case 0: {
                    this.btnPanel.remove(this.btn);
                    this.btnPanel.add((Component)this.btn, "Center");
                    this.btn.setActionCommand(REMOVE_STUDY_ACTION);
                    break;
                }
                case 1: {
                    this.btnPanel.remove(this.btn);
                    this.btnPanel.add((Component)this.btn, "East");
                    this.btn.setActionCommand(TOGGLE_VISIBILITY_ACTION);
                    break;
                }
                case 2: {
                    this.btnPanel.remove(this.btn);
                    this.btnPanel.add((Component)this.btn, "East");
                    this.btn.setActionCommand(TOGGLE_EXPAND_ACTION);
                }
            }
            this.btn.putClientProperty(STUDY_ROW_KEY, n);
            this.btn.setIcon((Icon)object);
            this.btn.setBorder(this.rolloverBorder);
            return this.panel;
        }
    }

    private static class IconCellRenderer
    extends JComponent
    implements TableCellRenderer {
        private static final Border border = BorderFactory.createEmptyBorder(3, 1, 3, 1);
        private static final CompoundBorder rolloverBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(UIManager.getColor("Label.foreground")));
        private JLabel iconRenderer = new JLabel();
        private JLabel textRenderer = null;
        private int rolloverRow = -1;
        private int rolloverColumn = -1;
        private JPanel rendererPanel;

        public IconCellRenderer() {
            this.iconRenderer.setHorizontalAlignment(0);
            this.iconRenderer.setVerticalAlignment(0);
            this.iconRenderer.setOpaque(false);
            this.iconRenderer.setBorder(border);
            this.textRenderer = new JLabel();
            this.textRenderer.setHorizontalAlignment(0);
            this.textRenderer.setVerticalAlignment(0);
            this.textRenderer.setOpaque(false);
            this.rendererPanel = new JPanel();
            this.rendererPanel.setOpaque(false);
            this.rendererPanel.setLayout(new BorderLayout(0, 0));
            this.rendererPanel.add((Component)this.iconRenderer, "Center");
            this.rendererPanel.add((Component)this.textRenderer, "South");
            this.setLayout(new BorderLayout(0, 0));
            this.add((Component)this.rendererPanel, "North");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Insets insets = this.iconRenderer.getInsets();
            this.iconRenderer.setText(null);
            this.iconRenderer.setIcon((Icon)object);
            if (object != null) {
                int n3 = ((Icon)object).getIconWidth() + insets.left + insets.right;
                this.iconRenderer.setPreferredSize(new Dimension(n3, ((Icon)object).getIconHeight() + insets.top + insets.bottom));
                this.textRenderer.setPreferredSize(new Dimension(n3, GUI.getScaledInt((int)14)));
            }
            StudyTableData studyTableData = ((StudyTable)jTable).getModel().getStudyAt(n);
            String string = null;
            switch (n2) {
                case 0: {
                    this.rendererPanel.remove(this.iconRenderer);
                    this.rendererPanel.add((Component)this.iconRenderer, "Center");
                    string = Messages.getString("StudiesPanel.RemoveStudy.ToolTipText");
                    break;
                }
                case 1: {
                    this.rendererPanel.remove(this.iconRenderer);
                    this.rendererPanel.add((Component)this.iconRenderer, "East");
                    if (studyTableData.isOpen()) {
                        string = Messages.getString("StudiesPanel.StudyOpened.ToolTipText");
                        break;
                    }
                    string = Messages.getString("StudiesPanel.StudyClosed.ToolTipText");
                    break;
                }
                case 2: {
                    this.rendererPanel.remove(this.iconRenderer);
                    this.rendererPanel.add((Component)this.iconRenderer, "East");
                    if (!studyTableData.isCollapsable()) break;
                    string = studyTableData.isCollapsed() ? Messages.getString("StudiesPanel.StudyCollapsed.ToolTipText") : Messages.getString("StudiesPanel.StudyExpanded.ToolTipText");
                }
            }
            this.setToolTipText(string);
            if (this.rolloverRow == n && this.rolloverColumn == n2 && jTable.isCellEditable(n, n2)) {
                this.iconRenderer.setBorder(rolloverBorder);
            } else {
                this.iconRenderer.setBorder(border);
            }
            int n4 = studyTableData.getPriorIndex();
            this.textRenderer.setText(n4 <= 0 || n2 > 0 ? null : String.valueOf(Messages.getString("StudyTable.Priors")) + Integer.toString(n4));
            StudyTableData studyTableData2 = ((StudyTableModel)jTable.getModel()).getStudyAt(n);
            Color color = Mapping.getMappingColor(studyTableData2.getStudy().getStudyInstanceUID());
            this.textRenderer.setForeground(color);
            return this;
        }

        private void setRolloverBorder(int n, int n2) {
            this.rolloverRow = n;
            this.rolloverColumn = n2;
        }

        private void resetRolloverBorder() {
            this.rolloverRow = -1;
            this.rolloverColumn = -1;
        }
    }

    private static class Make1stPrior
    extends AbstractAction {
        private StudyTableData study;

        public Make1stPrior(StudyTableData studyTableData) {
            super(Messages.getString("Make1stPrior"));
            this.study = studyTableData;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            if (iHanging == null || !(iHanging instanceof UserDefinedHangingProtocolRuntime)) {
                return;
            }
            IStudyContainer iStudyContainer = iHanging.getStudyContainer();
            if (iStudyContainer == null) {
                return;
            }
            iStudyContainer.reorderStudy(this.study.getStudy().getKey(), 0);
            SwitchPriorsGroupAction.updateHPAfterPriorReorder(iHanging);
        }
    }

    private static class StudyTableColumnModel
    extends DefaultTableColumnModel {
        public StudyTableColumnModel() {
            this.getSelectionModel().setSelectionMode(0);
            int n = GUI.getScaledDiagnosticInt((int)16) + 2;
            this.addColumn(new TableColumn(0, n){

                @Override
                public int getMaxWidth() {
                    return this.width;
                }

                @Override
                public int getMinWidth() {
                    return this.width;
                }
            });
            this.addColumn(new TableColumn(1, (int)(1.2 * (double)n)){

                @Override
                public int getMaxWidth() {
                    return (int)(1.2 * (double)this.width);
                }

                @Override
                public int getMinWidth() {
                    return (int)(1.2 * (double)this.width);
                }
            });
            this.addColumn(new TableColumn(2, (int)(1.2 * (double)n)){

                @Override
                public int getMaxWidth() {
                    return this.width;
                }

                @Override
                public int getMinWidth() {
                    return this.width;
                }
            });
            this.addColumn(new TableColumn(3, 1024));
        }
    }

    private static class StudyTableMouseListener
    extends MouseAdapter {
        private StudyTableController controller;

        public StudyTableMouseListener(StudyTableController studyTableController) {
            this.controller = studyTableController;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getComponent();
            jTable.setCursor(Cursor.getDefaultCursor());
            this.resetAllRolloverBorders(jTable);
            this.resetAllStudyHighlights(jTable);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            StudyTable studyTable = (StudyTable)mouseEvent.getComponent();
            int n = studyTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = studyTable.columnAtPoint(mouseEvent.getPoint());
            if (n2 == 3 && n >= 0 && n <= studyTable.getRowCount()) {
                StudyTableData studyTableData = studyTable.getModel().getStudyAt(n);
                if (mouseEvent.getButton() == 1 || mouseEvent.getButton() == 0) {
                    this.controller.jumpToStudy(studyTableData, true);
                } else if (mouseEvent.getButton() == 3) {
                    if (studyTableData.getPriorIndex() <= 1) {
                        return;
                    }
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(ComponentFactory.instance.createMenuItem(new Make1stPrior(studyTableData)));
                    jPopupMenu.show(studyTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            StudyTable studyTable = (StudyTable)mouseEvent.getComponent();
            int n = studyTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = studyTable.columnAtPoint(mouseEvent.getPoint());
            this.resetAllRolloverBorders(studyTable);
            this.setRolloverBorder(studyTable, n, n2);
            this.resetAllStudyHighlights(studyTable);
            this.setStudyHighlight(studyTable, n, n2);
            if (n >= 0) {
                StudyTableData studyTableData = studyTable.getModel().getStudyAt(n);
                if (n2 == 3 && studyTableData != null && studyTableData.hasKODisplaySet()) {
                    studyTable.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    studyTable.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        private void setRolloverBorder(JTable jTable, int n, int n2) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
            if (tableCellRenderer instanceof IconCellRenderer) {
                ((IconCellRenderer)tableCellRenderer).setRolloverBorder(n, n2);
                jTable.repaint();
            }
        }

        private void resetAllRolloverBorders(JTable jTable) {
            TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(Icon.class);
            if (tableCellRenderer instanceof IconCellRenderer) {
                ((IconCellRenderer)tableCellRenderer).resetRolloverBorder();
                jTable.repaint();
            }
        }

        private void setStudyHighlight(JTable jTable, int n, int n2) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
            if (tableCellRenderer instanceof TextCellRenderer) {
                ((TextCellRenderer)tableCellRenderer).setHoverRow(n);
                jTable.repaint();
            }
        }

        private void resetAllStudyHighlights(JTable jTable) {
            TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
            if (tableCellRenderer instanceof TextCellRenderer) {
                ((TextCellRenderer)tableCellRenderer).resetHoverRow();
                jTable.repaint();
            }
        }
    }

    private static class StudyTableRowTransferHandler
    extends TransferHandler {
        private StudyTableRowTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 0x40000000;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            Object object;
            int n = -1;
            try {
                object = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen((Point)object, jComponent);
                n = ((StudyTable)jComponent).rowAtPoint((Point)object);
            }
            catch (Exception exception) {
                log.warn(null, (Throwable)exception);
            }
            if (n < 0) {
                n = ((StudyTable)jComponent).getSelectedRow();
            }
            if (n >= 0) {
                try {
                    object = new StudyTableTransferable(((StudyTable)jComponent).getModel().getStudyAt(n));
                    if (((StudyTableTransferable)object).getTransferData(IDisplaySet.dataFlavor) != null) {
                        return object;
                    }
                }
                catch (Exception exception) {
                    log.warn(null, (Throwable)exception);
                }
            }
            return null;
        }
    }

    private static class TextCellRenderer
    extends DefaultTableCellRenderer {
        private int hoverRow = -1;

        public TextCellRenderer() {
            this.setOpaque(false);
            this.setBorder(ComponentFactory.instance.createEmptyBorder(1, 0, 1, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setHorizontalAlignment(2);
            this.setFont(jTable.getFont());
            if (component instanceof JComponent) {
                StudyTableData studyTableData = ((StudyTable)jTable).getModel().getStudyAt(n);
                this.setText(studyTableData.toHtmlString(n == this.hoverRow));
                ((JComponent)component).setToolTipText(studyTableData.toString());
                int n3 = component.getPreferredSize().height;
                if (jTable.getRowHeight(n) != n3) {
                    jTable.setRowHeight(n, n3);
                }
            }
            return component;
        }

        private void resetHoverRow() {
            this.hoverRow = -1;
        }

        public void setHoverRow(int n) {
            this.hoverRow = n;
        }
    }
}

