/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.ListenerSynchronizationFactory;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DisplaySetListenerAdapter;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.save.gui.UnsavedDataManager;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetLabelGroup;
import com.tiani.jvision.patinfo.DisplaySetPanel;
import com.tiani.jvision.patinfo.studies.StudyTable;
import com.tiani.jvision.patinfo.studies.StudyTableData;
import com.tiani.jvision.patinfo.studies.StudyTableModel;
import com.tiani.jvision.patinfo.studies.StudyTablePanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JFrame;

public class StudyTableController {
    private static final ALogger log = ALogger.getLogger(StudyTableController.class);
    private static final IEventEngine engine = EventEngineFactory.getInstance();
    public static final String STUDY_TABLE_EVENT_PATH = "StudyTableController.EventPath";
    private static final String STUDY_OPENED_EVENT = "STUDY_OPENED";
    private static final String STUDY_CLOSED_EVENT = "STUDY_CLOSED";
    public static final int STUDY_OPENED_EVENT_ID = engine.getEventID("STUDY_OPENED");
    public static final int STUDY_CLOSED_EVENT_ID = engine.getEventID("STUDY_CLOSED");
    private StudyTable table;
    private DisplaySetPanel dispPanel;
    private StudyTableDisplaySetListener displaySetListener;
    private DataSelectionListener dataSelectionListener;
    private volatile boolean listenToRemoving = true;

    public StudyTableController(StudyTablePanel studyTablePanel) {
        this.dataSelectionListener = new DataSelectionListener(studyTablePanel);
        this.displaySetListener = new StudyTableDisplaySetListener(studyTablePanel);
        DataManager.getInstance().addDisplaySetListener(this.displaySetListener);
        DataSelectionManager.getInstance().addListener(this.dataSelectionListener);
        IEventListenerProvider iEventListenerProvider = EventEngineFactory.getInstance().createListenerProvider((IEventListener)new StudyVisibilityListener());
        engine.register(iEventListenerProvider, STUDY_TABLE_EVENT_PATH);
    }

    public void setTable(StudyTable studyTable) {
        if (this.table != null) {
            this.uninitTable();
        }
        this.table = studyTable;
        if (this.table != null) {
            this.initTable();
        }
    }

    public DisplaySetPanel getDisplaySetPanel() {
        return this.dispPanel;
    }

    public void setDisplaySetPanel(DisplaySetPanel displaySetPanel) {
        this.dispPanel = displaySetPanel;
    }

    public boolean isStudyOpened(String string) {
        StudyTableData studyTableData = this.findStudy(string);
        return studyTableData != null ? this.isStudyOpen(studyTableData) : false;
    }

    boolean isStudyOpen(StudyTableData studyTableData) {
        return studyTableData.isOpen();
    }

    void setStudyOpen(StudyTableData studyTableData, boolean bl) {
        this.setStudyOpen(studyTableData, bl, true);
    }

    void setStudyOpen(StudyTableData studyTableData, boolean bl, boolean bl2) {
        if (DisplaySetLabelGroup.CLOSE_STUDY_BY_DEFAULT && bl) {
            for (StudyTableData studyTableData2 : this.table.getModel().getStudies()) {
                if (studyTableData2 == studyTableData || !studyTableData2.isOpen()) continue;
                this.setStudyOpenImpl(studyTableData2, false, false, false, false);
            }
            this.setStudyOpenImpl(studyTableData, bl, true, false, bl2);
        } else {
            this.setStudyOpenImpl(studyTableData, bl, true, bl2, bl2);
        }
    }

    boolean isStudyCollapsed(StudyTableData studyTableData) {
        return studyTableData.isCollapsed();
    }

    void jumpToStudy(StudyTableData studyTableData, boolean bl) {
        if (DisplaySetLabelGroup.CLOSE_STUDY_BY_DEFAULT) {
            this.setStudyOpen(studyTableData, true);
        } else {
            this.jumpToStudyImpl(studyTableData, bl);
        }
    }

    private void jumpToStudyImpl(StudyTableData studyTableData, boolean bl) {
        if (this.dispPanel != null) {
            this.dispPanel.getSeqPane().jumpToStudy(studyTableData.getStudy(), bl);
        }
    }

    /*
     * Unable to fully structure code
     */
    void removeStudy(StudyTableData var1_1) {
        block9: {
            try {
                block10: {
                    if (this.table == null) break block9;
                    this.listenToRemoving = false;
                    var2_2 = true;
                    if (var1_1.getStudy().getParent().getStudies().size() != 1) break block10;
                    var2_2 = DataManager.getInstance().triggerPatientRemoval(var1_1.getStudy().getParent().getKey(), true, false);
                    ** GOTO lbl16
                }
                var3_4 = new UnsavedDataManager().manageSave((JFrame)JVision2.getMainFrame(), Collections.singleton(DataManager.getInstance().getPatientRepresentation(var1_1.getStudy().getParent().getKey())), var1_1.getStudy());
                if (!var3_4) {
                    return;
                }
                try {
                    var4_5 = this.getDisplaySetsForStudy(var1_1.getStudy());
                    if (var4_5 != null && !var4_5.isEmpty()) {
                        DataManager.getInstance().removeDisplaySet(var4_5.toArray(new IDisplaySet[var4_5.size()]), SplitAndSortChangeType.MANUAL_REMOVAL, true, false);
                    }
lbl16:
                    // 4 sources

                    if (var2_2) {
                        this.table.getModel().removeStudy(var1_1);
                    }
                }
                catch (Exception var2_3) {
                    StudyTableController.log.error("Removing study failed!", (Throwable)var2_3);
                }
            }
            finally {
                this.listenToRemoving = true;
            }
        }
    }

    private void uninitTable() {
        this.table.getModel().removeAllStudies();
    }

    private void initTable() {
        StudyTableModel studyTableModel = this.table.getModel();
        studyTableModel.removeAllStudies();
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null) {
            this.addAllStudies(iPatientRepresentation);
        }
    }

    private StudyTableData findStudy(String string) {
        if (this.table != null) {
            return this.table.getModel().findStudy(string);
        }
        return null;
    }

    private static IStudyData getStudyForDisplaySet(IDisplaySet iDisplaySet) {
        return iDisplaySet.getOneObject().getParent().getParent();
    }

    private Collection<IDisplaySet> getDisplaySetsForStudy(IStudyData iStudyData) {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        try {
            IDisplaySet[] iDisplaySetArray;
            IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey());
            if (iPatientRepresentation == null) {
                return Collections.emptyList();
            }
            IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
            int n = iDisplaySetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
                IStudyData iStudyData2 = StudyTableController.getStudyForDisplaySet(iDisplaySet);
                if (iStudyData.getKey().equals(iStudyData2.getKey())) {
                    arrayList.add(iDisplaySet);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            log.error("Extracting display-sets for study failed!", (Throwable)exception);
        }
        return arrayList;
    }

    public static Collection<IStudyData> findDisplayedStudies(IPatientRepresentation iPatientRepresentation) {
        LinkedHashSet<IStudyData> linkedHashSet = new LinkedHashSet<IStudyData>();
        IDisplaySet[] iDisplaySetArray = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
        if (iDisplaySetArray != null) {
            IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
            int n = iDisplaySetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
                try {
                    IStudyData iStudyData = StudyTableController.getStudyForDisplaySet(iDisplaySet);
                    if (iStudyData != null) {
                        linkedHashSet.add(iStudyData);
                    }
                }
                catch (Exception exception) {
                    log.warn(null, (Throwable)exception);
                }
                ++n2;
            }
        }
        return linkedHashSet;
    }

    private void setStudyOpenImpl(StudyTableData studyTableData, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.table.getModel().setStudyOpen(studyTableData, bl);
        if (this.dispPanel != null) {
            if (bl) {
                this.dispPanel.getSeqPane().openStudy(studyTableData.getStudy());
                if (bl2) {
                    this.jumpToStudyImpl(studyTableData, bl3);
                }
                if (bl4) {
                    this.fireStudyOpened(studyTableData);
                }
            } else {
                this.dispPanel.getSeqPane().closeStudy(studyTableData.getStudy());
                if (bl4) {
                    this.fireStudyClosed(studyTableData);
                }
            }
        }
    }

    private void removeStudy(IStudyData iStudyData) {
        try {
            if (this.table != null) {
                StudyTableModel studyTableModel = this.table.getModel();
                StudyTableData studyTableData = studyTableModel.findStudy(iStudyData);
                studyTableModel.removeStudy(studyTableData);
            }
        }
        catch (Exception exception) {
            log.error("Removing study from study-list failed!", (Throwable)exception);
        }
    }

    private void addStudies(Collection<IStudyData> collection) {
        try {
            if (this.table != null) {
                StudyTableModel studyTableModel = this.table.getModel();
                ArrayList<StudyTableData> arrayList = new ArrayList<StudyTableData>(collection.size());
                for (IStudyData iStudyData : collection) {
                    if (studyTableModel.hasStudy(iStudyData)) continue;
                    boolean bl = true;
                    if (this.dispPanel != null) {
                        bl = this.dispPanel.getSeqPane().isStudyOpen(iStudyData);
                    }
                    arrayList.add(new StudyTableData(iStudyData, bl));
                }
                studyTableModel.addStudies(arrayList);
            }
        }
        catch (Exception exception) {
            log.error("Adding study to study-list failed!", (Throwable)exception);
        }
    }

    private void addAllStudies(IPatientRepresentation iPatientRepresentation) {
        try {
            Collection<IStudyData> collection;
            if (this.table != null && (collection = StudyTableController.findDisplayedStudies(iPatientRepresentation)) != null) {
                this.addStudies(collection);
            }
        }
        catch (Exception exception) {
            log.error("Adding study to study-list failed!", (Throwable)exception);
        }
    }

    private void retainAllStudies(IPatientRepresentation iPatientRepresentation) {
        this.removeAllStudies(iPatientRepresentation, true);
    }

    private void removeAllStudies() {
        try {
            Iterable<StudyTableData> iterable = this.table.getModel().getStudies();
            for (StudyTableData studyTableData : iterable) {
                this.table.getModel().removeStudy(studyTableData);
            }
        }
        catch (Exception exception) {
            log.error("Removing studies from study-list failed!", (Throwable)exception);
        }
    }

    private void removeAllStudies(IPatientRepresentation iPatientRepresentation, boolean bl) {
        try {
            String string = iPatientRepresentation.getPatientKey();
            Iterable<StudyTableData> iterable = this.table.getModel().getStudies();
            for (StudyTableData studyTableData : iterable) {
                IStudyData iStudyData = studyTableData.getStudy();
                IPatientData iPatientData = iStudyData.getParent();
                boolean bl2 = false;
                if (bl) {
                    if (!string.equals(iPatientData.getKey())) {
                        bl2 = true;
                    }
                } else if (string.equals(iPatientData.getKey())) {
                    bl2 = true;
                }
                if (!bl2) continue;
                this.table.getModel().removeStudy(studyTableData);
            }
        }
        catch (Exception exception) {
            log.error("Removing studies from study-list failed!", (Throwable)exception);
        }
    }

    private void setActiveStudy(IStudyData iStudyData) {
        try {
            if (this.table != null) {
                StudyTableModel studyTableModel = this.table.getModel();
                StudyTableData studyTableData = studyTableModel.findStudy(iStudyData);
                if (studyTableData != null && studyTableData.isActive()) {
                    return;
                }
                for (StudyTableData studyTableData2 : studyTableModel.getStudies()) {
                    studyTableData2.setActive(false);
                }
                if (studyTableData != null) {
                    studyTableData.setActive(true);
                }
                this.table.repaint();
            }
        }
        catch (Exception exception) {
            log.error("Updating active study in study-list failed!", (Throwable)exception);
        }
    }

    private void fireStudyOpened(StudyTableData studyTableData) {
        IEvent iEvent = engine.createEvent(STUDY_OPENED_EVENT_ID, null, (Object)this, null, ActionInfo.SINGLE);
        iEvent.setPayload((Object)new StudyVisibilityEventPayload(studyTableData.getStudy().getKey(), this.dispPanel));
        iEvent.setDestination(null, STUDY_TABLE_EVENT_PATH);
        engine.sendEvent(iEvent);
    }

    private void fireStudyClosed(StudyTableData studyTableData) {
        IEvent iEvent = engine.createEvent(STUDY_CLOSED_EVENT_ID, null, (Object)this, null, ActionInfo.SINGLE);
        iEvent.setPayload((Object)new StudyVisibilityEventPayload(studyTableData.getStudy().getKey(), this.dispPanel));
        iEvent.setDestination(null, STUDY_TABLE_EVENT_PATH);
        engine.sendEvent(iEvent);
    }

    private class DataSelectionListener
    extends DataSelectionListenerAdapter {
        private StudyTablePanel studyPanel;

        public DataSelectionListener(StudyTablePanel studyTablePanel) {
            this.studyPanel = studyTablePanel;
        }

        @Override
        public void newActiveStudySelected(IStudyData iStudyData) {
            StudyTableController.this.setActiveStudy(iStudyData);
        }

        @Override
        public void newHangingCaseSelected(IPatientRepresentation iPatientRepresentation, IHanging iHanging, IHanging iHanging2, boolean bl) {
            if (DisplaySetLabelGroup.CLOSE_STUDY_BY_DEFAULT) {
                StudyTableData studyTableData;
                IStudyData iStudyData = null;
                IStudyData iStudyData2 = null;
                if (iHanging != null && iHanging.getStudyContainer() != null) {
                    iStudyData = iHanging.getStudyContainer().getBaseStudy();
                }
                if (iHanging2 != null && iHanging2.getStudyContainer() != null) {
                    iStudyData2 = iHanging2.getStudyContainer().getBaseStudy();
                }
                if (!CompareUtils.equals(iStudyData, iStudyData2) && iStudyData2 != null && (studyTableData = StudyTableController.this.findStudy(iStudyData2.getKey())) != null) {
                    StudyTableController.this.setStudyOpen(studyTableData, true);
                }
            }
        }

        @Override
        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            if (iPatientRepresentation2 != null) {
                StudyTableController.this.retainAllStudies(iPatientRepresentation2);
                StudyTableController.this.addAllStudies(iPatientRepresentation2);
                if (!Config.impaxee.jvision.SEQPANEL.ScrollOnFocusChange.get()) {
                    this.studyPanel.scrollToTop();
                }
            } else if (StudyTableController.this.listenToRemoving) {
                StudyTableController.this.removeAllStudies();
            }
        }

        @Override
        public void notifyPriorStudyLoadingInProgress(boolean bl) {
            this.studyPanel.setLoadingIndicator(bl);
        }

        @Override
        public void priorsChanged() {
            this.studyPanel.repaint();
        }
    }

    private class StudyTableDisplaySetListener
    extends DisplaySetListenerAdapter {
        private StudyTablePanel studyPanel;

        public StudyTableDisplaySetListener(StudyTablePanel studyTablePanel) {
            this.studyPanel = studyTablePanel;
        }

        @Override
        public void displaySetAdded(IPatientRepresentation iPatientRepresentation, List<IDisplaySet> list, SplitAndSortChangeType splitAndSortChangeType) {
            IPatientRepresentation iPatientRepresentation2 = DataSelectionManager.getInstance().getCurrentPatient();
            if (iPatientRepresentation2 != null && iPatientRepresentation != null && iPatientRepresentation2.getPatientKey().equals(iPatientRepresentation.getPatientKey())) {
                StudyTableController.this.addAllStudies(iPatientRepresentation);
            }
        }

        @Override
        public void studyRemoved(IStudyData iStudyData, boolean bl) {
            if (StudyTableController.this.listenToRemoving) {
                StudyTableController.this.removeStudy(iStudyData);
            }
            if (StudyTableController.this.table.getModel().getRowCount() == 0) {
                this.studyPanel.setLoadingIndicator(false);
            }
        }
    }

    public static class StudyVisibilityEventPayload {
        private String studyKey;
        private boolean jumpToStudy;
        private DisplaySetPanel panel;

        public StudyVisibilityEventPayload(String string, boolean bl, DisplaySetPanel displaySetPanel) {
            this.studyKey = string;
            this.jumpToStudy = bl;
            this.panel = displaySetPanel;
        }

        private StudyVisibilityEventPayload(String string, DisplaySetPanel displaySetPanel) {
            this(string, true, displaySetPanel);
        }

        public String getStudyKey() {
            return this.studyKey;
        }

        private boolean shouldJumpToStudy() {
            return this.jumpToStudy;
        }

        public DisplaySetPanel getPanel() {
            return this.panel;
        }
    }

    private class StudyVisibilityListener
    implements IEventListener {
        private IListenerSynchronization sync = ListenerSynchronizationFactory.getInstance();

        private StudyVisibilityListener() {
        }

        public boolean handleEvent(IEvent iEvent) {
            Object object = iEvent.getSource();
            if (object != StudyTableController.this && (iEvent.getEventID() == STUDY_OPENED_EVENT_ID || iEvent.getEventID() == STUDY_CLOSED_EVENT_ID)) {
                String string;
                boolean bl;
                block4: {
                    bl = iEvent.getEventID() == STUDY_OPENED_EVENT_ID;
                    StudyVisibilityEventPayload studyVisibilityEventPayload = (StudyVisibilityEventPayload)iEvent.getPayload();
                    string = studyVisibilityEventPayload.getStudyKey();
                    if (!DisplaySetLabelGroup.CLOSE_STUDY_BY_DEFAULT || CompareUtils.equals((Object)StudyTableController.this.dispPanel, (Object)studyVisibilityEventPayload.getPanel())) break block4;
                    return false;
                }
                try {
                    final StudyTableData studyTableData = StudyTableController.this.findStudy(string);
                    EventUtil.invoke((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            StudyTableController.this.setStudyOpen(studyTableData, bl, false);
                        }
                    });
                }
                catch (Exception exception) {
                    log.error("Opening/Closing study failed!", (Throwable)exception);
                }
            }
            return true;
        }

        public IListenerSynchronization getSync() {
            return this.sync;
        }
    }
}

