/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.keyimages.KeyImageStudyExpansion;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.studies.StudyTextHelper;

class StudyTableData {
    private IStudyData study;
    private StudyTextHelper textHelper;
    private boolean open;
    private boolean active;

    StudyTableData(IStudyData iStudyData, boolean bl) {
        this.study = iStudyData;
        this.open = bl;
        this.active = false;
        this.textHelper = StudyTextHelper.create(iStudyData);
    }

    public IStudyData getStudy() {
        return this.study;
    }

    public IDisplaySet getKODisplaySet() {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null) {
            return iPatientRepresentation.getDecompositionRuntime().getKeyImageDisplaySet(this.getStudy());
        }
        return null;
    }

    boolean hasKODisplaySet() {
        return this.getKODisplaySet() != null;
    }

    public String toString() {
        return this.textHelper.toTextString(true);
    }

    String toHtmlString() {
        return this.textHelper.toHtmlString(this.active, false);
    }

    String toHtmlString(boolean bl) {
        return this.textHelper.toHtmlString(this.active, bl);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isCollapsable() {
        return KeyImageStudyExpansion.getInstance().isCollapsableOrExpandable(this.study);
    }

    public boolean isCollapsed() {
        return KeyImageStudyExpansion.getInstance().isCollapsed(this.study);
    }

    public int getPriorIndex() {
        IStudyContainer iStudyContainer;
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null && (iStudyContainer = iHanging.getStudyContainer()) != null) {
            return iStudyContainer.getIndexOfStudy(this.study.getKey());
        }
        return -1;
    }

    public int hashCode() {
        return this.study.getKey().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof StudyTableData) {
            return this.study.getKey().equals(((StudyTableData)object).study.getKey());
        }
        return false;
    }
}

