/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.pacs.base.swing.busylabel.ColorUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.tiani.base.data.IStudyData;
import java.awt.Color;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.UIManager;
import org.dcm4che3.data.Attributes;

public class StudyTextHelper {
    private static final Set<String> filteredModalities = new HashSet<String>();
    private static final boolean monochrome;
    private final boolean mergedPatient;
    private final String description;
    private final String modalities;
    private final String dateTime;
    private String htmlString;
    private String htmlStringActive;
    private String htmlStringHighlight;
    private String htmlStringActiveHighlight;

    static {
        filteredModalities.add("SR");
        filteredModalities.add("KO");
        filteredModalities.add("PR");
        monochrome = !GuiUtil.isOnColorMonitor();
    }

    private StudyTextHelper(String string, String string2, String string3, boolean bl) {
        this.description = string;
        this.dateTime = string2;
        this.modalities = string3;
        this.mergedPatient = bl;
    }

    public static StudyTextHelper create(IStudyData iStudyData) {
        return new StudyTextHelper(iStudyData.getDicomObject().getString(528432), StudyTextHelper.getDateTimeString(iStudyData), StudyTextHelper.getModalityString(iStudyData), DataManager.getInstance().isStudyMerged(iStudyData));
    }

    public String toTextString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl && this.description != null) {
            stringBuilder.append(this.description);
            if (this.dateTime != null || this.modalities != null && this.modalities.length() > 0) {
                stringBuilder.append(" | ");
            }
        }
        if (this.modalities != null && this.modalities.length() > 0) {
            stringBuilder.append(this.modalities);
            if (this.dateTime != null) {
                stringBuilder.append(" | ");
            }
        }
        if (this.dateTime != null) {
            stringBuilder.append(this.dateTime);
        }
        return stringBuilder.toString();
    }

    public String toHtmlString(boolean bl) {
        return this.toHtmlString(bl, false);
    }

    public String toHtmlString(boolean bl, boolean bl2) {
        if (!bl) {
            if (!bl2) {
                if (this.htmlString == null) {
                    this.htmlString = this.createHtmlString(bl, bl2);
                }
                return this.htmlString;
            }
            if (this.htmlStringHighlight == null) {
                this.htmlStringHighlight = this.createHtmlString(bl, bl2);
            }
            return this.htmlStringHighlight;
        }
        if (!bl2) {
            if (this.htmlStringActive == null) {
                this.htmlStringActive = this.createHtmlString(bl, bl2);
            }
            return this.htmlStringActive;
        }
        if (this.htmlStringActiveHighlight == null) {
            this.htmlStringActiveHighlight = this.createHtmlString(bl, bl2);
        }
        return this.htmlStringActiveHighlight;
    }

    private String createHtmlString(boolean bl, boolean bl2) {
        Color color = null;
        if (!bl) {
            color = ColorUtils.getSecondary7();
            if (color == null) {
                color = UIManager.getColor("Label.foreground");
            }
        } else if (monochrome) {
            color = ColorUtils.darker((Color)Color.WHITE, (float)0.9f);
        } else {
            color = new Color((int)Config.impaxee.jvision.MAPPING.MappingColor.get());
            color = ColorUtils.darker((Color)color, (float)0.9f);
        }
        if (bl2) {
            color = ColorUtils.brighter((Color)color, (float)0.7f);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append("<font color=\"").append(ColorUtil.toHexString((Color)color)).append("\">");
        if (monochrome && bl) {
            stringBuilder.append("<b>");
        }
        if (this.mergedPatient) {
            stringBuilder.append("! ");
        }
        boolean bl3 = true;
        if (this.description != null) {
            stringBuilder.append(this.description);
            if (this.dateTime != null || this.modalities != null && this.modalities.length() > 0) {
                stringBuilder.append("<br>");
            }
            bl3 = false;
        }
        if (this.modalities != null && this.modalities.length() > 0) {
            stringBuilder.append(this.modalities);
            if (this.dateTime != null) {
                stringBuilder.append(" | ");
            }
            bl3 = false;
        }
        if (this.dateTime != null) {
            stringBuilder.append(this.dateTime);
            bl3 = false;
        }
        if (bl3) {
            stringBuilder.append("NA");
        }
        if (monochrome && bl) {
            stringBuilder.append("</b>");
        }
        stringBuilder.append("</font></body></html>");
        return stringBuilder.toString();
    }

    private static String getModalityString(IStudyData iStudyData) {
        String[] stringArray = iStudyData.getModalitiesInStudy();
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (!filteredModalities.contains(string)) {
                    if (stringBuilder.length() == 0) {
                        stringBuilder.append(string);
                    } else {
                        stringBuilder.append(',').append(string);
                    }
                }
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    private static String getDateTimeString(IStudyData iStudyData) {
        Date date = DateTimeUtils.getStudyDateTime((Attributes)iStudyData.getDicomObject());
        if (date != null) {
            return DateTimeUtils.dateTime2String((Date)date);
        }
        return null;
    }

    private static String toHtmlFontSize(int n) {
        if (n <= 0) {
            return "4";
        }
        if (n <= 6) {
            return "1";
        }
        if (n <= 8) {
            return "2";
        }
        if (n <= 12) {
            return "3";
        }
        if (n <= 16) {
            return "4";
        }
        if (n <= 24) {
            return "5";
        }
        if (n <= 36) {
            return "6";
        }
        return "7";
    }
}

