/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.plugin;

import com.agfa.pacs.impaxee.Messages;
import java.util.ArrayList;

public enum PluginName {
    INVERT("Invert", PluginType.NONE),
    FLIP("Flip", PluginType.NONE),
    TRUESIZE_ZOOM("TrueSize Zoom", PluginType.NONE),
    PIXELIDENTITY_ZOOM("Pixel 1:1 Zoom", PluginType.NONE),
    LTA("LTA", PluginType.NONE),
    LOCALIZER("Localizer", PluginType.NONE),
    ADDSUB("Image Addition/Substraction Plugin", "AddSub plugin"),
    AFUSION("Fusion CT/MR/PET Plugin", "Fusion CT/MR/PET plugin"),
    ANIM2D("2D Animation Plugin", "2D Animation plugin"),
    ANIM2DCARDIO("2D Cardiology Animation Plugin", "2D Cardio Animation plugin"),
    BFUSION("Fusion CT/MR Plugin", "Fusion CT/MR plugin"),
    DEFAULT("No Plugin", "Default"),
    DENTASCAN("DentaScan Plugin", "DentaScan"),
    DVH("DVH Plugin", "DVH plugin"),
    EMPR("Extended Multi-planar Reconstruction Plugin", "EMPR plugin"),
    ENDO("Endoscopy Plugin", "Endoscopy plugin"),
    FUSION("Fusion Plugin", "Fusion Plugin"),
    HECTEC("AGFA Orthopaedic Tools", "HecTec mediCAD"),
    MAMMO2("Mammography Viewing Plugin", "Mammo2 plugin"),
    MIP("Maximum Intensity Projection Plugin", "MIP plugin"),
    NUK("Plugin NUK", "NUK colorbar plugin"),
    OASIS("Segami Oasis Software Integration", "Oasis"),
    ORTHOGON("Orthogon Software Integration", "Orthogon"),
    PERFUSION("Perfusion Plugin", "Perfusion plugin"),
    QANGIO("Qangio XA Software Integration", "Qangio"),
    SEGMENTATION("Volume Segmentation Plugin", "Segmentation plugin"),
    SPINELABELING("Spine Labeling Plugin", "Spine Labeling"),
    SSD("Surface Shaded Display Plugin", "SSD plugin"),
    THREE_D_FIT(Messages.getString("PluginName.3DFit"), "3D Fit plugin", PluginType.INTERNAL),
    TF("Plugin TF", "TF"),
    VIDEOPLAYER("VideoPlay", "Video Player plugin", PluginType.AUTOSTART),
    VOLUMEVIEWINGEXTENDED("Volume Viewing Plugin", "Volume Viewing plugin"),
    VT("Vessel Tracker Plugin", "VTPlugin"),
    TomTec("TomTec", "TomTec"),
    Mammography("Mammography", "Mammography"),
    ECG("ECG Plugin", "Xero ECG plugin", PluginType.AUTOSTART),
    MAMMOHP("CR Mammography extended hanging protocol", "Mammo HP plugin");

    private final String caption;
    private final String internalName;
    private final PluginType type;

    private PluginName(String string2, PluginType pluginType) {
        this(string2, string2, pluginType);
    }

    private PluginName(String string2, String string3) {
        this(string2, string3, PluginType.REGULAR);
    }

    private PluginName(String string2, String string3, PluginType pluginType) {
        this.caption = string2;
        this.internalName = string3;
        this.type = pluginType;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getPluginName() {
        return this.internalName;
    }

    public boolean isPlugin() {
        return this.type != PluginType.NONE;
    }

    public boolean isInternalPlugin() {
        return this.type == PluginType.INTERNAL;
    }

    public boolean isAutostartPlugin() {
        return this.type == PluginType.AUTOSTART;
    }

    public static PluginName getItemWithName(String string) {
        if (string == null) {
            return null;
        }
        PluginName[] pluginNameArray = PluginName.values();
        int n = pluginNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginName pluginName = pluginNameArray[n2];
            if (pluginName.internalName.equals(string)) {
                return pluginName;
            }
            ++n2;
        }
        return null;
    }

    public static PluginName[] pluginValues() {
        ArrayList<PluginName> arrayList = new ArrayList<PluginName>();
        PluginName[] pluginNameArray = PluginName.values();
        int n = pluginNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginName pluginName = pluginNameArray[n2];
            if (pluginName.isPlugin()) {
                arrayList.add(pluginName);
            }
            ++n2;
        }
        return arrayList.toArray(new PluginName[arrayList.size()]);
    }

    private static enum PluginType {
        NONE,
        REGULAR,
        INTERNAL,
        AUTOSTART;

    }
}

