/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IRegionInfoSource;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.renderer.ImageProcessorNode;
import com.tiani.jvision.renderer.IntermediateNode;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.renderer.filter.ImageFilterOperator;
import com.tiani.jvision.renderer.filter.ImageFilterOperatorFactory;
import com.tiani.jvision.toptoolbar.FilterActions;

public class ImageFilterNode
extends ImageProcessorNode {
    private static final ALogger log = ALogger.getLogger(ImageFilterNode.class);
    private ImageFilterOperator filter = null;

    public ImageFilterNode() {
    }

    ImageFilterNode(Renderer renderer) {
        super(renderer);
    }

    @Override
    public void updateImageState() {
        this.child.updateImageState();
    }

    @Override
    public IRegionInfoSource getRegionSource() {
        return this.child.getRegionSource();
    }

    @Override
    public String getName() {
        if (this.filter == null) {
            return "Filter";
        }
        return "Filter/" + this.filter.getComponentName();
    }

    public String getFilterName() {
        return this.filter != null ? this.filter.getComponentName() : null;
    }

    public boolean isFilterActive() {
        return this.filter != null;
    }

    public void setFilter(ImageFilterOperator imageFilterOperator) {
        this.filter = imageFilterOperator;
        if (this.child != null) {
            this.child.invalidate();
        }
    }

    private void filter8(int n, int n2, int n3, int n4, int n5, boolean bl) {
        log.trace("re-filter...");
        byte[] byArray = (byte[])this.child.getRaw(n, n2, n3, n4, n5, 1, bl);
        byte[] byArray2 = new byte[n5];
        this.filter.applyFilter(byArray, byArray2, n, n2, n3, n4, this.child.getMaxRawValue(), this.child.getRawValueOffset());
        this.cachedByteRaw = byArray2;
    }

    private void filter16(int n, int n2, int n3, int n4, int n5, boolean bl) {
        log.trace("re-filter...");
        short[] sArray = (short[])this.child.getRaw(n, n2, n3, n4, n5, 2, bl);
        short[] sArray2 = new short[n5];
        this.filter.applyFilter(sArray, sArray2, n, n2, n3, n4, this.child.getMaxRawValue(), this.child.getRawValueOffset());
        this.cachedShortRaw = sArray2;
    }

    private void filterRGB(int n, int n2, int n3, int n4, int n5, boolean bl) {
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
        if (!this.isCacheGeometryValid(bl, n, n2, n3, n4, rGBBufferedImageHolder.numPixels) || this.isInvalid()) {
            switch (this.child.getRawContentType()) {
                case 1: {
                    this.filter8(n, n2, 0, n, n * n2, bl);
                    break;
                }
                case 2: {
                    this.filter16(n, n2, 0, n, n * n2, bl);
                    break;
                }
                case 0: {
                    this.filterRGB(n, n2, 0, n, n * n2, bl);
                }
            }
        }
        switch (this.child.getRawContentType()) {
            case 1: {
                this.raw8ToRGB(n, n2, bl, rGBBufferedImageHolder.data, n3, n4);
                break;
            }
            case 2: {
                this.raw16ToRGB(n, n2, bl, rGBBufferedImageHolder.data, n3, n4);
                break;
            }
            case 0: {
                this.rawRGBToRGB(n, n2, bl, rGBBufferedImageHolder.data, n3, n4);
            }
        }
        this.setValid();
    }

    @Override
    public Object getRaw(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        switch (this.child.getRawContentType()) {
            case 1: {
                if (!this.isCacheGeometryValid(bl, n, n2, n3, n4, n5)) {
                    this.filter8(n, n2, n3, n4, n5, bl);
                }
                this.setValid();
                if (n6 == 1) {
                    return this.child.getRaw(n, n2, n3, n4, n5, n6, bl);
                }
                log.debug("RGB requested from filter!");
                int[] nArray = new int[n5];
                this.raw8ToRGB(n, n2, bl, nArray, n3, n4);
                return nArray;
            }
            case 2: {
                if (!this.isCacheGeometryValid(bl, n, n2, n3, n4, n5)) {
                    this.filter16(n, n2, n3, n4, n5, bl);
                }
                this.setValid();
                if (n6 == 2) {
                    return this.child.getRaw(n, n2, n3, n4, n5, n6, bl);
                }
                log.debug("RGB requested from filter!");
                int[] nArray = new int[n5];
                this.raw16ToRGB(n, n2, bl, nArray, n3, n4);
                return nArray;
            }
            case 0: {
                if (!this.isCacheGeometryValid(bl, n, n2, n3, n4, n5)) {
                    this.filterRGB(n, n2, n3, n4, n5, bl);
                }
                this.setValid();
                return this.child.getRaw(n, n2, n3, n4, n5, n6, bl);
            }
        }
        return null;
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.destinationNodeID != 0 && tEvent.destinationNodeID != this.nodeID) {
            return this.child.handleTEvent(tEvent, object, n, view);
        }
        switch (tEvent.id) {
            case 12: {
                Object object2;
                ImageFilterOperator imageFilterOperator = null;
                if (object instanceof ImageFilterOperator) {
                    imageFilterOperator = (ImageFilterOperator)((ImageFilterOperator)object).getInstance();
                } else {
                    object2 = null;
                    if (object instanceof FilterActions.FilterType) {
                        object2 = ((FilterActions.FilterType)((Object)object)).name();
                    } else if (object instanceof String) {
                        object2 = (String)object;
                    }
                    if (object2 != null) {
                        imageFilterOperator = (ImageFilterOperator)ImageFilterOperatorFactory.getInstance().getComponent((String)object2);
                    }
                }
                if (imageFilterOperator == null) {
                    object2 = view.getRenderer();
                    if (object2 != null && object2 != this && object2 instanceof IntermediateNode) {
                        ((IntermediateNode)object2).removeChild(this);
                        this.cleanUp();
                    }
                } else {
                    this.setFilter((ImageFilterOperator)imageFilterOperator.getInstance());
                }
                return true;
            }
        }
        return this.child.handleTEvent(tEvent, object, n, view);
    }

    @Override
    public ImageFilterNode clone() {
        ImageFilterNode imageFilterNode = (ImageFilterNode)super.clone();
        imageFilterNode.filter = (ImageFilterOperator)this.filter.getInstance();
        return imageFilterNode;
    }

    @Override
    public void storeToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        boolean bl = false;
        if (viewSnapshot.forceRGB()) {
            viewSnapshot.setForceRGB(false);
            bl = true;
        }
        this.child.storeToSnapshot(viewSnapshot, snapOutputGeometry);
        Object object = viewSnapshot.getDataBuffer();
        int n = viewSnapshot.getWidth() * viewSnapshot.getHeight();
        if (object instanceof byte[]) {
            if (bl) {
                byte[] byArray = new byte[n];
                this.filter.applyFilter((byte[])object, byArray, viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), this.child.getMaxRawValue(), this.child.getRawValueOffset());
                int[] nArray = new int[n];
                this.raw8ToRGB(byArray, viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), this.child.getLUTForRaw(), nArray, 0, viewSnapshot.getWidth());
                viewSnapshot.setForceRGB(true);
                viewSnapshot.setDataBuffer(nArray);
            } else {
                byte[] byArray = new byte[n];
                this.filter.applyFilter((byte[])object, byArray, viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), this.child.getMaxRawValue(), this.child.getRawValueOffset());
                viewSnapshot.setDataBuffer(byArray);
            }
        } else if (object instanceof short[]) {
            if (bl) {
                short[] sArray = new short[n];
                this.filter.applyFilter((short[])object, sArray, viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), this.child.getMaxRawValue(), this.child.getRawValueOffset());
                int[] nArray = new int[n];
                this.raw16ToRGB(sArray, viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), this.child.getLUTForRaw(), nArray, 0, viewSnapshot.getWidth());
                viewSnapshot.setForceRGB(true);
                viewSnapshot.setDataBuffer(nArray);
            } else {
                short[] sArray = new short[n];
                this.filter.applyFilter((short[])object, sArray, viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), this.child.getMaxRawValue(), 0);
                viewSnapshot.setDataBuffer(sArray);
            }
        } else if (object instanceof int[]) {
            int[] nArray = new int[n];
            this.filter.applyFilter((int[])object, nArray, viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), this.child.getMaxRawValue());
            viewSnapshot.setDataBuffer(nArray);
        }
    }
}

