/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.renderer.Renderer;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;

public abstract class IntermediateNode
extends Renderer {
    public abstract List<Renderer> getChildren();

    public abstract List<Renderer> getVisibleChildren();

    public abstract void addChild(Renderer var1);

    public abstract void setChild(Renderer var1, int var2);

    public abstract void removeChild(Renderer var1);

    public abstract void removeSubtree(Renderer var1);

    @Override
    public Renderer getLeaf() {
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            return this.getChildren().get(0).getLeaf();
        }
        return null;
    }

    @Override
    public IImageInformation getImageInformation() {
        return this.getChildren().get(0).getImageInformation();
    }

    @Override
    public Renderer getNode(int n) {
        if (super.getNode(n) != null) {
            return this;
        }
        for (Renderer renderer : this.getVisibleChildren()) {
            Renderer renderer2 = renderer.getNode(n);
            if (renderer2 == null) continue;
            return renderer2;
        }
        return null;
    }

    @Override
    public Renderer getNode(String string) {
        if (super.getNode(string) != null) {
            return this;
        }
        for (Renderer renderer : this.getVisibleChildren()) {
            Renderer renderer2 = renderer.getNode(string);
            if (renderer2 == null) continue;
            return renderer2;
        }
        return null;
    }

    boolean replaceNode(Renderer renderer, Renderer renderer2) {
        List<Renderer> list = this.getVisibleChildren();
        int n = 0;
        while (n < list.size()) {
            Renderer renderer3 = list.get(n);
            if (renderer3 == renderer) {
                this.setChild(renderer2, n);
                return true;
            }
            if (renderer3 instanceof IntermediateNode && ((IntermediateNode)renderer3).replaceNode(renderer, renderer2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public IMutableImageState getImageState() {
        return ImageState.getDefaultImageState();
    }

    @Override
    public List<IMenuEntry> getLegacyMenuEntries(View view) {
        List<IMenuEntry> list = super.getLegacyMenuEntries(view);
        List<Renderer> list2 = this.getVisibleChildren();
        if (list2.size() <= 2) {
            for (Renderer renderer : list2) {
                list.addAll(renderer.getLegacyMenuEntries(view));
            }
        } else {
            list.addAll(list2.get(0).getLegacyMenuEntries(view));
        }
        return list;
    }

    @Override
    public void synchronizeWith(Renderer renderer) {
        Iterator<Renderer> iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            iterator.next().synchronizeWith(renderer);
        }
    }

    @Override
    public Renderer findInstance(Class<?> clazz) {
        if (clazz.isInstance(this)) {
            return this;
        }
        Iterator<Renderer> iterator = this.getChildren().iterator();
        Renderer renderer = null;
        while (iterator.hasNext() && renderer == null) {
            Renderer renderer2 = iterator.next();
            if (renderer2 == null) continue;
            renderer = renderer2.findInstance(clazz);
        }
        return renderer;
    }

    @Override
    public void setGeometry(int n, int n2, int n3, int n4) {
        for (Renderer renderer : this.getChildren()) {
            renderer.setGeometry(n, n2, n3, n4);
        }
    }

    @Override
    public Color getBackgroundColor() {
        if (!this.getChildren().isEmpty()) {
            return this.getChildren().get(0).getBackgroundColor();
        }
        return Color.BLACK;
    }

    @Override
    public boolean containsRenderer(Renderer renderer) {
        if (this.getChildren() == null) {
            return false;
        }
        for (Renderer renderer2 : this.getChildren()) {
            if (!renderer2.containsRenderer(renderer)) continue;
            return true;
        }
        return false;
    }
}

