/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.hap.pacs.data.valuemapping.RealWorldValueMapping;
import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.frameofreference.DefaultWorldToWorldTransformer;
import com.agfa.pacs.impaxee.gsts.GrayScaleTransformationSequence;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.presentationstate.DisplayedAreaOrientation;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.presentationstate.RDCPresentationState;
import com.agfa.pacs.impaxee.utils.SpatialTransformationUtils;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVUtil;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicLayer;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.IDisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.IWindowValue;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUTShape;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.module.ps.TextObject;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.agfa.pacs.listtext.dicomobject.presentation.PaletteColorLUTWrapper;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.IRegionInfoSource;
import com.tiani.base.data.ImageRegion;
import com.tiani.base.data.Orientation;
import com.tiani.base.data.RawDataContainer;
import com.tiani.base.data.RawDataContainer16CT;
import com.tiani.base.data.RawDataContainer8CT;
import com.tiani.base.data.RawDataContainerRGB;
import com.tiani.jvision.event.IZoomablePixelSizeProvider;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.ClippingCircle;
import com.tiani.jvision.image.DoubleDimension;
import com.tiani.jvision.image.DoubleRectangle;
import com.tiani.jvision.image.GeneralWindowTransferFunction;
import com.tiani.jvision.image.IPickingHandler;
import com.tiani.jvision.image.IVisView;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.PickingHandler2D;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.SegmentedPaletteColorLUT;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowTransferFunction;
import com.tiani.jvision.image.WindowValue;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.IViewportRestoreHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.PixelIdentityFitHandler;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.image.fithandler.TrueSizeFitHandler;
import com.tiani.jvision.image.fithandler.ViewPort;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import com.tiani.jvision.image.fithandler.ZoomRestorePayload;
import com.tiani.jvision.info.IImageState;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.info.IPixelSizeProvider;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.BitmapOverlay;
import com.tiani.jvision.overlay.ColorBarOverlay;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayBitmap;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ROIFactory;
import com.tiani.jvision.overlay.Shutter;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.LeafRenderer;
import com.tiani.jvision.renderer.RDCRenderer16;
import com.tiani.jvision.renderer.RDCRenderer8;
import com.tiani.jvision.renderer.RDCRendererRGB;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.toptoolbar.SyncOptionsActionProvider;
import com.tiani.jvision.toptoolbar.ZoomUtils;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.vis.VisHRSetDefault;
import com.tiani.jvision.vis.VisMouseHandler;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public abstract class RDCRenderer
extends LeafRenderer
implements IRDCRenderer,
IViewportRestoreHandler {
    private static final ALogger log = ALogger.getLogger(RDCRenderer.class);
    private static final Map<String, Integer> HOT_REGION_NAME_TO_EVENT_ID = new HashMap<String, Integer>();
    private static ImageRegion infoir;
    private static final ConfigListener changeListener;
    private static String lastPixelAspectRatioErrorStudyKey;
    private static final boolean whiteBackground;
    private static final boolean autoApplyRealWorld;
    protected CacheID windowingDataId;
    protected IFrameObjectData frameObjectData;
    protected WindowHandlerBase windowHandler;
    protected TransferFunction tf;
    private boolean borderLockMode = false;
    private ImageDef activedef;
    protected Matrix2d transform;
    protected int xs;
    protected int ys;
    protected int ws;
    protected int hs;
    protected AreaFitHandler vpHandler = new FullVisualFitHandler(OutputDeviceMetric.screen);
    private ViewPort newViewPort = new ViewPort();
    private Rectangle imgBounds;
    private InteractionInfoHolder dragInfo;
    private IFramePresentationState currentFramePresentationState;

    static {
        changeListener = new ConfigListener();
        lastPixelAspectRatioErrorStudyKey = null;
        whiteBackground = Config.impaxee.jvision.DISPLAY.whiteBackground.get();
        autoApplyRealWorld = Config.impaxee.jvision.ValueMapping.RealWorld.AutoApply.get();
        HOT_REGION_NAME_TO_EVENT_ID.put("FLIP_HOR", 7);
        HOT_REGION_NAME_TO_EVENT_ID.put("FLIP_VER", 8);
        HOT_REGION_NAME_TO_EVENT_ID.put("ROTATE_LEFT", 9);
        HOT_REGION_NAME_TO_EVENT_ID.put("ROTATE_RIGHT", 10);
        Config.impaxee.jvision.MEASUREMENT.DensityMeasurementRadius.registerChangeListener(changeListener);
        RDCRenderer.initInfoRegion();
    }

    public RDCRenderer(IFrameObjectData iFrameObjectData, boolean bl) {
        super(iFrameObjectData.getImageInformation());
        this.frameObjectData = iFrameObjectData;
        this.imageInformation = iFrameObjectData.getImageInformation();
        this.setRawDataContainer(this.frameObjectData.getRawDataContainer());
        IFramePresentationState iFramePresentationState = iFrameObjectData.getFramePresentationState();
        this.initSpacing();
        if (bl) {
            this.applyPresentationState(iFramePresentationState);
        } else {
            this.applyLUTs(iFramePresentationState);
        }
    }

    @Override
    public IPickingHandler getPickingHandler() {
        return PickingHandler2D.getInstance();
    }

    @Override
    public TransferFunction getTransferFunction() {
        return this.tf;
    }

    @Override
    public void setBorderLockMode(boolean bl) {
        this.borderLockMode = bl;
        if (this.vpHandler != null) {
            this.vpHandler.setBorderLockMode(this.borderLockMode);
        }
    }

    @Override
    public boolean isBorderLockMode() {
        return this.borderLockMode;
    }

    public static RDCRenderer createRenderer(IFrameObjectData iFrameObjectData, boolean bl, ZoomMode zoomMode) {
        RawDataContainer rawDataContainer = iFrameObjectData.getRawDataContainer();
        if (rawDataContainer instanceof RawDataContainer16CT) {
            return new RDCRenderer16(iFrameObjectData, bl, zoomMode);
        }
        if (rawDataContainer instanceof RawDataContainer8CT) {
            return new RDCRenderer8(iFrameObjectData, bl, zoomMode);
        }
        if (rawDataContainer instanceof RawDataContainerRGB) {
            return new RDCRendererRGB(iFrameObjectData, bl, zoomMode);
        }
        return null;
    }

    @Override
    public RDCRenderer clone() {
        RDCRenderer rDCRenderer = (RDCRenderer)super.clone();
        if (this.windowHandler != null) {
            rDCRenderer.windowHandler = WindowHandlerBase.getInstance(this.windowHandler);
            rDCRenderer.tf = rDCRenderer.windowHandler.getTransferFunction();
        }
        rDCRenderer.activedef = new ImageDef(this.activedef);
        if (this.transform != null) {
            rDCRenderer.transform = new Matrix2d(this.transform);
        }
        rDCRenderer.vpHandler = new FullVisualFitHandler(OutputDeviceMetric.screen);
        rDCRenderer.vpHandler.set(this.vpHandler);
        rDCRenderer.imageState = new ImageState((List<SpacingDef>)((ImageState)this.imageState).spacingDefs());
        ((ImageState)rDCRenderer.imageState).setCurrentSpacingDef(((ImageState)this.imageState).getCurrentSpacingDef());
        int n = ((ImageState)this.imageState).getViewHeight();
        if (n > 0) {
            rDCRenderer.updateImageState(new Rectangle(0, 0, ((ImageState)this.imageState).getViewWidth(), n));
        } else {
            this.setGeometry(512, 512, 0, 512);
            rDCRenderer.setGeometry(512, 512, 0, 512);
            rDCRenderer.updateImageState(new Rectangle(0, 0, 512, 512));
        }
        return rDCRenderer;
    }

    @Override
    public void updateImageState() {
    }

    private void initSpacing() {
        block5: {
            ((ImageState)this.imageState).initSpacing(this.frameObjectData.getImageInformation());
            double d = ((ImageState)this.imageState).getCurrentSpacingDef().getDataPixelSizeX();
            double d2 = ((ImageState)this.imageState).getCurrentSpacingDef().getDataPixelSizeY();
            if (d != 0.0 && d2 != 0.0) {
                this.activedef = new ImageDef(this.imageInformation.getColumns(), this.imageInformation.getRows(), d, d2);
                this.vpHandler.setBorderLockMode(this.borderLockMode);
            } else {
                try {
                    int[] nArray = this.imageInformation.getPixelAspectRatio();
                    if (nArray == null) {
                        nArray = new int[]{1, 1};
                    }
                    this.activedef = new ImageDef(this.imageInformation.getColumns(), this.imageInformation.getRows(), 0.0, 0.0);
                    this.activedef.setAspectRatio(nArray[1], nArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = this.frameObjectData.getParent().getParent().getKey();
                    if (lastPixelAspectRatioErrorStudyKey != null && lastPixelAspectRatioErrorStudyKey.equals(string)) break block5;
                    lastPixelAspectRatioErrorStudyKey = string;
                    ImpaxEEUtils.handleDisplayProblem(this.frameObjectData.getSOPInstanceUID(), Messages.getString("ImpaxEEUtils.PixelAspectRationProblem"), true);
                }
            }
        }
    }

    @Override
    public void initValueMappings(VisDisplay2 visDisplay2) {
        this.initRealWorldValueMapping();
        SUVUtil.initSUVMappingForFrame(visDisplay2, this);
    }

    private void initRealWorldValueMapping() {
        if (autoApplyRealWorld) {
            this.activateRealWorldValueMapping();
        }
    }

    private void activateRealWorldValueMapping() {
        List<RealWorldValueMapping> list = this.getImageInformation().getRealWorldValueMappings();
        if (list.size() == 1) {
            ((ImageState)this.imageState).setCurrentValueMapping((IValueMapping)list.get(0));
        }
    }

    @Override
    public void setNodeID(int n) {
        super.setNodeID(n);
        if (this.windowHandler != null) {
            this.windowHandler.setNodeID(this.nodeID);
        }
    }

    private boolean tfChanged() {
        return this.tf != null && (long)this.tf.getUpdateID() > super.getContentStamp(0);
    }

    @Override
    public IRegionInfoSource getRegionSource() {
        return this.getRegionInfoSourceOverlay(this.getRawDataContainer());
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        boolean bl3 = this.tfChanged();
        boolean bl4 = bl2 = bl && bl3;
        if (bl2) {
            this.separateExtractTo(rGBBufferedImageHolder.data, n, n2, n3, n4);
        } else {
            this.extractTo(rGBBufferedImageHolder.data, n, n2, n3, n4);
        }
        this.setValid();
    }

    @Override
    public Object getRaw(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int[] nArray = cache.allocInts((long)n5);
        this.extractTo(nArray, n, n2, n3, n4);
        return nArray;
    }

    protected abstract void extractTo(int[] var1, int var2, int var3, int var4, int var5);

    protected abstract void separateExtractTo(int[] var1, int var2, int var3, int var4, int var5);

    @Override
    public int getMaxRawValue() {
        return this.tf.getGrays() - 1;
    }

    @Override
    public int getRawValueOffset() {
        return this.tf.getOffset(false);
    }

    @Override
    public int[] getLUTForRaw() {
        return this.tf.getRGB(false);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.windowHandler = null;
        this.tf = null;
        this.clearWindowingCache();
    }

    protected void handleInversion(TEvent tEvent, Object object, int n, View view) {
        if (this.windowHandler != null) {
            this.windowHandler.handleTEvent(tEvent, object, n, view);
        }
        this.tf.recalc();
    }

    private void flipHorizontalAction() {
        this.applyTransform(Matrix2d.trafoFlipH);
    }

    private void flipVerticalAction() {
        this.applyTransform(Matrix2d.trafoFlipV);
    }

    private void rotateLeft90Action() {
        this.applyTransform(Matrix2d.trafoRotL);
    }

    private void rotateRight90Action() {
        this.applyTransform(Matrix2d.trafoRotR);
    }

    @Override
    public IRDCRenderer disableFreeRotation() {
        return this;
    }

    protected void reset(boolean bl) {
        this.clearWindowingCache();
        if (this.windowHandler != null) {
            this.resetWindowing();
        }
        if (bl) {
            this.resetTransform();
        }
        this.resetZoom();
        this.resetCurrentSpacingDef();
        this.invalidate();
    }

    private void resetTransformAndZoom() {
        this.resetTransform();
        this.resetZoom();
        this.invalidate();
    }

    public void resetZoom() {
        DoubleRectangle doubleRectangle = this.getDefaultDisplayedArea();
        if (doubleRectangle != null && this.vpHandler instanceof FullVisualFitHandler) {
            ((FullVisualFitHandler)this.vpHandler).setDisplayedArea(doubleRectangle);
        } else {
            this.vpHandler.resetZoomFactor();
        }
        this.activedef.resetTransformedViewportCenter();
    }

    private void resetCurrentSpacingDef() {
        int n = ((ImageState)this.imageState).spacingDefs().size();
        ((ImageState)this.imageState).setCurrentSpacingDef(n - 1);
    }

    private void resetWindowing() {
        IImageInformation iImageInformation = this.currentFramePresentationState != null && this.currentFramePresentationState.isTemporary() ? this.imageInformation : null;
        this.windowHandler.reset(iImageInformation);
        this.tf = this.windowHandler.getTransferFunction();
    }

    @Override
    public MousePositionDestination getMouseFollower() {
        return this;
    }

    private static void initInfoRegion() {
        int n = (int)Config.impaxee.jvision.MEASUREMENT.DensityMeasurementRadius.get();
        infoir = n == 0 ? new ImageRegion() : new ImageRegion(new ClippingCircle(0, 0, n));
    }

    @Override
    public String getInfoAt(int n, int n2, int n3, int n4) {
        if (this.windowHandler == null) {
            return null;
        }
        if (this.isInvalid()) {
            this.fitImage(n3, n4);
        }
        double[] dArray = new double[]{n, n2};
        double[] dArray2 = new double[]{0.0, 0.0};
        IImageState iImageState = this.getImageState();
        iImageState.screenToImage(dArray, dArray2, null);
        RDCRenderer.infoir.x = (int)dArray2[0];
        RDCRenderer.infoir.y = (int)dArray2[1];
        if (RDCRenderer.infoir.clip != null) {
            ((ClippingCircle)RDCRenderer.infoir.clip).setCenter(RDCRenderer.infoir.x, RDCRenderer.infoir.y);
        }
        IImageRegionProperties iImageRegionProperties = this.getRawDataContainer().getImageRegionProperties(infoir, 0, 0, iImageState.getCurrentValueMapping());
        return iImageRegionProperties.getStatistics();
    }

    @Override
    public AreaFitHandler getAreaFitHandler() {
        return this.vpHandler;
    }

    @Override
    public void setAreaFitHandler(AreaFitHandler areaFitHandler) {
        this.vpHandler = areaFitHandler.getClone();
        this.vpHandler.setBorderLockMode(this.borderLockMode);
        this.invalidate();
    }

    protected Rectangle fitImage(int n, int n2) {
        if (this.imgBounds == null) {
            this.imgBounds = new Rectangle();
        }
        if (n == 0 || n2 == 0) {
            return this.imgBounds;
        }
        this.vpHandler.calculateViewPortAndImageBounds(this.activedef, this.newViewPort, this.imgBounds, n, n2);
        Rectangle rectangle = this.newViewPort.getRectangle();
        this.setSourceArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.activedef.getTransform());
        this.updateImageState(this.imgBounds);
        ((ImageState)this.getImageState()).setViewSize(n, n2);
        this.updateOverlays(n, n2);
        return this.imgBounds;
    }

    private void applyTransform(Matrix2d matrix2d) {
        this.activedef.applyTransform(matrix2d);
        ((ImageState)this.imageState).setTransform(this.activedef.getTransform());
        this.invalidate();
    }

    private void resetTransform() {
        this.setTransform(Orientation.createStandardTransform2D(this.imageInformation));
    }

    public void setTransform(Matrix2d matrix2d) {
        if (!this.activedef.isIdentity() || !matrix2d.isIdentity()) {
            boolean bl = !this.activedef.getTransform().equals(matrix2d);
            this.activedef.setTransform(matrix2d);
            if (bl) {
                ((ImageState)this.imageState).setTransform(this.activedef.getTransform());
                this.invalidate();
            }
        }
    }

    private void panRelative(double d, double d2) {
        double d3 = this.getDrag().xstart + d / this.vpHandler.getAbsoluteZoomFactorX() / (double)this.activedef.getDisplayedColumns();
        double d4 = this.getDrag().ystart + d2 / this.vpHandler.getAbsoluteZoomFactorY() / (double)this.activedef.getDisplayedRows();
        this.activedef.setTransformedViewportCenter(d3, d4);
        double[] dArray = this.activedef.getInterchangeableViewportCenter();
        TEvent tEvent = new TEvent();
        tEvent.id = 2;
        tEvent.interactionModifier = 1;
        tEvent.destinationNodeID = this.nodeID;
        TEventDispatch.sendEvent(tEvent, (Object)dArray, this.isViewportChangeDispatchedToSynchronizedDisplays());
    }

    @Override
    public void broadcastViewportChange(ViewportDefinition viewportDefinition) {
        TEventDispatch.sendEvent(new TEvent(17), (Object)viewportDefinition, this.isViewportChangeDispatchedToSynchronizedDisplays());
    }

    protected boolean isViewportChangeDispatchedToSynchronizedDisplays() {
        return SyncOptionsActionProvider.SyncOption.ZOOM_PAN.isSelected();
    }

    @Override
    public boolean startRectangleZoom() {
        return true;
    }

    @Override
    public DoubleDimension getDefaultDisplayedAreaSize() {
        DoubleRectangle doubleRectangle = this.getDefaultDisplayedArea();
        if (doubleRectangle == null) {
            return null;
        }
        return new DoubleDimension(doubleRectangle);
    }

    protected DoubleRectangle getDefaultDisplayedArea() {
        return null;
    }

    @Override
    public void centerZoomStart() {
        this.getAreaFitHandler().pinZoomFactor();
        this.broadcastMultiplicativeZoomFactorChange(1.0, 0);
    }

    @Override
    public void centerZoomProgress(double d, View view) {
        this.applyRelativeZoomFactorChange(d, view);
        this.broadcastMultiplicativeZoomFactorChange(d, 1);
    }

    private void broadcastMultiplicativeZoomFactorChange(double d, int n) {
        TEvent tEvent = new TEvent();
        tEvent.id = 2;
        tEvent.interactionModifier = n;
        tEvent.destinationNodeID = this.nodeID;
        TEventDispatch.sendEvent(tEvent, ZoomParameter.relative(this, d));
    }

    @Override
    public void centerZoomEnd(double d, View view) {
        this.clearWindowingCache();
        this.broadcastZoomParameter(ZoomParameter.relative(this, d), view);
        this.unpinZoomFactor();
    }

    protected void unpinZoomFactor() {
        this.getAreaFitHandler().unpinZoomFactor();
    }

    private void broadcastZoomParameter(ZoomParameter zoomParameter, View view) {
        TEvent tEvent = new TEvent();
        tEvent.id = 2;
        tEvent.interactionModifier = 2;
        tEvent.destinationNodeID = this.nodeID;
        if (view == null) {
            TEventDispatch.sendEvent(tEvent, zoomParameter);
        } else if (view.getVis().isSelected()) {
            TEventDispatch.sendEvent(view.getDisplay(), tEvent, (Object)zoomParameter, this.isViewportChangeDispatchedToSynchronizedDisplays());
            view.delayedRepaintBroadcast();
        } else {
            view.handleTEvent(tEvent, zoomParameter, 0);
        }
    }

    private void setViewport(ViewportDefinition viewportDefinition, View view) {
        this.fitImage(viewportDefinition.cwidth, viewportDefinition.cheight);
        ImageState imageState = (ImageState)this.getImageState();
        switch (viewportDefinition.getType()) {
            case RELATIVE: {
                if (viewportDefinition.relWidth != 0.0 && viewportDefinition.relHeight != 0.0) {
                    double d = viewportDefinition.relXo;
                    double d2 = viewportDefinition.relYo;
                    double d3 = viewportDefinition.relWidth;
                    double d4 = viewportDefinition.relHeight;
                    Rectangle rectangle = imageState.getImageBounds();
                    d = (d * (double)viewportDefinition.cwidth - (double)rectangle.x) / (double)rectangle.width;
                    d2 = (d2 * (double)viewportDefinition.cheight - (double)rectangle.y) / (double)rectangle.height;
                    d3 = d3 * (double)viewportDefinition.cwidth / (double)rectangle.width;
                    d4 = d4 * (double)viewportDefinition.cheight / (double)rectangle.height;
                    double d5 = (this.newViewPort.x + this.newViewPort.width * d) / (double)this.activedef.getDisplayedColumns();
                    double d6 = (this.newViewPort.y + this.newViewPort.height * d2) / (double)this.activedef.getDisplayedRows();
                    double d7 = d3 * this.newViewPort.width / (double)this.activedef.getDisplayedColumns();
                    double d8 = d4 * this.newViewPort.height / (double)this.activedef.getDisplayedRows();
                    this.activedef.setTransformedViewportCenter(d5 + d7 / 2.0, d6 + d8 / 2.0);
                    this.vpHandler.setZoomFactor(1.0 / Math.min(d7, d8), this.activedef, view);
                    break;
                }
                double[] dArray = new double[]{viewportDefinition.relXo * (double)viewportDefinition.cwidth, viewportDefinition.relYo * (double)viewportDefinition.cheight};
                double[] dArray2 = new double[]{0.0, 0.0};
                imageState.screenToImage(dArray, dArray2, null);
                this.activedef.setTransformedViewportCenter(dArray2[0] / (double)this.activedef.getDisplayedColumns(), dArray2[1] / (double)this.activedef.getDisplayedRows());
                break;
            }
            case IMAGE_PIXEL_RELATIVE: {
                double d = this.activedef.getTransformedViewportCenter()[0] * (double)this.activedef.getDisplayedColumns() + viewportDefinition.pixelXo;
                double d9 = this.activedef.getTransformedViewportCenter()[1] * (double)this.activedef.getDisplayedRows() + viewportDefinition.pixelYo;
                this.activedef.setTransformedViewportCenter(d / (double)this.activedef.getDisplayedColumns(), d9 / (double)this.activedef.getDisplayedRows());
                break;
            }
            case IMAGE_PIXEL_ABSOLUTE: {
                double d = viewportDefinition.pixelXo / (double)this.activedef.getUntransformedColumns();
                double d10 = viewportDefinition.pixelYo / (double)this.activedef.getUntransformedRows();
                Vector2d vector2d = this.activedef.getViewportCenter();
                vector2d.x = d;
                vector2d.y = d10;
                break;
            }
            case IMAGE_PIXEL_ABSOLUTE_NORMALIZED: {
                this.activedef.setTransformedViewportCenter(viewportDefinition.pixelXo, viewportDefinition.pixelYo);
            }
        }
    }

    @Override
    public boolean restoreViewportCenterAfterZoom(double[] dArray) {
        return this.applyInterchangeableViewportCenter(dArray);
    }

    private boolean applyInterchangeableViewportCenter(double[] dArray) {
        if (this.activedef.getInterchangeableViewportCenter() == dArray) {
            return false;
        }
        this.activedef.setInterchangeableViewportCenter(dArray[0], dArray[1]);
        this.invalidate();
        return true;
    }

    private void applyRelativeZoomFactorChange(double d, View view) {
        this.vpHandler.applyRelativeZoomFactorChange(d, this.activedef, view);
    }

    private boolean zoomHandleTEvent(TEvent tEvent, Object object, View view) {
        if (tEvent.destinationNodeID != 0 && tEvent.destinationNodeID != this.nodeID) {
            return false;
        }
        this.clearWindowingCache();
        switch (tEvent.id) {
            case 17: {
                ViewportDefinition viewportDefinition = null;
                if (object instanceof PickingResult) {
                    PickingResult pickingResult = (PickingResult)object;
                    IImageInformation iImageInformation = this.frameObjectData.getImageInformation();
                    Point3d point3d = pickingResult.getRayHit();
                    if (point3d != null && iImageInformation.getFrameOfReferenceUID() != null && iImageInformation.getPointOrigin() != null && iImageInformation.getImageOrientation() != null) {
                        Vector3d vector3d = pickingResult.projectToPlane(iImageInformation, view == null ? DefaultWorldToWorldTransformer.INSTANCE : view.getWorldToWorldTransformer());
                        Vector2d vector2d = PickingResult.worldToImage((Tuple3d)vector3d, iImageInformation);
                        viewportDefinition = ViewportDefinition.getImageAbsolute(vector2d.x, vector2d.y);
                    } else if (point3d != null) {
                        viewportDefinition = ViewportDefinition.getImageAbsolute(point3d.x, point3d.y);
                    }
                } else {
                    viewportDefinition = (ViewportDefinition)object;
                }
                if (viewportDefinition != null) {
                    this.setViewport(viewportDefinition, view);
                    this.invalidate();
                }
                if (view != null) {
                    view.delayedRepaint();
                }
                return true;
            }
            case 2: {
                if (tEvent.interactionModifier != 2) break;
                if (object instanceof ZoomParameter) {
                    if (((ZoomParameter)object).applyTo(this, (IVisView)view) != ZoomParameter.ZoomParameterApplicationResult.APPLIED) break;
                    this.invalidate();
                    return true;
                }
                return this.applyInterchangeableViewportCenter((double[])object);
            }
        }
        return false;
    }

    private void setSourceArea(int n, int n2, int n3, int n4, Matrix2d matrix2d) {
        double[] dArray = new double[]{1.0, this.activedef.getRowScalingFactor()};
        if (matrix2d != null) {
            matrix2d.transform(dArray);
        }
        int n5 = (int)((double)n / Math.abs(dArray[0]));
        int n6 = (int)((double)n2 / Math.abs(dArray[1]));
        int n7 = (int)((double)n3 / Math.abs(dArray[0]));
        int n8 = (int)((double)n4 / Math.abs(dArray[1]));
        if (n5 != this.xs || n6 != this.ys || n7 != this.ws || n8 != this.hs || matrix2d != null && !Objects.equals(this.transform, matrix2d)) {
            if (matrix2d != null) {
                this.transform = matrix2d;
            }
            this.invalidate();
        }
        this.xs = n5;
        this.ys = n6;
        this.ws = n7;
        this.hs = n8;
        if (matrix2d != null) {
            this.transform = matrix2d;
        }
    }

    private double getScreenPixelSizeY() {
        return this.activedef.getDisplayedPixelSpaceY() / this.vpHandler.getAbsoluteZoomFactorY();
    }

    @Override
    public double getScreenPixelSizeX() {
        return this.activedef.getDisplayPixelSpaceX() / this.vpHandler.getAbsoluteZoomFactorX();
    }

    @Override
    public SpacingDef getCurrentSpacingDef() {
        return ((ImageState)this.getImageState()).getCurrentSpacingDef();
    }

    private void updateImageState(Rectangle rectangle) {
        ImageState imageState = (ImageState)super.getImageState();
        boolean bl = false;
        try {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            imageState.setImageBounds(rectangle);
            imageState.setTransform(this.activedef.getTransform());
            double d7 = this.getScreenPixelSizeX();
            double d8 = this.getScreenPixelSizeY();
            bl |= d7 != imageState.getScreenPixelSizeX();
            bl |= d8 != imageState.getScreenPixelSizeY();
            imageState.setScreenPixelSize(d7, d8);
            if (this.windowHandler != null) {
                imageState.setWindow(this.windowHandler.getWindow());
                imageState.updated();
            }
            double d9 = 0.0;
            double d10 = 0.0;
            int n = 1;
            int n2 = 1;
            double[] dArray = new double[]{1.0, 1.0};
            this.activedef.getTransform().transform(dArray);
            if (dArray[0] < 0.0) {
                d9 = this.activedef.toTrueWidth(this.activedef.getDisplayedColumns());
                n = -1;
            }
            if (dArray[1] < 0.0) {
                d10 = this.activedef.toTrueHeight(this.activedef.getDisplayedRows());
                n2 = -1;
            }
            if (bl |= imageState.setVisOrientationAndOrigin(d6 = (d5 = (double)n * this.activedef.toTrueWidth(this.newViewPort.width)) / (double)rectangle.width, d4 = (d3 = (double)n2 * this.activedef.toTrueHeight(this.newViewPort.height)) / (double)rectangle.height, (d2 = d9 + (double)n * this.activedef.toTrueWidth(this.newViewPort.x)) - (double)rectangle.x * d6, (d = d10 + (double)n2 * this.activedef.toTrueHeight(this.newViewPort.y)) - (double)rectangle.y * d4, this.activedef.isRotated())) {
                imageState.updated();
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    @Override
    public boolean handleHotRegionPressed(String string, Rectangle rectangle, MouseEvent mouseEvent, View view) {
        if (string.equals("FLIP_HOR")) {
            return true;
        }
        if (string.equals("FLIP_VER")) {
            return true;
        }
        if (string.equals("ROTATE_LEFT")) {
            return true;
        }
        if (string.equals("ROTATE_RIGHT")) {
            return true;
        }
        if (string.equals("ZOOM")) {
            this.centerZoomStart();
            return true;
        }
        if (string.equals("PAN")) {
            double[] dArray = this.activedef.getTransformedViewportCenter();
            this.getDrag().xstart = dArray[0];
            this.getDrag().ystart = dArray[1];
            TEvent tEvent = new TEvent();
            tEvent.id = 2;
            tEvent.interactionModifier = 0;
            tEvent.destinationNodeID = this.nodeID;
            TEventDispatch.sendEvent(tEvent, (Object)this.activedef.getInterchangeableViewportCenter(), this.isViewportChangeDispatchedToSynchronizedDisplays());
            return true;
        }
        return false;
    }

    @Override
    public boolean handleHotRegionReleased(String string, MouseEvent mouseEvent, int n, int n2, View view) {
        Integer n3 = HOT_REGION_NAME_TO_EVENT_ID.get(string);
        if (n3 != null) {
            TEvent tEvent = new TEvent(n3);
            tEvent.destinationNodeID = this.nodeID;
            if (!view.getVis().isSelected()) {
                this.handleTEvent(tEvent, null, 0, view);
            }
            TEventDispatch.sendEvent(tEvent, null);
            view.delayedRepaintBroadcast();
            return true;
        }
        if (string.equals("ZOOM")) {
            this.centerZoomEnd(RDCRenderer.getRelativeZoomFactorChangeForMouseMovement(n2), view);
            this.dragInfo = null;
            return true;
        }
        if (string.equals("PAN")) {
            this.clearWindowingCache();
            double[] dArray = this.activedef.getInterchangeableViewportCenter();
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            TEvent tEvent = new TEvent();
            tEvent.id = 2;
            tEvent.interactionModifier = 2;
            tEvent.destinationNodeID = this.nodeID;
            tEvent.source = view;
            TEventDispatch.sendEvent(tEvent, (Object)dArray2, this.isViewportChangeDispatchedToSynchronizedDisplays());
            if (view != null) {
                view.delayedRepaintBroadcast();
            }
            this.dragInfo = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean wantsMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        int n = ModifierKeys.getExtendedModifier((MouseEvent)mouseWheelEvent);
        return n == 0 || n == 256 || n == 128;
    }

    @Override
    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent, View view) {
        if (!VisMouseHandler.isZoomByMouseWheelActive(view)) {
            return false;
        }
        IMouseModeInfo iMouseModeInfo = view.getDisplayData().getDisplayPlugin().getMouseModeInfo();
        if (iMouseModeInfo.getSubMode().isMeasurement()) {
            iMouseModeInfo.storeStateBeforeMeasurement(this, new Vector2d(this.activedef.getInterchangeableViewportCenter()), this.vpHandler.getClone());
        }
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        dArray[0] = mouseWheelEvent.getPoint().x;
        dArray[1] = mouseWheelEvent.getPoint().y;
        ((ImageState)this.imageState).screenToImage(dArray, dArray2, null);
        this.clearWindowingCache();
        this.broadcastZoomParameter(MouseWheelZoomParameter.create(this, RDCRenderer.getZoomFactorChange(mouseWheelEvent)), view);
        this.fitImage(((ImageState)this.getImageState()).getViewWidth(), ((ImageState)this.getImageState()).getViewHeight());
        ((ImageState)this.imageState).screenToImage(dArray, dArray3, null);
        double[] dArray4 = this.activedef.getInterchangeableViewportCenter();
        double[] dArray5 = new double[]{(dArray3[0] - dArray2[0]) / (double)this.activedef.getColumnCount(), (dArray3[1] - dArray2[1]) / (double)this.activedef.getRowCount()};
        Matrix2d matrix2d = this.activedef.getPossibleTransform();
        if (matrix2d != null) {
            matrix2d.transform(dArray5);
        }
        this.restoreViewportCenter(view, dArray4[0] - dArray5[0], dArray4[1] - dArray5[1]);
        view.getMapping().updateContent(true, true);
        view.delayedRepaint();
        return true;
    }

    @Override
    public void restoreZoom(View view, Object object) {
        AreaFitHandler areaFitHandler = (AreaFitHandler)object;
        TEventDispatch.sendEvent(view.getDisplay(), new TEvent(79), (Object)new ZoomRestorePayload(areaFitHandler, ZoomParameter.relative(this, areaFitHandler.getAbsoluteZoomFactorX() / this.vpHandler.getAbsoluteZoomFactorX(), null)), SyncOptionsActionProvider.SyncOption.ZOOM_PAN.isSelected());
    }

    @Override
    public void restoreViewportCenter(View view, double d, double d2) {
        TEventDispatch.sendEvent(view.getDisplay(), new TEvent(2), (Object)new double[]{d, d2}, this.isViewportChangeDispatchedToSynchronizedDisplays());
    }

    @Override
    public boolean handleHotRegionDragged(String string, MouseEvent mouseEvent, int n, int n2, int n3, int n4, View view) {
        if (string.equals("ZOOM")) {
            this.centerZoomProgress(RDCRenderer.getRelativeZoomFactorChangeForMouseMovement(n2), view);
            this.invalidate();
            return true;
        }
        if (string.equals("PAN")) {
            this.panRelative(-((float)n), -((float)n2));
            this.invalidate();
            return true;
        }
        return false;
    }

    private static double getRelativeZoomFactorChangeForMouseMovement(int n) {
        return Math.pow(2.0, (double)(-n) / 60.0);
    }

    private InteractionInfoHolder getDrag() {
        if (this.dragInfo == null) {
            this.dragInfo = new InteractionInfoHolder();
        }
        return this.dragInfo;
    }

    private void localWindow(double d, double d2, int n, View view) {
        if (n == 0) {
            n = 10;
        }
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{0.0, 0.0};
        ((ImageState)this.imageState).screenToImage(dArray, dArray2, null);
        ClippingCircle clippingCircle = new ClippingCircle((int)dArray2[0], (int)dArray2[1], n);
        clippingCircle.setBBoxOnly(view == null);
        ImageRegion imageRegion = new ImageRegion(clippingCircle);
        try {
            IImageRegionProperties iImageRegionProperties = this.getRawDataContainer().getImageRegionProperties(imageRegion, 0, 0, null);
            double d3 = iImageRegionProperties.getMean();
            double d4 = iImageRegionProperties.getStdDev() * 4.0;
            if (this.windowHandler != null) {
                this.windowHandler.setDataWindow(d3, d4, view != null);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            log.error("Exc:", (Throwable)arrayIndexOutOfBoundsException);
        }
    }

    private void calibratePixelSize(double d, double d2, double d3) {
        double d4 = d;
        double d5 = d2 * this.activedef.getRowScalingFactor();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = d3 / d6;
        double d8 = d3 / d6 * this.activedef.getRowScalingFactor();
        if (d7 != 0.0 && d8 != 0.0) {
            SpacingDef spacingDef = new SpacingDef();
            spacingDef.setSizeUnit(SpacingDef.Unit.mm_man);
            spacingDef.setDataPixelSizeX(d7);
            spacingDef.setDataPixelSizeY(d8);
            ImageState imageState = (ImageState)this.getImageState();
            imageState.setCurrentSpacingDef(spacingDef);
            this.activedef.resetAspectRatio();
            this.activedef.setPixelSpacing(spacingDef);
        }
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.destinationNodeID != 0 && tEvent.destinationNodeID != this.nodeID) {
            return false;
        }
        switch (tEvent.id) {
            case 2: 
            case 17: {
                return this.zoomHandleTEvent(tEvent, object, view);
            }
            case 132: {
                if (!(object instanceof AreaFitHandler.ViewportCenterAlignmentX)) break;
                this.getAreaFitHandler().setViewportCenterAlignmentX((AreaFitHandler.ViewportCenterAlignmentX)((Object)object));
                return true;
            }
            case 60: {
                boolean bl;
                IWindowValue iWindowValue;
                if (this.windowHandler == null) break;
                if (object instanceof IWindowValue) {
                    iWindowValue = (IWindowValue)object;
                    bl = false;
                } else {
                    IVOILUT iVOILUT;
                    if (object != null) {
                        log.warn("Unsupported payload for setting default window level: " + object);
                    }
                    if ((iVOILUT = this.imageInformation.getVOILUT()) != null && iVOILUT.hasWindow()) {
                        iWindowValue = iVOILUT;
                        bl = false;
                    } else {
                        GrayScaleTransformationSequence grayScaleTransformationSequence = this.windowHandler.getGSTS();
                        int n2 = grayScaleTransformationSequence.getRsDef().getGrays();
                        iWindowValue = new WindowValue((double)n2 / 2.0 - (double)grayScaleTransformationSequence.getOffset(), n2);
                        bl = true;
                    }
                }
                if (bl) {
                    this.windowHandler.setDefaultDataWindowLevel(iWindowValue);
                } else {
                    this.windowHandler.setDefaultWindowLevel(iWindowValue);
                }
                this.resetWindowing();
                return true;
            }
            case 62: 
            case 63: 
            case 64: {
                if (this.windowHandler == null) break;
                boolean bl = this.windowHandler.handleTEvent(tEvent, object, n, view);
                this.tf = this.windowHandler.getTransferFunction();
                if (tEvent.id == 64) {
                    this.updateNearestNeighbourInterpolationSetting();
                }
                return bl;
            }
            case 69: {
                WindowHandlerBase windowHandlerBase = this.getWindowHandler();
                if (windowHandlerBase != null && windowHandlerBase.canPerformLocalWindowing()) {
                    this.localWindow(((Point)object).getX(), ((Point)object).getY(), 0, view);
                    this.invalidate();
                    if (view != null) {
                        view.delayedRepaintBroadcast();
                    }
                }
                return true;
            }
            case 65: {
                Point3d point3d = (Point3d)object;
                this.calibratePixelSize(point3d.x, point3d.y, point3d.z);
                return true;
            }
            case 5: 
            case 6: {
                this.handleInversion(tEvent, object, n, view);
                if (view != null) {
                    view.delayedRepaint();
                }
                return true;
            }
            case 7: {
                this.clearWindowingCache();
                this.flipHorizontalAction();
                return true;
            }
            case 8: {
                this.clearWindowingCache();
                this.flipVerticalAction();
                return true;
            }
            case 9: {
                this.clearWindowingCache();
                this.rotateLeft90Action();
                return true;
            }
            case 10: {
                this.clearWindowingCache();
                this.rotateRight90Action();
                return true;
            }
            case 79: {
                object = ((ZoomRestorePayload)object).getOriginalFitHandler();
            }
            case 80: {
                this.clearWindowingCache();
                if (view != null) {
                    this.fitImage(view.getcwidth(), view.getcheight());
                }
                this.setAreaFitHandler((AreaFitHandler)object);
                if (view != null) {
                    this.fitImage(view.getcwidth(), view.getcheight());
                    view.repaint();
                }
                return true;
            }
            case 66: {
                this.reset(object == null || Boolean.TRUE.equals(object));
                if (view != null) {
                    view.delayedRepaint();
                }
                return true;
            }
            case 138: {
                this.resetTransformAndZoom();
                if (view != null) {
                    view.delayedRepaint();
                }
                return true;
            }
            case 67: {
                this.resetTransform();
                if (view != null) {
                    view.delayedRepaint();
                }
                return true;
            }
            case 95: {
                int[] nArray;
                this.activedef.resetAspectRatio();
                this.activedef.setPixelSpacing((SpacingDef)object);
                if (((SpacingDef)object).getSizeUnit() == SpacingDef.Unit.pix && (nArray = this.getImageInformation().getPixelAspectRatio()) != null) {
                    this.activedef.setAspectRatio(nArray[1], nArray[0]);
                }
                return true;
            }
            case 137: {
                Rectangle rectangle = (Rectangle)object;
                this.vpHandler.prepareCanvasSizeChange(this.activedef, rectangle.width, rectangle.height);
                break;
            }
            default: {
                return super.handleTEvent(tEvent, object, n, view);
            }
        }
        return false;
    }

    protected abstract void setRawDataContainer(RawDataContainer var1);

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2, View view) {
        return RDCRenderer.getHRSet(visHRSet, vis2);
    }

    static VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2) {
        if (visHRSet != null && visHRSet.getType().equals("DEF")) {
            return visHRSet;
        }
        return new VisHRSetDefault(vis2);
    }

    @Override
    public WindowHandlerBase getWindowHandler() {
        return this.windowHandler;
    }

    @Override
    public void getOptimumOutputSize(SnapOutputGeometry snapOutputGeometry) {
        AreaFitHandler areaFitHandler = this.vpHandler;
        snapOutputGeometry.destinationHeight = snapOutputGeometry.maxHeight;
        snapOutputGeometry.destinationWidth = snapOutputGeometry.maxWidth;
        this.vpHandler = snapOutputGeometry.getAreaFitHandler();
        this.vpHandler.set(areaFitHandler);
        snapOutputGeometry.initDestination();
        Rectangle rectangle = this.fitImage(snapOutputGeometry.maxWidth, snapOutputGeometry.maxHeight);
        IImageState iImageState = this.getImageState();
        double d = 1.0;
        d = iImageState.getDataPixelSizeX() != 0.0 ? iImageState.getDataPixelSizeX() / iImageState.getScreenPixelSizeX() : (double)rectangle.width / this.newViewPort.width;
        double d2 = (double)snapOutputGeometry.maxHeight / d;
        double d3 = (double)snapOutputGeometry.maxWidth / d;
        if (snapOutputGeometry.aspectRatioChangeAllowed) {
            d2 = Math.round((double)rectangle.width / d);
            d3 = Math.round((double)rectangle.height / d);
        }
        while (d2 > (double)snapOutputGeometry.maxWidth || d3 > (double)snapOutputGeometry.maxHeight) {
            d2 /= 2.0;
            d3 /= 2.0;
        }
        while (d2 < (double)snapOutputGeometry.minWidth || d3 < (double)snapOutputGeometry.minHeight) {
            d2 *= 2.0;
            d3 *= 2.0;
        }
        snapOutputGeometry.destinationHeight = (int)d3;
        snapOutputGeometry.destinationWidth = (int)d2;
        this.vpHandler = areaFitHandler;
    }

    @Override
    public void storeToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        AreaFitHandler areaFitHandler = this.vpHandler;
        this.vpHandler = snapOutputGeometry.getAreaFitHandler();
        this.vpHandler.set(areaFitHandler);
        snapOutputGeometry.initDestination();
        this.internalStoreToSnapshot(viewSnapshot);
        this.vpHandler = areaFitHandler;
    }

    @Override
    public void storeOverlaysToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        AreaFitHandler areaFitHandler = this.vpHandler;
        this.vpHandler = snapOutputGeometry.getAreaFitHandler();
        this.vpHandler.set(areaFitHandler);
        snapOutputGeometry.initDestination();
        viewSnapshot.applyOverlays(this.getOverlays());
        this.vpHandler = areaFitHandler;
    }

    protected abstract void internalStoreToSnapshot(ViewSnapshot var1);

    @Override
    public void synchronizeWith(Renderer renderer) {
        IMutableImageState iMutableImageState = renderer.getImageState();
        this.fitImage(iMutableImageState.getViewWidth(), iMutableImageState.getViewHeight());
        if (iMutableImageState.getWindow() != null && this.windowHandler != null) {
            this.windowHandler.setWindow(iMutableImageState.getWindow());
        }
        if (renderer instanceof RDCRenderer) {
            RDCRenderer rDCRenderer = (RDCRenderer)renderer;
            if (this.vpHandler.getClass() != rDCRenderer.vpHandler.getClass()) {
                this.vpHandler = rDCRenderer.vpHandler.getClone();
            } else {
                this.vpHandler.set(rDCRenderer.vpHandler);
            }
        } else {
            log.info("other is no RDCRenderer");
        }
    }

    @Override
    public void setGeometry(int n, int n2, int n3, int n4) {
        this.fitImage(n, n2);
    }

    @Override
    public Color getBackgroundColor() {
        if (whiteBackground) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private void applyIndexedColorPST(ILUTContainer iLUTContainer, boolean bl) {
        boolean bl2 = this.imageInformation.isInverse();
        boolean bl3 = this.frameObjectData.getRawDataContainer().getPixelDataFrame().isSigned();
        int n = this.imageInformation.getBitsStored();
        int n2 = -1;
        if (this.frameObjectData != null && this.frameObjectData.getDicomObject().containsValue(2621728)) {
            n2 = this.frameObjectData.getDicomObject().getInt(2621728, 0);
        }
        this.windowHandler = WindowHandlerBase.getInstance(this.imageInformation, iLUTContainer, bl2, bl3, this);
        this.tf = new SegmentedPaletteColorLUT(iLUTContainer.getPaletteColorLUT(), n, new WindowDef(iLUTContainer, this.imageInformation.getHighBit(), this.imageInformation.isSigned()), n2, bl);
        this.windowHandler.setTransferFunction((SegmentedPaletteColorLUT)this.tf);
        boolean bl4 = false;
        Set<ImageType> set = this.imageInformation.getImageType();
        if (set.contains(ImageType.PERFUSION) && set.contains(ImageType.SECONDARY)) {
            bl4 = true;
        }
        if (bl4) {
            ColorBarOverlay colorBarOverlay = new ColorBarOverlay(0.85, 0.2, 0.87, 0.8, AnnotationUnits.Display);
            this.addOverlay(colorBarOverlay);
            ModalityLUT modalityLUT = this.imageInformation.getModalityLUT();
            String string = this.imageInformation.getDataset().getString(0x204000);
            String string2 = null;
            if (string == null) {
                string2 = "";
            } else if (string.equals("Perfusion: BLOOD_VOLUME")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.BLOOD_VOLUME");
            } else if (string.equals("Perfusion: FLOW")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.FLOW");
            } else if (string.equals("Perfusion: FLOW_WITHOUT_VESSELS")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.FLOW_WITHOUT_VESSELS");
            } else if (string.equals("Perfusion: MEAN_TRANSIT_TIME")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.MEAN_TRANSIT_TIME");
            } else if (string.equals("Perfusion: PEAK_ENHANCEMENT")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.PEAK_ENHANCEMENT");
            } else if (string.equals("Perfusion: TIME_TO_PEAK")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.TIME_TO_PEAK");
            } else if (string.equals("Perfusion: TIME_TO_START")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.TIME_TO_START");
            }
            try {
                if (string2 != null && modalityLUT != null) {
                    colorBarOverlay.init((SegmentedPaletteColorLUT)this.tf, modalityLUT.getRescaleType().dicom(), string2);
                } else {
                    this.removeOverlay(colorBarOverlay);
                }
            }
            catch (Exception exception) {
                this.removeOverlay(colorBarOverlay);
                log.warn("Incomplete Perfusion image, ommiting overlay");
            }
        }
    }

    protected void applyLUTs(IFramePresentationState iFramePresentationState) {
        boolean bl = this.imageInformation.isInverse();
        int n = this.imageInformation.getHighBit();
        boolean bl2 = this.frameObjectData.getRawDataContainer().getPixelDataFrame().isSigned();
        PhotometricInterpretation photometricInterpretation = this.imageInformation.getPhotometricInterpretation();
        if (this.imageInformation.hasColorPaletteLUT() && iFramePresentationState.getForceLUT()) {
            photometricInterpretation = PhotometricInterpretation.IndexedColor;
        }
        if (photometricInterpretation == PhotometricInterpretation.IndexedColor && !iFramePresentationState.getForceLUT()) {
            photometricInterpretation = PhotometricInterpretation.Monochrome;
        }
        switch (photometricInterpretation) {
            case IndexedColor: {
                PaletteColorLUTWrapper paletteColorLUTWrapper = new PaletteColorLUTWrapper((ILUTContainer)this.imageInformation, (ILUTContainer)iFramePresentationState);
                if (paletteColorLUTWrapper.getPaletteColorLUT() != null) {
                    this.applyIndexedColorPST((ILUTContainer)paletteColorLUTWrapper, this.imageInformation.getPhotometricInterpretation() == PhotometricInterpretation.IndexedColor);
                    break;
                }
                GeneralWindowTransferFunction generalWindowTransferFunction = new GeneralWindowTransferFunction((ILUTContainer)paletteColorLUTWrapper, n, bl, bl2);
                this.windowHandler = WindowHandlerBase.getInstance(this.imageInformation, (ILUTContainer)iFramePresentationState, bl, bl2, this);
                this.windowHandler.setTransferFunction(generalWindowTransferFunction);
                this.tf = this.windowHandler.getTransferFunction();
                break;
            }
            case Color: {
                GeneralWindowTransferFunction generalWindowTransferFunction = new GeneralWindowTransferFunction((ILUTContainer)iFramePresentationState, n, bl, bl2);
                this.windowHandler = WindowHandlerBase.getInstance(this.imageInformation, (ILUTContainer)iFramePresentationState, bl, bl2, this);
                this.windowHandler.setTransferFunction(generalWindowTransferFunction);
                this.tf = this.windowHandler.getTransferFunction();
                break;
            }
            case RGBColor: {
                this.windowHandler = null;
                break;
            }
            default: {
                this.windowHandler = WindowHandlerBase.getInstance(this.imageInformation, (ILUTContainer)iFramePresentationState, bl, bl2, this);
                this.windowHandler.setNodeID(this.nodeID);
                this.tf = this.windowHandler.getTransferFunction();
            }
        }
        this.updateNearestNeighbourInterpolationSetting();
    }

    private void updateNearestNeighbourInterpolationSetting() {
        if (this.tf instanceof WindowTransferFunction) {
            this.getRawDataContainer().setNearestNeighbourInterpolation(((WindowTransferFunction)this.tf).useNearestNeighbourInterpolation());
        }
    }

    @Override
    public List<PresentationObject> applyPresentationState(IFramePresentationState iFramePresentationState) {
        return this.applyPresentationState(iFramePresentationState, null);
    }

    public List<PresentationObject> applyPresentationState(IFramePresentationState iFramePresentationState, IClearPresentationStateListener iClearPresentationStateListener) {
        EnumSet<View.CAPTURE_STATES> enumSet = this.captureStates();
        ArrayList<PresentationObject> arrayList = new ArrayList<PresentationObject>();
        if (iFramePresentationState != null) {
            this.clearPresentationState(iFramePresentationState);
            if (iClearPresentationStateListener != null) {
                iClearPresentationStateListener.onClearPresentationState(iFramePresentationState);
            }
        }
        try {
            IDisplayedArea iDisplayedArea;
            PresentationLUT presentationLUT;
            boolean bl = this.imageInformation.isInverse();
            int n = this.imageInformation.getHighBit();
            boolean bl2 = this.frameObjectData.getRawDataContainer().getPixelDataFrame().isSigned();
            boolean bl3 = this.isVOILutInPSSame(iFramePresentationState);
            if (bl3) {
                iFramePresentationState.setVOILUT(this.imageInformation.getVOILUT());
            }
            if (this.useImageModalityLutForPS(iFramePresentationState)) {
                iFramePresentationState.setModalityLUT(this.imageInformation.getModalityLUT());
            }
            if (enumSet.contains((Object)View.CAPTURE_STATES.WINDOW_LEVEL)) {
                this.applyLUTs(iFramePresentationState);
            }
            if (enumSet.contains((Object)View.CAPTURE_STATES.TRANSFORMATION) && iFramePresentationState != null && iFramePresentationState.getSpatialTransformation() != null) {
                presentationLUT = new Matrix2d(Orientation.createStandardTransform2D(this.imageInformation));
                presentationLUT.invert();
                SpatialTransformationUtils.toImageTransform(iFramePresentationState.getSpatialTransformation(), (Matrix2d)presentationLUT);
                this.applyTransform((Matrix2d)presentationLUT);
            }
            PresentationLUT presentationLUT2 = presentationLUT = iFramePresentationState == null ? null : iFramePresentationState.getPresentationLUT();
            if (enumSet.contains((Object)View.CAPTURE_STATES.WINDOW_LEVEL) && presentationLUT != null && !bl3 && PresentationLUTShape.Color == presentationLUT.getPresentationLUTShape()) {
                this.tf = new GeneralWindowTransferFunction((ILUTContainer)iFramePresentationState, n, bl, bl2);
                this.windowHandler.setTransferFunction((WindowTransferFunction)this.tf);
            }
            IDisplayedArea iDisplayedArea2 = iDisplayedArea = iFramePresentationState == null ? null : iFramePresentationState.getDisplayedArea();
            if (iDisplayedArea != null) {
                boolean bl4 = enumSet.contains((Object)View.CAPTURE_STATES.ZOOM_PAN);
                this.applyDisplayedArea(iDisplayedArea, iFramePresentationState, bl4);
            } else {
                this.setDefaultSpacing();
            }
            if (iFramePresentationState != null) {
                List<PresentationObject> list = this.constructMarkups(iFramePresentationState);
                arrayList.addAll(list);
            }
        }
        catch (Exception exception) {
            log.error("error", (Throwable)exception);
        }
        this.invalidate();
        return arrayList;
    }

    private void resetSpacing() {
        this.removePresentationStateSpacing();
        this.setDefaultSpacing();
    }

    private void applyDisplayedArea(IDisplayedArea iDisplayedArea, IFramePresentationState iFramePresentationState, boolean bl) {
        if (iFramePresentationState.isExternal() || iFramePresentationState.isTemporary()) {
            double[] dArray = iDisplayedArea.getPresentationPixelSpacing();
            int[] nArray = iDisplayedArea.getPresentationPixelAspectRatio();
            if (dArray != null && dArray.length > 0) {
                SpacingDef spacingDef = new SpacingDef();
                spacingDef.setDataPixelSizeX(dArray[1]);
                spacingDef.setDataPixelSizeY(dArray[0]);
                spacingDef.setSizeUnit(SpacingDef.Unit.mm_pres);
                if (!spacingDef.hasEqualSizing(((ImageState)this.imageState).getCurrentSpacingDef())) {
                    ((ImageState)this.imageState).setCurrentSpacingDef(spacingDef);
                    this.activedef.resetAspectRatio();
                    this.activedef.setPixelSpacing(spacingDef);
                }
            } else if (nArray != null && nArray.length > 0) {
                if (nArray[0] != 0 || nArray[1] != 0) {
                    this.activedef.setAspectRatio(nArray[1], nArray[0]);
                }
            } else {
                this.resetSpacing();
            }
        } else {
            this.resetSpacing();
            double d = this.vpHandler.getViewportCenterAlignmentX().calculateViewportCenterX(1, this.activedef.getColumnCount(), this.activedef.getColumnCount());
            this.activedef.setViewportCenter(new Vector2d(d, 0.5));
            this.vpHandler = new FullVisualFitHandler(this.vpHandler);
            this.vpHandler.resetZoomFactor();
            bl = false;
        }
        if (bl) {
            int n = iDisplayedArea.getDisplayedAreaTopLeftHandCorner()[0];
            int n2 = iDisplayedArea.getDisplayedAreaTopLeftHandCorner()[1];
            int n3 = iDisplayedArea.getDisplayedAreaBottomRightHandCorner()[0];
            int n4 = iDisplayedArea.getDisplayedAreaBottomRightHandCorner()[1];
            int n5 = 0;
            YN yN = YN.No;
            if (iFramePresentationState.getSpatialTransformation() != null) {
                n5 = iFramePresentationState.getSpatialTransformation().getImageRotation();
                yN = iFramePresentationState.getSpatialTransformation().getImageHorizontalFlip();
            }
            if (n2 != n4 && n != n3) {
                DisplayedAreaOrientation displayedAreaOrientation = n < n3 && n2 < n4 ? DisplayedAreaOrientation.REGULAR : (n < n3 && n2 > n4 ? DisplayedAreaOrientation.TOP_BOTTOM_SWAPPED : (n > n3 && n2 > n4 ? DisplayedAreaOrientation.ALL_SWAPPED : DisplayedAreaOrientation.LEFT_RIGHT_SWAPPED));
                double d = (double)(n2 + n4 - 1) / (double)(2 * this.activedef.getRowCount());
                double d2 = this.vpHandler.getViewportCenterAlignmentX().calculateViewportCenterX(n, n3, this.activedef.getColumnCount());
                if (displayedAreaOrientation.isCompatibleSpatialTransformation(n5, yN)) {
                    this.activedef.setViewportCenter(new Vector2d(d2, d));
                } else {
                    this.activedef.setTransformedViewportCenter(d2, d);
                }
                PresentationSizeMode presentationSizeMode = iDisplayedArea.getPresentationSizeMode();
                if (presentationSizeMode == PresentationSizeMode.TrueSize && !ZoomUtils.isTrueSizeZoomAllowed()) {
                    presentationSizeMode = PresentationSizeMode.ScaleToFit;
                }
                switch (presentationSizeMode) {
                    case Magnify: {
                        float f = iDisplayedArea.getPresentationPixelMagnificationRatio().floatValue();
                        if (Math.abs((double)f - 1.0) < 0.01) {
                            this.vpHandler = new PixelIdentityFitHandler(this.vpHandler);
                            this.vpHandler.resetZoomFactor();
                            break;
                        }
                        log.info("GSPS with Magnify and zoom factor, ignoring it");
                    }
                    case ScaleToFit: {
                        this.vpHandler = new FullVisualFitHandler(this.vpHandler, this.activedef, n2, n, n4, n3);
                        break;
                    }
                    case TrueSize: {
                        AreaFitHandler areaFitHandler = this.vpHandler;
                        this.vpHandler = new TrueSizeFitHandler();
                        this.vpHandler.setViewportCenterAlignmentX(areaFitHandler.getViewportCenterAlignmentX());
                    }
                }
            }
        }
    }

    private boolean isVOILutInPSSame(IFramePresentationState iFramePresentationState) {
        return this.imageInformation.getVOILUT() != null && iFramePresentationState.getVOILUT() == null;
    }

    private boolean useImageModalityLutForPS(IFramePresentationState iFramePresentationState) {
        return this.imageInformation.getModalityLUT() != null && iFramePresentationState.getModalityLUT() == null;
    }

    @Override
    public void clearPresentationState(IFramePresentationState iFramePresentationState) {
        this.reset(this.captureStates().contains((Object)View.CAPTURE_STATES.TRANSFORMATION));
        this.clearOverlaysForPresentationState(iFramePresentationState);
    }

    private List<PresentationObject> constructMarkups(IFramePresentationState iFramePresentationState) {
        Object object;
        Iterator<PresentationObject> iterator2;
        Cloneable cloneable2;
        Object object2;
        ArrayList<PresentationObject> arrayList = new ArrayList<PresentationObject>(2);
        List list = iFramePresentationState.getGraphicAnnotations();
        if (list != null && !list.isEmpty()) {
            Object object3;
            Object object4;
            object2 = new HashMap();
            cloneable2 = new ArrayList();
            for (Iterator<PresentationObject> iterator2 : list) {
                PresentationObject presentationObject2;
                Object object5;
                List list2 = iterator2.graphicObjects();
                int n = 0;
                while (n < list2.size()) {
                    object4 = (GraphicObject)list2.get(n);
                    object5 = object4.getTianiROIID();
                    if (object5 != null && (((String)(object5 = ((String)object5).trim())).startsWith("H") || ((String)object5).startsWith("P"))) {
                        cloneable2.add(object4);
                    } else {
                        int n2;
                        int n3;
                        if (object4.getGraphicType() == GraphicType.PolyLine && object4.getTianiSubType() != null && object4.getTianiSubType().getPartCount() > 1 && (n3 = n + (n2 = object4.getTianiSubType().getPartCount()) - 1) < list2.size()) {
                            int n4 = 0;
                            int n5 = n;
                            while (n5 <= n3) {
                                float[] fArray = ((GraphicObject)list2.get(n5)).getGraphicData();
                                n4 += fArray.length;
                                ++n5;
                            }
                            Object object6 = new float[n4];
                            int n6 = 0;
                            int n7 = n;
                            while (n7 <= n3) {
                                float[] fArray = ((GraphicObject)list2.get(n7)).getGraphicData();
                                System.arraycopy(fArray, 0, object6, n6, fArray.length);
                                n6 += fArray.length;
                                ++n7;
                            }
                            object4.setGraphicData((float[])object6);
                            object4.setNumberOfGraphicPoints(Integer.valueOf(((Object)object6).length / 2));
                            n = n3;
                        }
                        if ((presentationObject2 = ROIFactory.makeBasicGraphicMarkup((GraphicObject)object4, 1, iterator2.isSaved())) != null) {
                            presentationObject2.setProviderUID(iFramePresentationState.getProviderUID());
                            presentationObject2.setName(String.valueOf(object4.getGraphicType().dicom()) + " [" + iterator2.getGraphicLayer() + "]");
                            presentationObject2.setLayerLabel(iterator2.getGraphicLayer());
                            this.addOverlay(presentationObject2);
                            arrayList.add(presentationObject2);
                            object2.put(presentationObject2.getID(), presentationObject2);
                        }
                    }
                    ++n;
                }
                object3 = iterator2.getGraphicLayer();
                object4 = iFramePresentationState.getGraphicLayers();
                object5 = null;
                if (object4 != null) {
                    Iterator iterator3 = object4.iterator();
                    while (iterator3.hasNext()) {
                        presentationObject2 = (GraphicLayer)iterator3.next();
                        if (((String)object3).equals(presentationObject2.getGraphicLayer()) && ("ROI".equals(object3) && "[Default Layer]".equals(presentationObject2.getGraphicLayerDescription()) || (object5 = presentationObject2.getColor(ComponentFactory.instance.isOnColorMonitor())) != null)) break;
                    }
                }
                for (PresentationObject presentationObject2 : iterator2.textObjects()) {
                    for (PresentationObject presentationObject3 : ROIFactory.makeTextMarkup((TextObject)presentationObject2, 1, iterator2.isSaved())) {
                        presentationObject3.setProviderUID(iFramePresentationState.getProviderUID());
                        presentationObject3.setName("Text [" + iterator2.getGraphicLayer() + "]");
                        presentationObject3.setLayerLabel(iterator2.getGraphicLayer());
                        if (object5 != null) {
                            presentationObject3.setColor((Color)object5);
                        }
                        this.addOverlay(presentationObject3);
                        PresentationObject presentationObject4 = (PresentationObject)object2.get(presentationObject3.getID());
                        if (presentationObject4 != null) {
                            if (object5 != null) {
                                presentationObject4.setColor((Color)object5);
                            }
                            presentationObject4.addCompanion(presentationObject3);
                        }
                        arrayList.add(presentationObject3);
                    }
                }
            }
            object = cloneable2.iterator();
            while (object.hasNext()) {
                iterator2 = (GraphicObject)object.next();
                try {
                    int n = Integer.parseInt(iterator2.getTianiROIID().substring(1));
                    object3 = (PresentationObject)object2.get(n);
                    if (object3 == null) continue;
                    object4 = ROIFactory.makeLinkedGraphicMarkup(iterator2, 1, (PresentationObject)object3, true);
                    ((PresentationObject)object3).addCompanion((PresentationObject)object4);
                    arrayList.add((PresentationObject)object4);
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("Error", (Throwable)numberFormatException);
                }
            }
        }
        if ((object2 = Shutter.createShutterObjectPST(iFramePresentationState)) != null) {
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                cloneable2 = iterator2.next();
                ((PresentationObject)cloneable2).setProviderUID(iFramePresentationState.getProviderUID());
                ((PresentationObject)cloneable2).setName("Shutter");
                ((Overlay)cloneable2).setLayerLabel("__JV_DEFAULT__");
                this.addOverlay((Overlay)cloneable2);
                arrayList.add((PresentationObject)cloneable2);
            }
        }
        if (iFramePresentationState.getOverlayFrames() != null) {
            for (Cloneable cloneable2 : iFramePresentationState.getOverlayFrames()) {
                if (cloneable2 == null) continue;
                object = new OverlayBitmap(new BitmapOverlay((OverlayFrame)cloneable2));
                ((OverlayBitmap)object).setProviderUID(iFramePresentationState.getProviderUID());
                ((OverlayBitmap)object).setLayerLabel("__JV_DEFAULT__");
                this.addOverlay((Overlay)object);
            }
        }
        this.currentFramePresentationState = iFramePresentationState;
        return arrayList;
    }

    private void removePresentationStateSpacing() {
        Iterable iterable = ((ImageState)this.imageState).spacingDefs();
        ArrayList<SpacingDef> arrayList = new ArrayList<SpacingDef>();
        int n = iterable.size() - 1;
        while (n >= 0) {
            SpacingDef spacingDef = (SpacingDef)iterable.get(n);
            if (spacingDef.getSizeUnit() == SpacingDef.Unit.mm_pres) {
                arrayList.add(spacingDef);
            }
            --n;
        }
        for (SpacingDef spacingDef : arrayList) {
            ((ImageState)this.imageState).removeSpacingDef(spacingDef);
        }
    }

    private void setDefaultSpacing() {
        int[] nArray;
        SpacingDef spacingDef = this.getDefaultSpacing();
        this.activedef.resetAspectRatio();
        if (spacingDef != null) {
            this.activedef.setPixelSpacing(spacingDef);
        }
        if ((nArray = this.imageInformation.getPixelAspectRatio()) != null) {
            this.activedef.setAspectRatio(nArray[1], nArray[0]);
        }
    }

    @Override
    public IFramePresentationState getCurrentFramePresentationState() {
        return this.currentFramePresentationState;
    }

    @Override
    public IFrameObjectData getFrameObjectData() {
        return this.frameObjectData;
    }

    public EnumSet<View.CAPTURE_STATES> captureStates() {
        return EnumSet.allOf(View.CAPTURE_STATES.class);
    }

    @Override
    public IPresentationState getPresentationState() {
        return this.getPresentationState(this.captureStates());
    }

    @Override
    public IPresentationState getPresentationState(Set<View.CAPTURE_STATES> set) {
        if (!RDCPresentationState.isSupported(this.frameObjectData)) {
            return null;
        }
        return new RDCPresentationState(this, set);
    }

    @Override
    public IPresentationState getPresentationState(int n, int n2) {
        this.fitImage(n, n2);
        return this.getPresentationState();
    }

    @Override
    public PresentationLUT getPresentationLUT() {
        if (this.windowHandler == null) {
            return null;
        }
        GrayScaleTransformationSequence grayScaleTransformationSequence = this.windowHandler.getGSTS();
        if (grayScaleTransformationSequence == null) {
            return null;
        }
        return grayScaleTransformationSequence.createPresentationLUT();
    }

    private SpacingDef getDefaultSpacing() {
        Iterable iterable = ((ImageState)this.imageState).spacingDefs();
        if (!iterable.isEmpty()) {
            return (SpacingDef)iterable.get(iterable.size() - 1);
        }
        return null;
    }

    public void setAlternativeImageState(ImageState imageState) {
        this.imageState = imageState;
    }

    public void setActiveImageDef(ImageDef imageDef) {
        this.activedef = imageDef;
    }

    @Override
    public ImageDef getActiveImageDef() {
        return this.activedef;
    }

    @Override
    public double[] getInterchangeableViewportCenter() {
        return this.activedef.getInterchangeableViewportCenter();
    }

    @Override
    public boolean isImageLoaded() {
        return true;
    }

    @Override
    public void checkImageLoaded() {
    }

    private static class ConfigListener
    implements IConfigurationChangeListener {
        private ConfigListener() {
        }

        public void configurationChanged(String string) {
            RDCRenderer.initInfoRegion();
        }
    }

    public static interface IClearPresentationStateListener {
        public void onClearPresentationState(IFramePresentationState var1);
    }

    private static class InteractionInfoHolder {
        public double xstart;
        public double ystart;

        private InteractionInfoHolder() {
        }
    }

    private static class MouseWheelZoomParameter
    implements IZoomablePixelSizeProvider {
        private final IPixelSizeProvider pixelSizeProvider;
        private final double relativeZoomFactorChange;

        private MouseWheelZoomParameter(IRDCRenderer iRDCRenderer, double d) {
            this.pixelSizeProvider = iRDCRenderer;
            this.relativeZoomFactorChange = d;
        }

        static ZoomParameter create(IRDCRenderer iRDCRenderer, double d) {
            return ZoomParameter.relative(new MouseWheelZoomParameter(iRDCRenderer, d), d, null);
        }

        @Override
        public SpacingDef getCurrentSpacingDef() {
            return this.pixelSizeProvider.getCurrentSpacingDef();
        }

        @Override
        public double getScreenPixelSizeX() {
            return this.pixelSizeProvider.getScreenPixelSizeX() / this.relativeZoomFactorChange;
        }

        @Override
        public double[] getInterchangeableViewportCenter() {
            return null;
        }
    }
}

