/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.RawDataContainer;
import com.tiani.base.data.RawDataContainer16CT;
import com.tiani.base.data.RawDataContainer16NM;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.fithandler.PixelIdentityFitHandler;
import com.tiani.jvision.renderer.RDCRenderer;
import com.tiani.util.TicketOffice;
import java.awt.Rectangle;
import java.util.Arrays;

public class RDCRenderer16
extends RDCRenderer {
    private static final ALogger log = ALogger.getLogger(RDCRenderer16.class);
    private RawDataContainer16CT rdc;

    public RDCRenderer16(IFrameObjectData iFrameObjectData, boolean bl, ZoomMode zoomMode) {
        super(iFrameObjectData, bl);
        if (zoomMode == ZoomMode.PIXELIDENTITY) {
            this.vpHandler = new PixelIdentityFitHandler();
        }
        this.rdc = (RawDataContainer16CT)iFrameObjectData.getRawDataContainer();
    }

    @Override
    public int getRawContentType() {
        return 2;
    }

    @Override
    public RDCRenderer16 clone() {
        RDCRenderer16 rDCRenderer16 = (RDCRenderer16)super.clone();
        rDCRenderer16.windowingDataId = null;
        return rDCRenderer16;
    }

    @Override
    public void clearWindowingCache() {
        CacheID cacheID = this.windowingDataId;
        if (cacheID != null) {
            this.windowingDataId = null;
            tempCache.getContentShorts(cacheID);
            cacheID = null;
        }
    }

    @Override
    protected void extractTo(int[] nArray, int n, int n2, int n3, int n4) {
        int[] nArray2 = this.tf.getRGB(false);
        int n5 = this.tf.getOffset(false);
        Rectangle rectangle = this.fitImage(n, n2);
        n3 += rectangle.x + rectangle.y * n4;
        n = rectangle.width;
        n2 = rectangle.height;
        try {
            this.rdc.extract32bitFull(nArray, n, n2, n3, n4, this.xs, this.ys, this.ws, this.hs, this.transform, nArray2, n5);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            log.warn("cleaning high bits: non-registered overlay in image?:" + this.tf.getGrays(), (Throwable)arrayIndexOutOfBoundsException);
            try {
                this.rdc.extract32bitFull(nArray, n, n2, n3, n4, this.xs, this.ys, this.ws, this.hs, this.transform, nArray2, n5);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                log.warn("2nd ex: non-registered overlay in image?:" + this.tf.getGrays(), (Throwable)arrayIndexOutOfBoundsException2);
                Arrays.fill(nArray, 0);
            }
        }
        catch (Exception exception) {
            log.warn("Error on image drawing occured", (Throwable)exception);
            Arrays.fill(nArray, 0);
        }
        if (this.fillBG) {
            this.doFillBackground(nArray, n, n2, n3, n4, this.getBackgroundColor().getRGB());
        }
        this.setContentStamp(TicketOffice.getNewStamp(), 0);
    }

    @Override
    protected void separateExtractTo(int[] nArray, int n, int n2, int n3, int n4) {
        if (this.rdc instanceof RawDataContainer16NM) {
            this.extractTo(nArray, n, n2, n3, n4);
            return;
        }
        short[] sArray = null;
        if (this.windowingDataId != null && ((sArray = tempCache.getContentShorts(this.windowingDataId)) == null || sArray.length != n * n2)) {
            this.windowingDataId = null;
        }
        if (this.windowingDataId == null) {
            sArray = (short[])this.getRaw(n, n2, n3, n4, nArray.length, 2, true);
            this.windowingDataId = tempCache.createNewTemporaryCacheID();
        }
        int[] nArray2 = this.tf.getRGB(false);
        Rectangle rectangle = this.fitImage(n, n2);
        n = rectangle.width;
        n2 = rectangle.height;
        this.raw16ToRGB(sArray, n, n2, n3 += rectangle.x + rectangle.y * n4, n4, nArray2, nArray, n3, n4);
        try {
            tempCache.putContentShorts(sArray, this.windowingDataId);
        }
        catch (Exception exception) {
            log.warn("Could not put windowing cache into memory", (Throwable)exception);
            this.windowingDataId = null;
        }
        if (this.fillBG) {
            this.doFillBackground(nArray, n, n2, n3, n4, this.getBackgroundColor().getRGB());
        }
        this.setContentStamp(TicketOffice.getNewStamp(), 0);
    }

    @Override
    public void setRawBuffer(Object object) {
        this.clearWindowingCache();
    }

    @Override
    public Object getRaw(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        short s;
        this.invalid = false;
        if (n6 == 0) {
            return super.getRaw(n, n2, n3, n4, n5, n6, bl);
        }
        Rectangle rectangle = this.fitImage(n, n2);
        int n7 = this.tf.getOffset(false);
        short[] sArray = new short[n * n2];
        n3 += rectangle.x + rectangle.y * n4;
        n = rectangle.width;
        n2 = rectangle.height;
        try {
            this.rdc.extract16bitFull(sArray, n, n2, n3, n4, this.xs, this.ys, this.ws, this.hs, this.transform, n7);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            log.warn("cleaning high bits: non-registered overlay in image?:" + this.tf.getGrays(), (Throwable)arrayIndexOutOfBoundsException);
            try {
                this.rdc.extract16bitFull(sArray, n, n2, n3, n4, this.xs, this.ys, this.ws, this.hs, this.transform, n7);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                log.warn("2nd ex: non-registered overlay in image?:" + this.tf.getGrays(), (Throwable)arrayIndexOutOfBoundsException2);
                Arrays.fill(sArray, (short)0);
            }
        }
        if (this.fillBG && (s = (short)(this.tf.isRawDataInverted() ? this.getMaxRawValue() : 0)) != 0) {
            this.doFillBackground(sArray, n, n2, n3, n4, s);
        }
        this.invalid = false;
        return sArray;
    }

    @Override
    public RawDataContainer getRawDataContainer() {
        return this.rdc;
    }

    @Override
    protected void internalStoreToSnapshot(ViewSnapshot viewSnapshot) {
        if (!viewSnapshot.forceRGB()) {
            short[] sArray = (short[])this.getRaw(viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), viewSnapshot.getWidth() * viewSnapshot.getHeight(), 2, false);
            viewSnapshot.setDataBuffer(sArray);
        } else {
            viewSnapshot.setDataBuffer(this.getRaw(viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), viewSnapshot.getWidth() * viewSnapshot.getHeight(), 0, false));
        }
    }

    @Override
    protected void setRawDataContainer(RawDataContainer rawDataContainer) {
        this.rdc = (RawDataContainer16CT)rawDataContainer;
    }
}

