/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.LayeredView;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.renderer.ImageFilterNode;
import com.tiani.jvision.renderer.IntermediateNode;
import com.tiani.jvision.renderer.MessageFilter;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.renderer.filter.ImageFilterOperator;
import com.tiani.jvision.renderer.filter.ImageFilterOperatorFactory;
import com.tiani.jvision.toptoolbar.FilterActions;
import com.tiani.jvision.vis.VisData;
import com.tiani.util.expressions.IEvaluablePrivateData;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RendererTree
implements IEvaluablePrivateData {
    private static final ALogger log = ALogger.getLogger(RendererTree.class);
    private static final Object rendererTreeSync = new Object();
    protected Renderer root;
    private Renderer paintRoot;
    private Renderer eventRoot;
    private MessageFilter messageFilter;

    public void setRoot(Renderer renderer, View view) {
        this.root = renderer;
        this.paintRoot = renderer;
        this.setEventRoot(renderer, view);
    }

    private void setEventRoot(Renderer renderer, View view) {
        this.eventRoot = renderer;
        if (view != null && view.getVis() != null && VisData.getLastModified() == view.getVis()) {
            this.broadcastEventRootChange(view);
        }
    }

    private void broadcastEventRootChange(View view) {
        TEvent tEvent = new TEvent(53);
        Runnable runnable = () -> TEventDispatch.sendEvent(tEvent, (Object)view, 4096);
        try {
            EventUtil.invoke((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error("Broadcasting event root change failed", (Throwable)exception);
        }
    }

    public Renderer cloneTree() {
        if (this.paintRoot == null) {
            return null;
        }
        return this.paintRoot.clone();
    }

    public Renderer getRoot() {
        return this.root;
    }

    public Renderer getPaintRoot() {
        return this.paintRoot;
    }

    public Renderer getEventRoot() {
        return this.eventRoot;
    }

    public List<IMenuEntry> getLegacyMenuEntries(View view) {
        if (this.root != null) {
            return this.root.getLegacyMenuEntries(view);
        }
        return new ArrayList<IMenuEntry>(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
        Object object = rendererTreeSync;
        synchronized (object) {
            if (this.paintRoot != null) {
                this.paintRoot.paint(rGBBufferedImageHolder, n, n2, n3, n4, bl);
            }
        }
    }

    public void syncAll(Map<String, Renderer> map) {
        this.sync(this.root, map);
    }

    private void sync(Renderer renderer, Map<String, Renderer> map) {
        if (renderer == null) {
            return;
        }
        if (renderer instanceof IntermediateNode) {
            List<Renderer> list = ((IntermediateNode)renderer).getChildren();
            for (Renderer renderer2 : list) {
                this.sync(renderer2, map);
            }
        }
        if (map.get(renderer.getName()) == null) {
            renderer.syncByName();
            map.put(renderer.getName(), renderer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (this.root == null) {
            return false;
        }
        Object object2 = rendererTreeSync;
        synchronized (object2) {
            Renderer renderer = this.eventRoot;
            if ((n & 0x200) != 0) {
                this.setEventRoot(this.root, view);
            }
            try {
                switch (tEvent.id) {
                    case 12: {
                        Object object3;
                        ImageFilterOperator imageFilterOperator = null;
                        if (object instanceof ImageFilterOperator) {
                            imageFilterOperator = (ImageFilterOperator)((ImageFilterOperator)object).getInstance();
                        } else {
                            object3 = null;
                            if (object instanceof FilterActions.FilterType) {
                                object3 = ((FilterActions.FilterType)((Object)object)).name();
                            } else if (object instanceof String) {
                                object3 = (String)object;
                            }
                            if (object3 != null) {
                                imageFilterOperator = (ImageFilterOperator)ImageFilterOperatorFactory.getInstance().getComponent((String)object3);
                            }
                        }
                        if (imageFilterOperator == null) {
                            if (this.eventRoot == this.root && this.eventRoot instanceof ImageFilterNode) {
                                object3 = this.root;
                                this.root = ((ImageFilterNode)this.root).getChildren().get(0);
                                ((IntermediateNode)object3).removeSubtree(this.root);
                                this.root.invalidate();
                                renderer = this.root;
                                this.setEventRoot(this.root, view);
                                if (this.paintRoot == object3) {
                                    this.paintRoot = this.root;
                                }
                            } else {
                                object3 = this.eventRoot;
                                if (this.eventRoot instanceof ImageFilterNode) {
                                    renderer = ((ImageFilterNode)this.eventRoot).getChildren().get(0);
                                    this.setEventRoot(renderer, view);
                                }
                                if (this.paintRoot instanceof ImageFilterNode) {
                                    this.paintRoot = ((ImageFilterNode)this.paintRoot).getChildren().get(0);
                                }
                                ((Renderer)object3).handleTEvent(tEvent, object, n, view);
                            }
                            view.invalidate();
                            view.repaint();
                            view.actionFinished(null);
                        } else {
                            if (!this.eventRoot.handleTEvent(tEvent, object, n, view)) {
                                object3 = this.eventRoot;
                                renderer = new ImageFilterNode(this.eventRoot);
                                this.setEventRoot(renderer, view);
                                if (tEvent.destinationNodeID == 0) {
                                    tEvent.destinationNodeID = Renderer.getNewNodeID();
                                }
                                this.eventRoot.setNodeID(tEvent.destinationNodeID);
                                this.eventRoot.handleTEvent(tEvent, object, n, view);
                                if (this.paintRoot == object3) {
                                    this.paintRoot = this.eventRoot;
                                }
                                if (this.root == object3) {
                                    this.root = this.eventRoot;
                                } else {
                                    ((IntermediateNode)this.root).replaceNode((Renderer)object3, this.eventRoot);
                                }
                            }
                            view.invalidate();
                            view.repaint();
                            view.actionFinished(null);
                        }
                        return true;
                    }
                }
                if (this.messageFilter != null && this.messageFilter.handleTEvent(tEvent, object, n, (LayeredView)view)) {
                    return true;
                }
                if (tEvent.destinationNodeID == 0) {
                    boolean bl = this.eventRoot.handleTEvent(tEvent, object, n, view);
                    return bl;
                }
                boolean bl = this.root.handleTEvent(tEvent, object, n, view);
                return bl;
            }
            finally {
                if (renderer != null) {
                    this.eventRoot = renderer;
                }
            }
        }
    }

    public boolean handleHotRegionPressed(String string, Rectangle rectangle, MouseEvent mouseEvent, LayeredView layeredView) {
        if (this.messageFilter != null && this.messageFilter.handleHotRegionPressed(string, rectangle, mouseEvent, layeredView)) {
            return true;
        }
        return this.eventRoot.handleHotRegionPressed(string, rectangle, mouseEvent, layeredView);
    }

    public boolean handleHotRegionReleased(String string, MouseEvent mouseEvent, int n, int n2, LayeredView layeredView) {
        if (this.messageFilter != null && this.messageFilter.handleHotRegionReleased(string, mouseEvent, n, n2, layeredView)) {
            return true;
        }
        return this.eventRoot.handleHotRegionReleased(string, mouseEvent, n, n2, layeredView);
    }

    public boolean handleHotRegionDragged(String string, MouseEvent mouseEvent, int n, int n2, int n3, int n4, LayeredView layeredView) {
        if (this.messageFilter != null && this.messageFilter.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, layeredView)) {
            return true;
        }
        return this.eventRoot.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, layeredView);
    }

    public boolean wantsMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        return this.eventRoot.wantsMouseWheelEvent(mouseWheelEvent);
    }

    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent, LayeredView layeredView) {
        return this.eventRoot.handleMouseWheel(mouseWheelEvent, layeredView);
    }

    public void cleanUp() {
        if (this.root == null) {
            return;
        }
        this.root.cleanUp();
        this.root = null;
        this.paintRoot = null;
        this.eventRoot = null;
    }

    public IMutableImageState getImageState() {
        if (this.paintRoot != null) {
            return this.paintRoot.getImageState();
        }
        return ImageState.getDefaultImageState();
    }

    public ViewSnapshot renderToSnapshot(int n, int n2, int n3, int n4, double d, double d2, View.OverlayMode overlayMode, boolean bl) {
        if (this.paintRoot == null) {
            return null;
        }
        SnapOutputGeometry snapOutputGeometry = null;
        snapOutputGeometry = d != 0.0 && d2 != 0.0 ? new SnapOutputGeometry(n, n2, n3, n4, d, d2) : new SnapOutputGeometry(n, n2, n3, n4);
        List<Overlay> list = this.paintRoot.getOverlays();
        if (list != null && !bl) {
            int n5 = 0;
            while (n5 < list.size()) {
                if (list.get(n5).captureAsRGB()) {
                    bl = true;
                    break;
                }
                ++n5;
            }
        }
        if (n != n3 || n2 != n4) {
            this.paintRoot.getOptimumOutputSize(snapOutputGeometry);
        } else {
            snapOutputGeometry.destinationWidth = n;
            snapOutputGeometry.destinationHeight = n2;
        }
        ViewSnapshot viewSnapshot = new ViewSnapshot(overlayMode, snapOutputGeometry.destinationWidth, snapOutputGeometry.destinationHeight, bl);
        this.paintRoot.storeToSnapshot(viewSnapshot, snapOutputGeometry);
        if (bl) {
            viewSnapshot.setForceRGB(true);
        }
        this.paintRoot.storeOverlaysToSnapshot(viewSnapshot, snapOutputGeometry);
        return viewSnapshot;
    }

    public MessageFilter getMessageFilter() {
        return this.messageFilter;
    }

    public void setMessageFilter(MessageFilter messageFilter) {
        this.messageFilter = messageFilter;
    }

    @Override
    public Object resolveString(String string) {
        if (this.paintRoot != null) {
            return this.paintRoot.resolveString(string);
        }
        return null;
    }
}

