/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.tiani.base.data.IFrameListener;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.RawDataContainer;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.DoubleDimension;
import com.tiani.jvision.image.IEarlyEvent;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.LeafRenderer;
import com.tiani.jvision.renderer.RDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.renderer.SelectorNode;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisHRSet;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WaitingForFrameRendererAdapter
extends LeafRenderer
implements IRDCRenderer,
IFrameListener {
    private IFrameObjectData frame = null;
    private View view = null;
    private VisDisplayData visDisplayData = null;
    private RDCRenderer renderer = null;
    private String rendererNameForSet = null;
    private Renderer forSyncRenderer = null;
    private AreaFitHandler fithandler = null;
    private boolean borderLockMode = false;
    private Queue<IEarlyEvent> earlyEvents = new LinkedList<IEarlyEvent>();
    private List<Overlay> overlaysToBeAddedToRealRenderer = new ArrayList<Overlay>(2);
    private CountDownLatch loaded = new CountDownLatch(1);
    private IFrameListener listener;

    public WaitingForFrameRendererAdapter(IFrameObjectData iFrameObjectData, View view, VisDisplayData visDisplayData) {
        this.frame = iFrameObjectData;
        this.view = view;
        this.visDisplayData = visDisplayData;
        iFrameObjectData.addListener(this);
    }

    public void setListener(IFrameListener iFrameListener) {
        this.listener = iFrameListener;
    }

    @Override
    public void notifyHasError(String string) {
    }

    public Renderer getRendererBehind() {
        return this.renderer;
    }

    private synchronized void initRealRenderer() {
        if (this.renderer != null) {
            return;
        }
        boolean bl = this.visDisplayData.getVisDisplay().getAction("ZOOM_PIXEL_1x1").isSelected();
        RDCRenderer rDCRenderer = RDCRenderer.createRenderer(this.frame, false, bl ? ZoomMode.PIXELIDENTITY : ZoomMode.NORMAL);
        if (this.rendererNameForSet != null) {
            rDCRenderer.setName(this.rendererNameForSet);
        }
        IEarlyEvent iEarlyEvent = this.earlyEvents.poll();
        while (iEarlyEvent != null) {
            if (iEarlyEvent.isPresentationState()) {
                EarlyPresentationState earlyPresentationState = (EarlyPresentationState)iEarlyEvent;
                List<PresentationObject> list = rDCRenderer.applyPresentationState(earlyPresentationState.presState);
                Iterator<PresentationObject> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Overlay overlay = iterator.next();
                    rDCRenderer.addOverlay(overlay);
                }
            } else {
                TEvent tEvent = (TEvent)iEarlyEvent;
                Object object2 = tEvent.source;
                rDCRenderer.handleTEvent(tEvent, object2, 0, this.view);
            }
            iEarlyEvent = this.earlyEvents.poll();
        }
        this.earlyEvents = null;
        rDCRenderer.setBorderLockMode(this.borderLockMode);
        if (this.fithandler != null) {
            rDCRenderer.setAreaFitHandler(this.fithandler);
        }
        if (this.forSyncRenderer != null) {
            if (this.forSyncRenderer instanceof SelectorNode) {
                SelectorNode selectorNode = (SelectorNode)this.forSyncRenderer;
                this.forSyncRenderer = selectorNode.getActiveChild();
            }
            if (this.forSyncRenderer != null) {
                rDCRenderer.synchronizeWith(this.forSyncRenderer);
            }
        }
        if (!this.overlaysToBeAddedToRealRenderer.isEmpty()) {
            for (Overlay overlay : this.overlaysToBeAddedToRealRenderer) {
                rDCRenderer.addOverlay(overlay);
            }
        }
        rDCRenderer.invalidate();
        rDCRenderer.initValueMappings(this.visDisplayData.getVisDisplay());
        this.renderer = rDCRenderer;
        this.loaded.countDown();
        if (this.listener != null) {
            this.listener.frameAvailable(this.frame, null);
        }
    }

    @Override
    public boolean frameAvailable(IFrameObjectData iFrameObjectData, String string) {
        if (this.frame == iFrameObjectData) {
            EventUtil.invoke(this::initRealRenderer);
        }
        return false;
    }

    @Override
    public boolean handleHotRegionDragged(String string, MouseEvent mouseEvent, int n, int n2, int n3, int n4, View view) {
        if (this.renderer != null) {
            return this.renderer.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, view);
        }
        return super.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, view);
    }

    @Override
    public boolean handleHotRegionPressed(String string, Rectangle rectangle, MouseEvent mouseEvent, View view) {
        if (this.renderer != null) {
            return this.renderer.handleHotRegionPressed(string, rectangle, mouseEvent, view);
        }
        return super.handleHotRegionPressed(string, rectangle, mouseEvent, view);
    }

    @Override
    public boolean handleHotRegionReleased(String string, MouseEvent mouseEvent, int n, int n2, View view) {
        if (this.renderer != null) {
            return this.renderer.handleHotRegionReleased(string, mouseEvent, n, n2, view);
        }
        return super.handleHotRegionReleased(string, mouseEvent, n, n2, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PresentationObject> applyPresentationState(IFramePresentationState iFramePresentationState) {
        if (this.renderer != null) {
            return this.renderer.applyPresentationState(iFramePresentationState);
        }
        WaitingForFrameRendererAdapter waitingForFrameRendererAdapter = this;
        synchronized (waitingForFrameRendererAdapter) {
            this.earlyEvents.add(new EarlyPresentationState(iFramePresentationState));
            return new ArrayList<PresentationObject>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPresentationState(IFramePresentationState iFramePresentationState) {
        if (this.renderer != null) {
            this.renderer.clearPresentationState(iFramePresentationState);
        } else {
            WaitingForFrameRendererAdapter waitingForFrameRendererAdapter = this;
            synchronized (waitingForFrameRendererAdapter) {
                Iterator iterator = this.earlyEvents.iterator();
                while (iterator.hasNext()) {
                    IEarlyEvent iEarlyEvent = (IEarlyEvent)iterator.next();
                    if (!(iEarlyEvent instanceof EarlyPresentationState)) continue;
                    EarlyPresentationState earlyPresentationState = (EarlyPresentationState)iEarlyEvent;
                    if (earlyPresentationState.presState != iFramePresentationState) continue;
                    iterator.remove();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (this.renderer != null) {
            return this.renderer.handleTEvent(tEvent, object, n, view);
        }
        WaitingForFrameRendererAdapter waitingForFrameRendererAdapter = this;
        synchronized (waitingForFrameRendererAdapter) {
            if (this.earlyEvents == null) {
                return this.renderer.handleTEvent(tEvent, object, n, view);
            }
            tEvent.source = object;
            this.earlyEvents.add(tEvent);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOverlay(Overlay overlay) {
        if (this.renderer != null) {
            this.renderer.addOverlay(overlay);
        } else {
            WaitingForFrameRendererAdapter waitingForFrameRendererAdapter = this;
            synchronized (waitingForFrameRendererAdapter) {
                this.overlaysToBeAddedToRealRenderer.add(overlay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOverlay(Overlay overlay) {
        if (this.renderer != null) {
            this.renderer.removeOverlay(overlay);
        } else {
            WaitingForFrameRendererAdapter waitingForFrameRendererAdapter = this;
            synchronized (waitingForFrameRendererAdapter) {
                this.overlaysToBeAddedToRealRenderer.remove(overlay);
            }
        }
    }

    @Override
    public List<Overlay> getOverlays() {
        if (this.renderer != null) {
            return this.renderer.getOverlays();
        }
        return this.overlaysToBeAddedToRealRenderer;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.renderer != null) {
            return this.renderer.getBackgroundColor();
        }
        return null;
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2, View view) {
        if (this.renderer != null) {
            return this.renderer.getHRSet(visHRSet, vis2, view);
        }
        return RDCRenderer.getHRSet(visHRSet, vis2);
    }

    @Override
    public ImageState getImageState() {
        if (this.renderer != null) {
            return (ImageState)this.renderer.getImageState();
        }
        return new ImageState();
    }

    @Override
    public double getScreenPixelSizeX() {
        return Double.NaN;
    }

    @Override
    public SpacingDef getCurrentSpacingDef() {
        return this.getImageState().getCurrentSpacingDef();
    }

    @Override
    public void getOptimumOutputSize(SnapOutputGeometry snapOutputGeometry) {
        if (this.renderer != null) {
            this.renderer.getOptimumOutputSize(snapOutputGeometry);
        }
    }

    @Override
    public Object getRaw(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.renderer != null) {
            return this.renderer.getRaw(n, n2, n3, n4, n5, n6, bl);
        }
        return null;
    }

    @Override
    public TransferFunction getTransferFunction() {
        if (this.renderer != null) {
            return this.renderer.getTransferFunction();
        }
        return null;
    }

    @Override
    public void paintOverlays(RGBBufferedImageHolder rGBBufferedImageHolder, Collection<Overlay> collection, boolean bl) {
        if (this.renderer != null) {
            this.renderer.paintOverlays(rGBBufferedImageHolder, collection, bl);
        } else {
            super.paintOverlays(rGBBufferedImageHolder, collection, bl);
        }
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
        if (this.renderer != null) {
            this.renderer.paint(rGBBufferedImageHolder, n, n2, n3, n4, bl);
        } else {
            rGBBufferedImageHolder.graphics.setColor(Color.black);
            rGBBufferedImageHolder.graphics.fillRect(0, 0, n, n2);
        }
    }

    @Override
    public void clearWindowingCache() {
    }

    @Override
    public PickingResult pick(double d, double d2) {
        if (this.renderer != null) {
            return this.renderer.pick(d, d2);
        }
        return null;
    }

    @Override
    public void storeOverlaysToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        if (this.renderer != null) {
            this.renderer.storeOverlaysToSnapshot(viewSnapshot, snapOutputGeometry);
        }
    }

    @Override
    public void storeToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        if (this.renderer != null) {
            this.renderer.storeToSnapshot(viewSnapshot, snapOutputGeometry);
        }
    }

    @Override
    public void synchronizeWith(Renderer renderer) {
        this.forSyncRenderer = renderer;
        if (this.renderer != null) {
            if (renderer instanceof SelectorNode) {
                this.renderer.synchronizeWith(((SelectorNode)renderer).getActiveChild());
            } else {
                this.renderer.synchronizeWith(renderer);
            }
        }
    }

    @Override
    public void updateImageState() {
        if (this.renderer != null) {
            this.renderer.updateImageState();
        }
    }

    @Override
    public IImageInformation getImageInformation() {
        return this.frame.getImageInformation();
    }

    @Override
    public void setName(String string) {
        if (this.renderer != null) {
            this.renderer.setName(string);
        } else {
            this.rendererNameForSet = string;
        }
    }

    @Override
    public ImageDef getActiveImageDef() {
        if (this.renderer != null) {
            return this.renderer.getActiveImageDef();
        }
        return null;
    }

    @Override
    public double[] getInterchangeableViewportCenter() {
        if (this.renderer != null) {
            return this.renderer.getInterchangeableViewportCenter();
        }
        return null;
    }

    @Override
    public IFramePresentationState getCurrentFramePresentationState() {
        if (this.renderer != null) {
            return this.renderer.getCurrentFramePresentationState();
        }
        return null;
    }

    @Override
    public IPresentationState getPresentationState() {
        if (this.renderer != null) {
            return this.renderer.getPresentationState();
        }
        return null;
    }

    @Override
    public IPresentationState getPresentationState(Set<View.CAPTURE_STATES> set) {
        if (this.renderer != null) {
            return this.renderer.getPresentationState(set);
        }
        return null;
    }

    @Override
    public IPresentationState getPresentationState(int n, int n2) {
        if (this.renderer != null) {
            return this.renderer.getPresentationState(n, n2);
        }
        return null;
    }

    @Override
    public PresentationLUT getPresentationLUT() {
        if (this.renderer != null) {
            return this.renderer.getPresentationLUT();
        }
        return null;
    }

    @Override
    public IFrameObjectData getFrameObjectData() {
        if (this.renderer != null) {
            return this.renderer.getFrameObjectData();
        }
        return this.frame;
    }

    @Override
    public RawDataContainer getRawDataContainer() {
        int n = 0;
        while (n < 5) {
            if (this.renderer != null) {
                return this.renderer.getRawDataContainer();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            ++n;
        }
        return null;
    }

    @Override
    public WindowHandlerBase getWindowHandler() {
        if (this.renderer != null) {
            return this.renderer.getWindowHandler();
        }
        return null;
    }

    @Override
    public DoubleDimension getDefaultDisplayedAreaSize() {
        if (this.renderer == null) {
            return null;
        }
        return this.renderer.getDefaultDisplayedAreaSize();
    }

    @Override
    public void setAreaFitHandler(AreaFitHandler areaFitHandler) {
        this.fithandler = areaFitHandler;
        if (this.renderer != null) {
            this.renderer.setAreaFitHandler(areaFitHandler);
        }
    }

    @Override
    public AreaFitHandler getAreaFitHandler() {
        if (this.renderer != null) {
            return this.renderer.getAreaFitHandler();
        }
        return this.fithandler;
    }

    @Override
    public void setBorderLockMode(boolean bl) {
        this.borderLockMode = bl;
        if (this.renderer != null) {
            this.renderer.setBorderLockMode(bl);
        }
    }

    @Override
    public boolean isBorderLockMode() {
        return this.borderLockMode;
    }

    @Override
    public boolean isImageLoaded() {
        boolean bl;
        boolean bl2 = bl = this.renderer != null;
        if (!bl && !this.frame.isStartedBeingLoaded()) {
            DataManager.getInstance().getFetcher().changeToHigherPriority(this.frame, (byte)0);
        }
        return bl;
    }

    @Override
    public void checkImageLoaded() {
        boolean bl = this.renderer != null;
        while (!bl) {
            if (!this.frame.isStartedBeingLoaded()) {
                DataManager.getInstance().getFetcher().changeToHigherPriority(this.frame, (byte)0);
            }
            if (this.frame.getRawDataContainer() == null) continue;
            try {
                bl = this.loaded.await(1L, TimeUnit.SECONDS);
                if (bl) continue;
                this.initRealRenderer();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public MousePositionDestination getMouseFollower() {
        if (this.renderer != null) {
            return this.renderer;
        }
        return null;
    }

    @Override
    public String getInfoAt(int n, int n2, int n3, int n4) {
        if (this.renderer != null) {
            return this.renderer.getInfoAt(n, n2, n3, n4);
        }
        return "";
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.renderer != null) {
            this.renderer.cleanUp();
        }
    }

    @Override
    public void initValueMappings(VisDisplay2 visDisplay2) {
        if (this.renderer != null) {
            this.renderer.initValueMappings(visDisplay2);
        }
    }

    @Override
    public boolean startRectangleZoom() {
        return this.renderer != null && this.renderer.startRectangleZoom();
    }

    @Override
    public IRDCRenderer disableFreeRotation() {
        return this;
    }

    @Override
    public void centerZoomStart() {
        this.renderer.centerZoomStart();
    }

    @Override
    public void centerZoomProgress(double d, View view) {
        this.renderer.centerZoomProgress(d, view);
    }

    @Override
    public void centerZoomEnd(double d, View view) {
        this.renderer.centerZoomEnd(d, view);
    }

    @Override
    public boolean restoreViewportCenterAfterZoom(double[] dArray) {
        return this.renderer.restoreViewportCenterAfterZoom(dArray);
    }

    private static class EarlyPresentationState
    implements IEarlyEvent {
        public final IFramePresentationState presState;

        EarlyPresentationState(IFramePresentationState iFramePresentationState) {
            this.presState = iFramePresentationState;
        }

        @Override
        public boolean isPresentationState() {
            return true;
        }
    }
}

