/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.tf.function;

import com.tiani.jvision.tf.function.ControlHandle;
import com.tiani.jvision.tf.function.ControlPoint;
import com.tiani.jvision.tf.function.TransferFunction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class LutFunction
extends TransferFunction
implements Serializable {
    private int type = -1;
    private int shift = 0;
    private SortedSet<ControlPoint> points = new TreeSet<ControlPoint>();

    public LutFunction() {
        super("", "");
    }

    public LutFunction(int[][] nArray, String string, int n, String string2) {
        super(string, string2);
        if (n == 4 || n == 2 || n == 1 || n == 8) {
            this.type = n;
            this.shift = TransferFunction.SHIFTS[n];
            this.createFunction(nArray);
            this.recalcLut();
        }
    }

    public LutFunction(int n, int n2, String string, int n3, String string2) {
        super(string, string2);
        if (n3 == 4 || n3 == 2 || n3 == 1 || n3 == 8) {
            this.type = n3;
            this.shift = TransferFunction.SHIFTS[n3];
            this.createFunction(n, n2);
            this.recalcLut();
        }
    }

    public LutFunction(String string, int n, String string2) {
        super(string, string2);
        if (n == 4 || n == 2 || n == 1 || n == 8) {
            this.type = n;
            this.shift = TransferFunction.SHIFTS[n];
            this.points.clear();
        }
    }

    @Override
    protected LutFunction cloneImpl() {
        LutFunction lutFunction = new LutFunction(this.unit, this.type, this.description);
        lutFunction.points = new TreeSet<ControlPoint>();
        for (ControlPoint controlPoint : this.points) {
            lutFunction.points.add(new ControlPoint(controlPoint.getExactPosition(), controlPoint.value, controlPoint.type));
        }
        return lutFunction;
    }

    @Override
    public int[] recalcLut() {
        int[] nArray = null;
        try {
            ControlPoint controlPoint = this.points.first();
            ControlPoint controlPoint2 = this.points.last();
            int n = Math.abs(controlPoint2.getPosition() - controlPoint.getPosition()) + 1;
            nArray = this.createLUTArray(n);
            this.offset = Math.min(controlPoint.getPosition(), controlPoint2.getPosition());
            if (this.points.size() > 1) {
                if (this.isFlipped()) {
                    int n2 = Math.min(controlPoint.getPosition(), controlPoint2.getPosition());
                    int n3 = Math.max(controlPoint.getPosition(), controlPoint2.getPosition());
                    ControlPoint[] controlPointArray = this.points.toArray(new ControlPoint[this.points.size()]);
                    ControlPoint controlPoint3 = controlPointArray[controlPointArray.length - 1];
                    int n4 = controlPointArray.length - 2;
                    while (n4 >= 0) {
                        int n5;
                        ControlPoint controlPoint4 = controlPointArray[n4];
                        int n6 = this.getFlippedPosition(controlPoint3.getPosition(), n2, n3);
                        if (n6 > (n5 = this.getFlippedPosition(controlPoint4.getPosition(), n2, n3))) break;
                        float f = n5 - n6;
                        float f2 = controlPoint4.value - controlPoint3.value;
                        int n7 = n6;
                        while (n7 <= n5) {
                            nArray[n7 - this.offset] = Math.round((float)controlPoint3.value + (float)(n7 - n6) / f * f2) << this.shift;
                            ++n7;
                        }
                        controlPoint3 = controlPoint4;
                        --n4;
                    }
                    n4 = this.getFlippedPosition(controlPoint3.getPosition(), n2, n3) - this.offset;
                    while (n4 < nArray.length) {
                        nArray[n4] = controlPoint3.value << this.shift;
                        ++n4;
                    }
                } else {
                    Iterator iterator = this.points.iterator();
                    ControlPoint controlPoint5 = (ControlPoint)iterator.next();
                    while (iterator.hasNext()) {
                        ControlPoint controlPoint6 = (ControlPoint)iterator.next();
                        if (controlPoint5.getPosition() > controlPoint6.getPosition()) break;
                        float f = controlPoint6.getPosition() - controlPoint5.getPosition();
                        float f3 = controlPoint6.value - controlPoint5.value;
                        int n8 = controlPoint5.getPosition();
                        int n9 = controlPoint6.getPosition();
                        int n10 = n8;
                        while (n10 <= n9) {
                            nArray[n10 - this.offset] = Math.round((float)controlPoint5.value + (float)(n10 - n8) / f * f3) << this.shift;
                            ++n10;
                        }
                        controlPoint5 = controlPoint6;
                    }
                    int n11 = controlPoint5.getPosition();
                    int n12 = n11 - this.offset;
                    while (n12 < nArray.length) {
                        nArray[n12] = controlPoint5.value << this.shift;
                        ++n12;
                    }
                }
            } else {
                Arrays.fill(nArray, controlPoint.value << this.shift);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (nArray == null) {
            nArray = this.createLUTArray(4096);
        }
        return nArray;
    }

    private int getFlippedPosition(int n, int n2, int n3) {
        return n3 - n + n2;
    }

    private void createFunction(int[][] nArray) {
        this.points.clear();
        int n = 0;
        while (n < nArray[0].length) {
            this.points.add(new ControlPoint(nArray[0][n], nArray[1][n] >> this.shift & 0xFF, this.type));
            ++n;
        }
    }

    private void createFunction(int n, int n2) {
        this.points.clear();
        this.points.add(new ControlPoint(n - (n2 >> 1), 0, this.type));
        this.points.add(new ControlPoint(n + (n2 >> 1), 255, this.type));
    }

    @Override
    public Collection<ControlHandle> getHandles(int n) {
        Vector<ControlHandle> vector = new Vector<ControlHandle>();
        for (ControlPoint controlPoint : this.points) {
            if ((controlPoint.type & n) == 0) continue;
            ControlHandle controlHandle = new ControlHandle(n);
            controlHandle.add(controlPoint);
            vector.add(controlHandle);
        }
        return vector;
    }

    @Override
    public void addHandle(int n, int n2, int n3) {
        this.points.add(new ControlPoint(n, n2, n3));
    }

    @Override
    public void removeHandle(int n, int n2) {
        ControlPoint controlPoint = null;
        for (ControlPoint controlPoint2 : this.points) {
            if (controlPoint2.getPosition() != n || controlPoint2.type != n2) continue;
            controlPoint = controlPoint2;
            break;
        }
        if (controlPoint != null) {
            this.points.remove(controlPoint);
        }
    }
}

