/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.tf.function;

import com.tiani.jvision.tf.function.ControlHandle;
import java.util.Collection;
import java.util.StringTokenizer;

public abstract class TransferFunction
implements Cloneable {
    public static final int NONE = -1;
    public static final int BLUE = 1;
    public static final int GREEN = 2;
    public static final int RED = 4;
    public static final int ALPHA = 8;
    public static final int COLOR = 7;
    public static final int[] SHIFTS;
    protected String unit = "";
    protected String description = "";
    private String region = "";
    private String instanceUID = "";
    private boolean isApplied = true;
    private boolean isFlipped = false;
    private boolean isInverted = false;
    protected int offset = 0;

    static {
        int[] nArray = new int[9];
        nArray[2] = 8;
        nArray[4] = 16;
        nArray[8] = 24;
        SHIFTS = nArray;
    }

    public TransferFunction() {
    }

    public TransferFunction(String string, String string2) {
        StringTokenizer stringTokenizer;
        if (string != null) {
            this.unit = string;
        }
        if ((stringTokenizer = new StringTokenizer(string2, "#")).hasMoreTokens()) {
            this.region = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.description = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.instanceUID = stringTokenizer.nextToken();
        }
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public String getUnit() {
        return this.unit;
    }

    public final TransferFunction clone() {
        TransferFunction transferFunction = this.cloneImpl();
        transferFunction.unit = this.unit;
        transferFunction.description = this.description;
        transferFunction.region = this.region;
        transferFunction.instanceUID = this.instanceUID;
        transferFunction.isApplied = this.isApplied;
        transferFunction.isFlipped = this.isFlipped;
        transferFunction.isInverted = this.isInverted;
        return transferFunction;
    }

    protected abstract TransferFunction cloneImpl();

    public String getInstanceUID() {
        return this.instanceUID;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDescription() {
        return this.description;
    }

    public void changeDescription(String string, String string2, String string3) {
        if (string != null && string.length() > 0) {
            this.region = string;
        }
        if (string2 != null && string2.length() > 0) {
            this.description = string2;
        }
        if (string3 != null && string3.length() > 0) {
            this.instanceUID = string3;
        }
    }

    public int[] getArgbLut() {
        return this.recalcLut();
    }

    protected int[] createLUTArray(int n) {
        return new int[n];
    }

    public int getOffset() {
        return this.offset;
    }

    public final int getMinPosition() {
        return this.getMinPosition(15);
    }

    public final int getMinPosition(int n) {
        Collection<ControlHandle> collection = this.getHandles(n);
        if (collection.isEmpty()) {
            return 0;
        }
        return collection.iterator().next().getPosition();
    }

    public final float getExactMinPosition() {
        Collection<ControlHandle> collection = this.getHandles(15);
        if (collection.isEmpty()) {
            return 0.0f;
        }
        return collection.iterator().next().getExactPosition();
    }

    public final int getMaxPosition(int n) {
        Object[] objectArray = this.getHandles(n).toArray();
        if (objectArray.length == 0) {
            return 0;
        }
        return ((ControlHandle)objectArray[objectArray.length - 1]).getPosition();
    }

    public final int getMaxPosition() {
        return this.getMaxPosition(15);
    }

    public final float getExactMaxPosition() {
        Object[] objectArray = this.getHandles(15).toArray();
        if (objectArray.length == 0) {
            return 0.0f;
        }
        return ((ControlHandle)objectArray[objectArray.length - 1]).getExactPosition();
    }

    public final void scale(int n, int n2) {
        Object[] objectArray = this.getHandles(15).toArray();
        if (n2 <= objectArray.length) {
            n2 = objectArray.length + 1;
        }
        float f = this.getMinPosition();
        float f2 = this.getMaxPosition();
        float f3 = (float)n2 / (f2 - f);
        float f4 = (f2 + f) / 2.0f;
        if ((double)Math.abs((float)n2 - (f2 - f)) < 1.0 && (double)Math.abs(f4 - (float)n) < 1.0) {
            return;
        }
        if (Float.isInfinite(f3)) {
            return;
        }
        float[] fArray = new float[objectArray.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            fArray[n3] = (((ControlHandle)objectArray[n3]).getExactPosition() - f4) * f3 + (float)n;
            ++n3;
        }
        n3 = 1;
        while (n3 < objectArray.length) {
            if (Math.abs(fArray[n3] - fArray[n3 - 1]) < 1.0f) {
                return;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < objectArray.length) {
            ((ControlHandle)objectArray[n3]).setPosition(fArray[n3]);
            ++n3;
        }
    }

    public void setApplied(boolean bl) {
        this.isApplied = bl;
    }

    public boolean isApplied() {
        return this.isApplied;
    }

    public boolean isFlipped() {
        return this.isFlipped;
    }

    public void setFlipped(boolean bl) {
        this.isFlipped = bl;
    }

    public void setInverted(boolean bl) {
        this.isInverted = bl;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public void setTransformation(String string, boolean bl) {
        this.setFlipped(bl);
        this.setTransformation(string);
    }

    private void setTransformation(String string) {
        int n;
        if (string != null && (n = string.indexOf(91)) != -1) {
            this.setFlipped(string.indexOf("flipped", n) != -1);
            this.setApplied(string.indexOf("applied", n) != -1);
            this.setInverted(string.indexOf("inverted", n) != -1);
        }
    }

    public void setSOPInstanceUID(String string) {
        this.instanceUID = string;
    }

    public abstract Collection<ControlHandle> getHandles(int var1);

    public abstract void addHandle(int var1, int var2, int var3);

    public abstract void removeHandle(int var1, int var2);

    public abstract int[] recalcLut();
}

