/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toolbox;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.tiani.gui.util.FocusUtil;
import com.tiani.gui.util.event.PanelDragListener;
import com.tiani.gui.util.panel.flexible.AbstractVisualizer;
import com.tiani.gui.workarounds.WindowLocationWorkaround;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorPanel;
import com.tiani.jvision.main.IToolBarTabPanel;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.toolbox.PluginToolboxDialog;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PluginToolbox {
    private static Point topLeftCorner;
    private boolean isVisible = true;
    private Integer currentDisplay;
    private final PAction hideAction = PActionRegistry.getAction("HIDE_PLUGIN_TOOLBOX");
    private final WindowLocationWorkaround dialogLocationAdapter = new WindowLocationWorkaround();
    private final JPanel contentPanel = new MultiMonitorPanel(new BorderLayout());
    private final JDialog dialog;

    public PluginToolbox(Frame frame) {
        this.contentPanel.setBorder(ComponentFactory.instance.createEmptyBorder(3));
        this.dialog = PluginToolbox.buildDialog(frame, this.contentPanel, this.dialogLocationAdapter);
        PanelDragListener.activateFor(this.contentPanel);
    }

    private static JDialog buildDialog(Frame frame, Component component, WindowListener ... windowListenerArray) {
        PluginToolboxDialog pluginToolboxDialog = new PluginToolboxDialog(frame);
        pluginToolboxDialog.setDefaultCloseOperation(0);
        WindowListener[] windowListenerArray2 = windowListenerArray;
        int n = windowListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowListener windowListener = windowListenerArray2[n2];
            pluginToolboxDialog.addWindowListener(windowListener);
            ++n2;
        }
        pluginToolboxDialog.getContentPane().add(component);
        pluginToolboxDialog.pack();
        pluginToolboxDialog.setLocationRelativeTo(frame);
        return pluginToolboxDialog;
    }

    public static Point getPosition() {
        if (topLeftCorner == null) {
            return null;
        }
        return new Point(topLeftCorner);
    }

    public Container getPluginContainer() {
        return this.contentPanel;
    }

    public void attachToDisplayOnPluginStart(VisDisplay2 visDisplay2, IPlugin iPlugin) {
        assert (visDisplay2 != null) : "Can not start the dialog toolbox on null display. Something went wrong with display selection.";
        PluginToolbox.initToolboxPositionIfNecessary(visDisplay2);
        this.isVisible = iPlugin != null && (iPlugin.showToolboxAtStart() || iPlugin.toolboxMandatory());
        this.attachToDisplay(visDisplay2);
    }

    private static void initToolboxPositionIfNecessary(VisDisplay2 visDisplay2) {
        if (topLeftCorner == null) {
            topLeftCorner = JVision2.getMainFrame().determineInitialPluginToolboxPosition(visDisplay2);
        }
    }

    public void attachToDisplayOnPluginAutoStart(VisDisplay2 visDisplay2, IPlugin iPlugin) {
        assert (visDisplay2 != null) : "Can not start the dialog toolbox on null display. Something went wrong with display selection.";
        PluginToolbox.initToolboxPositionIfNecessary(visDisplay2);
        this.isVisible = iPlugin != null && iPlugin.toolboxMandatory();
        this.attachToDisplay(visDisplay2);
    }

    public void attachToDisplayOnContextGained(VisDisplay2 visDisplay2) {
        assert (visDisplay2 != null) : "Can not attach the dialog toolbox to null display. Something went wrong with display selection.";
        this.saveDialogState();
        if (topLeftCorner != null) {
            this.attachToDisplay(visDisplay2);
        }
    }

    public void saveDialogState() {
        Point point;
        if (this.currentDisplay != null && (point = this.dialog.getLocation()) != null && point.y != 0) {
            PluginToolbox.topLeftCorner.x = point.x;
            PluginToolbox.topLeftCorner.y = point.y;
        }
        this.currentDisplay = null;
    }

    public void setToolboxVisibleOnPosition(Point point) {
        if (topLeftCorner == null) {
            return;
        }
        PluginToolbox.topLeftCorner.x = point.x;
        PluginToolbox.topLeftCorner.y = point.y;
        this.setDialogLocation(new Point(PluginToolbox.topLeftCorner.x, PluginToolbox.topLeftCorner.y), true);
        Component[] componentArray = this.getPluginContainer().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)component;
                Component[] componentArray2 = jTabbedPane.getComponents();
                int n3 = componentArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Component component2 = componentArray2[n4];
                    if (component2 instanceof IToolBarTabPanel) {
                        this.setDialogVisible(true);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void attachToDisplay(VisDisplay2 visDisplay2) {
        Integer n = this.makeKey(visDisplay2);
        Dimension dimension = AbstractVisualizer.getPreferredPanelSize(this.getPluginContainer());
        boolean bl = dimension != null;
        Point point = this.checkToolBoxPosition(topLeftCorner, visDisplay2.getData().getPlugin());
        this.setDialogLocation(new Point(point.x, point.y), bl);
        if (bl || !this.isVisible) {
            this.setDialogVisible(this.isVisible || visDisplay2.getData().getPlugin().toolboxMandatory());
        }
        this.currentDisplay = n;
    }

    private Point checkToolBoxPosition(Point point, IPlugin iPlugin) {
        if (iPlugin.getPluginName() == PluginName.VIDEOPLAYER) {
            return new Point(point.x, 0);
        }
        return point;
    }

    private Integer makeKey(VisDisplay2 visDisplay2) {
        return visDisplay2.hashCode();
    }

    public boolean isVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }

    public void setDialogVisible(boolean bl) {
        if (bl) {
            this.updateDialogSize();
        }
        FocusUtil.setVisibleButRetainWindowFocus(this.dialog, bl);
    }

    private void setDialogLocation(Point point, boolean bl) {
        this.dialog.setLocation(point);
        if (bl) {
            this.dialog.pack();
        }
        this.dialogLocationAdapter.setLocation(point);
    }

    private void updateDialogSize() {
        Dimension dimension = AbstractVisualizer.getPreferredPanelSize(this.getPluginContainer());
        if (dimension != null) {
            Insets insets = this.dialog.getInsets();
            Insets insets2 = this.dialog.getContentPane().getInsets();
            this.dialog.setSize(dimension.width + insets.left + insets2.left + insets.right + insets2.right, dimension.height + insets.top + insets2.top + insets.bottom + insets2.bottom);
        }
    }

    public void setDialogHideable(boolean bl) {
        this.hideAction.setEnabled(bl);
    }

    void hideDialog() {
        this.dialog.setVisible(false);
        this.isVisible = false;
    }

    public void showDialog() {
        if (AbstractVisualizer.getPreferredPanelSize(this.getPluginContainer()) == null) {
            return;
        }
        this.isVisible = true;
        this.setDialogVisible(true);
    }
}

