/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toolbox;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionListener;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIFactory;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.listtext.swingx.controls.ComponentResizer;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.dialog.HideableDialogFactory;
import com.tiani.gui.util.LocationUtil;
import com.tiani.jvision.toptoolbar.PluginActions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class PluginToolboxDialog
extends JDialog {
    private final JPanel buttonPanel = new JPanel(new FlowLayout(2, GUI.getScaledDiagnosticInt((int)5), 0));
    private final ComponentResizer resizer;
    private final int minWidth;
    private final int minHeight;

    PluginToolboxDialog(Frame frame) {
        super(frame, false);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
        this.buttonPanel.setOpaque(false);
        try {
            this.buttonPanel.add(ActionUIFactory.createUI(new HideToolboxAction()).getComponent());
            this.buttonPanel.add(ActionUIFactory.createUI(new PluginOffAction()).getComponent());
            this.rootPane.getLayeredPane().add((Component)this.buttonPanel, JLayeredPane.DRAG_LAYER);
        }
        catch (Exception exception) {
            ALogger.getLogger(PluginToolboxDialog.class).error("Creating plugin toolbox action buttons failed.", (Throwable)exception);
        }
        this.addComponentListener(new ButtonPanelBoundsUpdater());
        this.setUndecorated(true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(ColorUtils.getSecondary3()), SwingUtilities2.createEmptyBorder((int)0)));
        this.resizer = new ComponentResizer();
        this.resizer.setSizeBoundedByParent(true);
        Insets insets = this.resizer.getDragInsets();
        this.minWidth = insets.left + insets.right;
        this.minHeight = insets.top + insets.bottom;
        this.resizer.setMinimumSize(new Dimension(this.minWidth, this.minHeight));
        this.resizer.registerComponent(new Component[]{this});
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.updateButtonPanelBounds();
        }
        super.setVisible(bl);
    }

    @Override
    public void pack() {
        super.pack();
        Dimension dimension = this.getPreferredSize();
        if (dimension.width < this.minWidth) {
            dimension.width = this.minWidth;
        }
        if (dimension.height < this.minHeight) {
            dimension.height = this.minHeight;
        }
        this.resizer.setMinimumSize(dimension);
    }

    void updateButtonPanelBounds() {
        Dimension dimension = LocationUtil.getSize(this);
        Dimension dimension2 = LocationUtil.getSize(this.buttonPanel);
        Insets insets = this.getContentPane().getInsets();
        Point point = SwingUtilities.convertPoint(this, dimension.width - dimension2.width - insets.right, insets.top, this.rootPane.getLayeredPane());
        this.buttonPanel.setBounds(point.x, point.y, dimension2.width, dimension2.height);
    }

    private class ButtonPanelBoundsUpdater
    extends ComponentAdapter {
        private ButtonPanelBoundsUpdater() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            PluginToolboxDialog.this.updateButtonPanelBounds();
        }
    }

    private static class HideToolboxAction
    extends AnonymousPAction
    implements PActionListener {
        private final PAction delegate = PActionRegistry.getAction("HIDE_PLUGIN_TOOLBOX");

        HideToolboxAction() {
            super("minimize.svg");
            this.delegate.addListener(this);
        }

        @Override
        public boolean perform(Component component) {
            return this.delegate.perform(component);
        }

        @Override
        protected boolean isEnabledImpl() {
            return this.delegate.isEnabled();
        }

        @Override
        public String getCaption() {
            return this.delegate.getCaption();
        }

        @Override
        public String getToolTipText() {
            return this.delegate.getToolTipText();
        }

        @Override
        public void enabledStateChanged(boolean bl) {
            this.fireEnabledChanged();
        }

        @Override
        public void selectionStateChanged(boolean bl) {
            this.fireSelectionChanged();
        }

        @Override
        public void contentChanged(String string, String string2, boolean bl) {
            this.fireContentChanged(bl);
        }
    }

    private static class PluginOffAction
    extends AnonymousPAction {
        private final PAction delegate = PActionRegistry.getDataAction(PluginActions.PLUGIN_OFF, PDataScope.CurrentDisplay);

        PluginOffAction() {
            super("close.svg");
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("PluginToolboxDialog.PluginOffAction.ToolTip");
        }

        @Override
        public boolean perform(Component component) {
            if (HideableDialogFactory.showConfirmDialog(component, Messages.getString("PluginToolboxDialog.PluginOffAction.Confirmation"), Config.impaxee.jvision.DIALOGS.TerminatePluginOnToolboxClose.getKey())) {
                return this.delegate.perform(component);
            }
            return false;
        }
    }
}

