/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.config.Config;
import com.tiani.config.mappingfonts.model.enums.LevelOfDetail;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class DemographicsActionProvider
implements PActionProvider,
IConfigurationChangeListener {
    private static final String DEMOGRAPHICS_PREFIX = "DEMOGRAPHICS_";
    private List<PAction> demoActions;

    @Override
    public List<PAction> getActions() {
        this.demoActions = new ArrayList<PAction>();
        LevelOfDetail[] levelOfDetailArray = LevelOfDetail.values();
        int n = levelOfDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            LevelOfDetail levelOfDetail = levelOfDetailArray[n2];
            this.demoActions.add(new DemographicsAction(levelOfDetail));
            ++n2;
        }
        ConfigurationProviderFactory.getConfig().registerConfigurationChangeListener(Config.impaxee.jvision.MAPPING.LevelOfDetail.getKey(), (IConfigurationChangeListener)this);
        return this.demoActions;
    }

    private String getIconForLevel(LevelOfDetail levelOfDetail) {
        if (levelOfDetail == LevelOfDetail.ALL) {
            return "demographicsModeAll.svg";
        }
        if (levelOfDetail == LevelOfDetail.LIMITED) {
            return "demographicsModeLimited.svg";
        }
        return "demographicsModeNone.svg";
    }

    public static String getActionIDForLevel(LevelOfDetail levelOfDetail) {
        return DEMOGRAPHICS_PREFIX + levelOfDetail.name();
    }

    private void notifySelectionChanged() {
        for (PAction pAction : this.demoActions) {
            pAction.fireSelectionChanged();
        }
    }

    public void configurationChanged(String string) {
        this.notifySelectionChanged();
    }

    private class DemographicsAction
    extends SelectablePAction {
        private LevelOfDetail level;

        public DemographicsAction(LevelOfDetail levelOfDetail) {
            super(DemographicsActionProvider.this.getIconForLevel(levelOfDetail));
            this.level = levelOfDetail;
        }

        @Override
        public String getCaption() {
            return String.valueOf(Messages.getString("Action.Demographics.CaptionPrefix")) + " - " + this.level.getDescription();
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return DemographicsActionProvider.getActionIDForLevel(this.level);
        }

        @Override
        public String getToolTipText() {
            return this.getCaption();
        }

        @Override
        public boolean isSelected() {
            return View.getLevelOfDetailForDemographics() == this.level;
        }

        @Override
        public boolean perform(Component component) {
            if (this.isSelected()) {
                this.forcedSelectionChanged();
                return false;
            }
            this.notifyActionPerformed();
            this.setLevelOfDetail(this.level);
            DemographicsActionProvider.this.notifySelectionChanged();
            return true;
        }

        private void setLevelOfDetail(LevelOfDetail levelOfDetail) {
            if (levelOfDetail != null) {
                View.setLevelOfDetailForDemographics(levelOfDetail);
                Config.impaxee.jvision.MAPPING.LevelOfDetail.set(levelOfDetail.name());
                List<VisData> list = JVision2.getMainFrame().getAllVisDatas();
                for (VisData object2 : list) {
                    object2.getView().updateMapping(true);
                }
                TEvent tEvent = new TEvent(81);
                TEventDispatch.sendEvent(tEvent, null, 20);
            }
        }
    }
}

