/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.sync.SynchronizationManager;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.toptoolbar.DisplayLayoutDataActionProvider;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.layout.LytDisplay;
import java.awt.Component;
import java.util.List;

public class DisplayLayoutChooserDataAction
extends AbstractPDataAction {
    private static final ALogger log = ALogger.getLogger(DisplayLayoutChooserDataAction.class);
    public static final String ID = "DISPLAY_LAYOUT_CHOOSER";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new DisplayLayoutChooserAction(pDataScope, pDataProvider);
    }

    @Override
    public boolean canHandleDataProvider(PDataProvider.ProviderType providerType) {
        return providerType == PDataProvider.ProviderType.Display;
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay};
    }

    public class DisplayLayoutChooserAction
    extends AbstractPDataAction.AbstractInnerPAction {
        public DisplayLayoutChooserAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super("display-layout.svg", pDataScope, pDataProvider);
        }

        @Override
        public String getGroupName() {
            return LAYOUT_GROUP;
        }

        @Override
        public String getCaption() {
            VisDisplay2 visDisplay2 = this.getDisplay();
            if (visDisplay2 != null) {
                LytDisplay lytDisplay = visDisplay2.getLyt();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("  ").append(lytDisplay.getCols()).append("x").append(lytDisplay.getRows());
                return stringBuilder.toString();
            }
            return "";
        }

        @Override
        public String getName() {
            return Messages.getString("DisplayLayoutChooserAction.Caption");
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("DisplayLayoutChooserAction.Tooltip");
        }

        @Override
        public PAction[] getSubactions() {
            return new PAction[]{this};
        }

        @Override
        protected boolean isEnabledImpl() {
            return JVision2.getMainFrame().getLytMode() == MainLayoutType.variable;
        }

        @Override
        public boolean perform(Component component) {
            return true;
        }

        public boolean perform(int n, int n2) {
            this.notifyActionPerformed();
            VisDisplay2 visDisplay2 = this.getDisplay();
            if (visDisplay2 == null) {
                return false;
            }
            if (visDisplay2.isSynchronized()) {
                for (VisDisplay2 object2 : SynchronizationManager.getInstance().getSynchronizedDisplays()) {
                    object2.setLytMode(object2.getLyt(), n, n2, true, false);
                    object2.getLyt().clearSavedStateLyt();
                    object2.repaint();
                }
            } else {
                visDisplay2.setLytMode(visDisplay2.getLyt(), n, n2, true, false);
                visDisplay2.repaint();
            }
            DisplayLayoutDataActionProvider.DISPLAY_LAYOUT dISPLAY_LAYOUT = DisplayLayoutDataActionProvider.getLayoutFromLyt(n, n2);
            if (dISPLAY_LAYOUT != null) {
                try {
                    PAction pAction = PActionRegistry.getAction(dISPLAY_LAYOUT.getActionID(), visDisplay2);
                    if (pAction != null) {
                        pAction.forcedSelectionChanged();
                    }
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                }
            }
            this.fireContentChanged(false);
            return true;
        }

        public void updateComponent() {
            this.fireContentChanged(false);
        }

        private VisDisplay2 getDisplay() {
            List<VisDisplay2> list = this.scope != null ? DisplayLayoutChooserDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
            if (!list.isEmpty()) {
                return list.get(0);
            }
            return null;
        }
    }
}

