/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataAction;
import com.agfa.pacs.impaxee.actions.PDataActionProvider;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.PSelectableAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.renderer.filter.ImageFilterOperator;
import com.tiani.jvision.renderer.filter.ImageFilterOperatorFactory;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class FilterActions
implements PDataActionProvider {
    public static final String FILTER_ID = "FILTER_";

    public static String getFilterActionID(FilterType filterType) {
        if (filterType == null) {
            throw new IllegalArgumentException();
        }
        return FILTER_ID + filterType.name();
    }

    public static void updateSelectionState(VisDisplay2 visDisplay2, FilterType filterType) {
        FilterType[] filterTypeArray = FilterType.values();
        int n = filterTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FilterType filterType2 = filterTypeArray[n2];
            String string = FilterActions.getFilterActionID(filterType2);
            if (visDisplay2.hasAction(string)) {
                PSelectableAction pSelectableAction = (PSelectableAction)((Object)visDisplay2.getAction(string));
                pSelectableAction.setSelected(filterType2 == filterType);
            }
            ++n2;
        }
    }

    @Override
    public List<PDataAction> getDataActions() {
        ArrayList<PDataAction> arrayList = new ArrayList<PDataAction>();
        FilterType[] filterTypeArray = FilterType.values();
        int n = filterTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FilterType filterType = filterTypeArray[n2];
            arrayList.add(new FilterDataAction(filterType));
            ++n2;
        }
        return arrayList;
    }

    public static final class FilterApplicability {
        private static final FilterApplicability ALLOWED = new FilterApplicability(true, "ALLOWED");
        private boolean isAllowed;
        private String description;

        private FilterApplicability(boolean bl, String string) {
            this.isAllowed = bl;
            this.description = string;
        }

        public static final FilterApplicability allow() {
            return ALLOWED;
        }

        public static final FilterApplicability deny(String string) {
            return new FilterApplicability(false, string);
        }

        public static final FilterApplicability denyForPlugin(IPlugin iPlugin) {
            return FilterApplicability.deny(MessageFormat.format(Messages.getString("FilterApplicability.DeniedForPlugin"), iPlugin.getDescription()));
        }

        public boolean isAllowed() {
            return this.isAllowed;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class FilterDataAction
    extends AbstractPDataAction {
        private FilterType type;

        public FilterDataAction(FilterType filterType) {
            super(true);
            if (filterType == null) {
                throw new IllegalArgumentException("Missing type");
            }
            this.type = filterType;
            this.init();
        }

        @Override
        protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            if (pDataScope == null && pDataProvider == null) {
                throw new ActionNotFoundException(this.getID());
            }
            return new FilterAction(this.type, pDataScope, pDataProvider);
        }

        protected String getIcon() {
            if (this.type == FilterType.None) {
                return "/icons/hotdisplayfilternone.gif";
            }
            ImageFilterOperator imageFilterOperator = (ImageFilterOperator)ImageFilterOperatorFactory.getInstance().getComponent(this.type.name());
            return imageFilterOperator.getIconPath();
        }

        @Override
        public PDataScope[] getAvailableScopes() {
            return new PDataScope[]{PDataScope.CurrentDisplay};
        }

        @Override
        public String getID() {
            return FilterActions.FILTER_ID + this.type.name();
        }

        private class FilterAction
        extends AbstractPDataAction.SelectableInnerPAction
        implements PSelectableAction {
            private boolean isSelected;

            public FilterAction(FilterType filterType, PDataScope pDataScope, PDataProvider pDataProvider) {
                super(FilterDataAction.this.getIcon(), pDataScope, pDataProvider);
                if (pDataProvider != null && filterType == FilterType.None) {
                    this.isSelected = true;
                }
            }

            @Override
            public String getCaption() {
                return this.getToolTipText();
            }

            @Override
            public String getGroupName() {
                return FILTER_GROUP;
            }

            @Override
            public String getToolTipText() {
                return Messages.getString("CustomActions1.displayFilters.filter" + FilterDataAction.this.type.name() + ".ToolTip");
            }

            @Override
            public void setSelected(boolean bl) {
                if (this.provider != null) {
                    this.isSelected = bl;
                    this.fireSelectionChanged();
                }
            }

            @Override
            protected boolean isSelectedImpl() {
                return this.isSelected;
            }

            @Override
            public boolean perform(Component component) {
                if (this.isSelected()) {
                    return false;
                }
                List<VisDisplay2> list = null;
                list = this.scope != null ? FilterDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
                if (list.isEmpty()) {
                    return false;
                }
                return this.performFilter(list.get(0));
            }

            private boolean performFilter(VisDisplay2 visDisplay2) {
                FilterActions.updateSelectionState(visDisplay2, FilterDataAction.this.type);
                this.setSelected(true);
                if (!visDisplay2.hasData()) {
                    return false;
                }
                this.notifyActionPerformed();
                for (VisData object2 : visDisplay2.getVis()) {
                    FilterApplicability filterApplicability;
                    if (!object2.isSelected() || (filterApplicability = object2.getView().getFilterApplicability()).isAllowed()) continue;
                    this.informUser(filterApplicability);
                    return false;
                }
                TEvent tEvent = new TEvent();
                tEvent.id = 12;
                int n = 32;
                if (FilterDataAction.this.type == FilterType.None) {
                    n = 16;
                }
                TEventDispatch.sendEventToVis(visDisplay2, tEvent, (Object)FilterDataAction.this.type, n);
                return true;
            }

            private void informUser(FilterApplicability filterApplicability) {
                if (FilterDataAction.this.type != FilterType.None) {
                    SwingUtilities.invokeLater(() -> Message.info(Messages.getString("INFO"), filterApplicability));
                }
            }
        }
    }

    public static enum FilterType {
        None,
        AngioSharpenLow,
        AngioSharpen,
        AngioSharpenHigh,
        Edge,
        Shadow,
        Sharpen,
        Smooth;


        public static FilterType parse(String string) {
            try {
                if (string != null) {
                    return FilterType.valueOf(string);
                }
            }
            catch (Exception exception) {}
            return None;
        }

        public String toString() {
            return Messages.getString("FilterType." + this.name());
        }
    }
}

