/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.LytMainVariable;
import com.tiani.jvision.vis.layout.StateLytScreen;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FullDisplayLayoutAction
extends SelectablePAction
implements IDataSelectionListener {
    public static final String ID = "FULL_DISPLAY_LAYOUT_ON_ALL_MONITORS";
    private boolean isSelected = false;
    private Map<VisScreen2, StateLytScreen> layoutMap;

    public FullDisplayLayoutAction() {
        super("DisplayLayout1x1_AllMonitors.svg");
    }

    @Override
    public String getCaption() {
        return Messages.getString("FullDisplayLayoutAction.Caption");
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return null;
    }

    @Override
    public String getGroupName() {
        return IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return Messages.getString("FullDisplayLayoutAction.ToolTip");
    }

    @Override
    public boolean perform(Component component) {
        this.notifyActionPerformed();
        this.isSelected = !this.isSelected;
        DataSelectionManager.getInstance().addListener(this);
        if (JVision2.getMainFrame().getLyt() instanceof LytMainVariable) {
            MainFrame2 mainFrame2 = JVision2.getMainFrame();
            VisDisplay2 visDisplay2 = mainFrame2.getLastModifiedDisplay();
            if (this.isSelected) {
                int[] nArray = mainFrame2.getDisplayIndexOfScreen(visDisplay2);
                if (nArray != null) {
                    int n = nArray[1];
                    List<VisScreen2> list = mainFrame2.getScreens();
                    if (this.layoutMap == null) {
                        this.layoutMap = new HashMap<VisScreen2, StateLytScreen>(list.size());
                    }
                    for (VisScreen2 visScreen2 : list) {
                        VisData visData;
                        List<VisDisplay2> list2 = visScreen2.getDisplays();
                        VisDisplay2 visDisplay22 = null;
                        visDisplay22 = list2.size() > n ? list2.get(n) : list2.get(0);
                        if (visDisplay22 != null && (visData = visDisplay22.getVis(visDisplay22.getNavigPos())) != null) {
                            visData.makeTheLastModified();
                        }
                        this.layoutMap.put(visScreen2, new StateLytScreen(visScreen2.getLyt()));
                        visScreen2.setLytMode(visScreen2.getLytMode(), 1, 1, true);
                    }
                    this.selectLastModified(list, visDisplay2);
                }
            } else if (this.layoutMap != null) {
                for (Map.Entry<VisScreen2, StateLytScreen> entry : this.layoutMap.entrySet()) {
                    VisScreen2 visScreen2 = entry.getKey();
                    StateLytScreen stateLytScreen = entry.getValue();
                    visScreen2.setLytMode(visScreen2.getLytMode(), stateLytScreen, true);
                }
                this.layoutMap.clear();
            }
            this.fireContentChanged(true);
        }
        return true;
    }

    private void selectLastModified(List<VisScreen2> list, VisDisplay2 visDisplay2) {
        int n = 0;
        while (n < list.size()) {
            List<VisDisplay2> list2 = list.get(n).getDisplays();
            for (VisDisplay2 visDisplay22 : list2) {
                VisData visData;
                if (visDisplay22 != visDisplay2 || (visData = visDisplay22.getVis(visDisplay22.getNavigPos())) == null) continue;
                visData.makeTheLastModified();
                return;
            }
            ++n;
        }
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
        this.isSelected = false;
        this.fireContentChanged(true);
        DataSelectionManager.getInstance().removeListener(this);
    }

    @Override
    public void newHangingCaseSelected(IPatientRepresentation iPatientRepresentation, IHanging iHanging, IHanging iHanging2, boolean bl) {
    }

    @Override
    public void newActiveStudySelected(IStudyData iStudyData) {
    }

    @Override
    public void patientClicked(IPatientData iPatientData, int n) {
    }

    @Override
    public void notifyPriorStudyLoadingInProgress(boolean bl) {
    }

    @Override
    public void priorsChanged() {
    }
}

