/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.swing.util.EventConst;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.ISelectionListener;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.menu.MarkSeriesAsClinicalTrialAction;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MarkSeriesOfPatientAction
extends AbstractPAction
implements ISelectionListener {
    private static final ALogger log = ALogger.getLogger(MarkSeriesOfPatientAction.class);
    public static final String ID = "MARK_SERIES_OF_PATIENT";

    public MarkSeriesOfPatientAction() {
        super("mark_series_patient.svg");
        DataSelectionManager.getInstance().addSelectionListener(this);
    }

    @Override
    public String getCaption() {
        return Messages.getString("ImgView2.MarkSeriesOfPatient");
    }

    @Override
    public String getGroupName() {
        return GENERAL_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return Messages.getString("ImgView2.MarkSeriesOfPatient.ToolTip");
    }

    @Override
    public void lastModifiedChanged(int n, VisDisplayData visDisplayData) {
        if (visDisplayData == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(MarkSeriesAsClinicalTrialAction.isSupportedBySourceNode(visDisplayData.getDisplaySet().getOneObject()));
        }
    }

    @Override
    public boolean perform(Component component) {
        IStudyData iStudyData = this.getStudy();
        if (iStudyData != null) {
            IEvent iEvent = EventEngineFactory.getInstance().createEvent(EventConst.SHOW_CLINICAL_TRIALS_MODIFICATION_DIALOG_EVENT_ID, null, null, (Serializable)new Object[]{this.encodeSeries(iStudyData), iStudyData.getQueryObject().getSource().getIdentifier().getName(), JVision2.getMainFrame(), ComponentFactory.instance}, null);
            EventEngineFactory.getInstance().sendEvent(iEvent);
            this.notifyActionPerformed();
            return true;
        }
        log.warn("Performing action discarded: No active study!");
        return false;
    }

    @Override
    public boolean isAvailable() {
        return LicenseManager.getInstance().isLicenseIDSupported("CLINICAL_TRIALS") && !Product.isReducedVersion();
    }

    private IStudyData getStudy() {
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData != null) {
            return visData.getStudyData();
        }
        return null;
    }

    private String[] encodeSeries(IStudyData iStudyData) {
        ArrayList<String> arrayList = new ArrayList<String>();
        IPatientData iPatientData = iStudyData.getParent();
        Collection<IStudyData> collection = iPatientData.getStudies();
        if (collection != null && !collection.isEmpty()) {
            for (IStudyData iStudyData2 : collection) {
                List<ISeriesData> list = iStudyData2.getSeries();
                if (list == null || list.isEmpty()) continue;
                for (ISeriesData iSeriesData : list) {
                    arrayList.add(iSeriesData.getKey());
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

