/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.integration.ObjectID;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PActionIcon;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.PActionIconFactory;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.data.manager.DisplaySetListenerAdapter;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.utils.ConcurrentMultiValueHashMap;
import com.agfa.pacs.impaxee.utils.IConcurrentMultiValueMap;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class OpenTextAreaAction
extends AbstractPAction {
    public static final String ID = "SHOW_TEXT_AREA";
    private static final String REPORTTYPE_TEXT = "TEXT";
    private static final PActionIcon DEFAULT_ICON = PActionIconFactory.getInstance().loadIcon(OpenTextAreaAction.class, "report.svg", null);
    private static final PActionIcon ADDITIONAL_STUDIES_ICON = PActionIconFactory.getInstance().loadIcon(OpenTextAreaAction.class, "reportAndImages.svg", null);
    private static final IEventEngine EVENT_ENGINE = EventEngineFactory.getInstance();
    private final int EVENT_ID_ADDITIONAL_STUDIES_FOUND = EVENT_ENGINE.getEventID("RADIOLOGY_LIST_STUDIES_ADDED");
    private final IConcurrentMultiValueMap<String, String> availableStudies;
    private volatile String currentPatientKey;
    private volatile boolean hasAdditionalStudies;

    public OpenTextAreaAction() {
        super("report.svg");
        DataSelectionManager.getInstance().addListener(new PatientChangeListener());
        DataManager.getInstance().addDisplaySetListener(new LoadedStudiesListener());
        DataManager.getInstance().addListener(new PatientRemovalListener());
        IEventListenerProvider iEventListenerProvider = EVENT_ENGINE.createListenerProvider((IEventListener)new AvailableStudiesListener());
        EVENT_ENGINE.register(iEventListenerProvider, "textarea");
        this.availableStudies = new ConcurrentMultiValueHashMap<String, String>();
    }

    @Override
    public String getCaption() {
        return this.getToolTipText();
    }

    @Override
    public String getGroupName() {
        return GENERAL_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("GeneralActions.dictate.report.ToolTip"));
        if (this.hasAdditionalStudies) {
            stringBuilder.append('/');
            stringBuilder.append(Messages.getString("OpenTextAreaAction.AdditionalStudies.ToolTip"));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean perform(Component component) {
        this.notifyActionPerformed();
        if (ModifierKeys.isAlt() && ImpaxEEUtils.isActorSupportingReportsActive()) {
            VisData visData = VisData.getLastModified();
            IImageInformation iImageInformation = null;
            if (visData != null) {
                iImageInformation = visData.getImageInformation();
                OpenTextAreaAction.sendStartReportEvent(REPORTTYPE_TEXT, iImageInformation);
            }
        } else {
            ImpaxEEUtils.showTextArea();
        }
        return true;
    }

    static void sendStartReportEvent(String string, IImageInformation iImageInformation) {
        IEventEngine iEventEngine = EventEngineFactory.getInstance();
        ObjectID objectID = null;
        if (iImageInformation != null) {
            objectID = ObjectID.forStudyUIDPatient((String)iImageInformation.getPatientID(), (String)iImageInformation.getIssuerOfPatientID(), (String)iImageInformation.getStudyInstanceUID());
            objectID.setAccessionNr(iImageInformation.getDataset().getString(524368));
        }
        int n = iEventEngine.getEventID("riscomm.START_DICTATION");
        IEvent iEvent = iEventEngine.createInternalEvent(n);
        iEvent.setPayload((Object)new ImmutablePair((Object)string, (Object)objectID));
        iEvent.setDestination(null, "lta");
        iEventEngine.sendEvent(iEvent);
    }

    @Override
    public boolean isAvailable() {
        return !Product.isCDViewer();
    }

    @Override
    protected boolean isEnabledImpl() {
        return !DataSelectionManager.getInstance().isMultiPatientCompareActive();
    }

    void setCurrentPatient(String string) {
        if (!CompareUtils.equals((Object)string, (Object)this.currentPatientKey)) {
            this.currentPatientKey = string;
            this.updateState();
        }
    }

    void updateCurrentPatient(String string) {
        if (CompareUtils.equals((Object)string, (Object)this.currentPatientKey)) {
            this.updateState();
        }
    }

    void addAvailableStudies(List<IStudyInfo> list) {
        boolean bl = false;
        for (IStudyInfo iStudyInfo : list) {
            String string = iStudyInfo.getPatient().getKey();
            this.availableStudies.getOrCreate(string).add(iStudyInfo.getStudyUID());
            bl |= CompareUtils.equals((Object)string, (Object)this.currentPatientKey);
        }
        if (bl) {
            this.updateState();
        }
    }

    void clearAvailableStudies(String string) {
        this.availableStudies.remove(string);
    }

    private void updateState() {
        boolean bl;
        int n;
        IPatientRepresentation iPatientRepresentation = this.currentPatientKey == null ? null : DataManager.getInstance().getPatientRepresentation(this.currentPatientKey);
        if (iPatientRepresentation == null) {
            n = 0;
        } else {
            HashSet<String> hashSet = new HashSet<String>(this.availableStudies.getOrCreate(this.currentPatientKey));
            for (IStudyData iStudyData : iPatientRepresentation.getPatientData().getStudies()) {
                hashSet.remove(iStudyData.getStudyInstanceUID());
            }
            n = hashSet.size();
        }
        boolean bl2 = bl = n > 0;
        if (bl != this.hasAdditionalStudies) {
            this.hasAdditionalStudies = bl;
            if (this.hasAdditionalStudies) {
                this.changeIcon(ADDITIONAL_STUDIES_ICON);
            } else {
                this.changeIcon(DEFAULT_ICON);
            }
        }
    }

    private class AvailableStudiesListener
    implements IEventListener {
        private AvailableStudiesListener() {
        }

        public boolean handleEvent(final IEvent iEvent) {
            if (iEvent.getEventID() == OpenTextAreaAction.this.EVENT_ID_ADDITIONAL_STUDIES_FOUND && iEvent.getPayload() instanceof List) {
                EventUtil.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        List list = (List)iEvent.getPayload();
                        OpenTextAreaAction.this.addAvailableStudies(list);
                    }
                });
            }
            return false;
        }

        public IListenerSynchronization getSync() {
            return null;
        }
    }

    private class LoadedStudiesListener
    extends DisplaySetListenerAdapter {
        private LoadedStudiesListener() {
        }

        @Override
        public void studyAdded(IStudyData iStudyData) {
            this.updateLoadedStudies(iStudyData);
        }

        @Override
        public void studyRemoved(IStudyData iStudyData, boolean bl) {
            this.updateLoadedStudies(iStudyData);
        }

        private void updateLoadedStudies(final IStudyData iStudyData) {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    OpenTextAreaAction.this.updateCurrentPatient(iStudyData.getParent().getKey());
                }
            });
        }
    }

    private class PatientChangeListener
    extends DataSelectionListenerAdapter {
        private PatientChangeListener() {
        }

        @Override
        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, final IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    OpenTextAreaAction.this.setCurrentPatient(iPatientRepresentation2 == null ? null : iPatientRepresentation2.getPatientKey());
                }
            });
        }
    }

    private class PatientRemovalListener
    extends DataManagerListenerAdapter {
        private PatientRemovalListener() {
        }

        @Override
        public void patientRemoved(final IPatientRepresentation iPatientRepresentation, boolean bl) {
            if (iPatientRepresentation != null) {
                EventUtil.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        OpenTextAreaAction.this.clearAvailableStudies(iPatientRepresentation.getPatientKey());
                    }
                });
            }
        }
    }
}

