/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.hap.pacs.data.valuemapping.PatientSex;
import com.agfa.pacs.base.util.AgeUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionIcon;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.PActionIconFactory;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.jvision.toptoolbar.PatientNavigation;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.Date;
import java.util.Objects;
import javax.swing.Icon;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;

public class PatientInfoAction
extends AbstractPAction
implements IConfigurationChangeListener {
    public static final String ID = "PATIENT_INFO";
    public static final String TEXT_ID = "TEXT_INFO";
    public static final String SEX_ID = "SEX_INFO";
    private static final String LABEL_SPACE = "";
    private static final ALogger log = ALogger.getLogger(PatientInfoAction.class);
    private LabelAction[] subActions = new LabelAction[]{new PatientSexAction(), new PatientTextAction()};
    private boolean updateEnabled = true;
    private PatientMergeUtilities.PatientMergeStatus mergeStatus;
    private static final PActionIcon MALE_ICON = PActionIconFactory.getInstance().loadUnchangingIcon(null, "gender_male.svg");
    private static final PActionIcon FEMALE_ICON = PActionIconFactory.getInstance().loadUnchangingIcon(null, "gender_female.svg");

    public PatientInfoAction() {
        PatientNavigation.getInstance().addNavigationListener(new PatientNavigation.IPatientNavigationListener(){

            @Override
            public void onChange(PatientNavigation patientNavigation) {
                if (PatientInfoAction.this.updateEnabled && !Objects.equals(PatientInfoAction.this.subActions[1].getPatientName(), PatientInfoAction.LABEL_SPACE)) {
                    PatientInfoAction.this.updateToolTip();
                }
            }
        }, false);
        Config.impaxee.jvision.MAPPING.UseAnonymousMode.registerChangeListener(this);
    }

    public boolean isUpdateEnabled() {
        return this.updateEnabled;
    }

    public void setUpdateEnabled(boolean bl) {
        this.updateEnabled = bl;
    }

    public PActionIcon getIcon(PatientSex patientSex) {
        switch (patientSex) {
            case Male: {
                return MALE_ICON;
            }
            case Female: {
                return FEMALE_ICON;
            }
        }
        return null;
    }

    public String getPatientName() {
        return this.subActions[1].getPatientName();
    }

    public String getPatientBirthdate() {
        return this.subActions[1].getPatientBirthdate();
    }

    public Icon getGenderIcon(boolean bl) {
        return this.subActions[0].getIcon(bl);
    }

    public void setCurrentData(IDisplaySet iDisplaySet) {
        if (this.updateEnabled && !Config.impaxee.jvision.MAPPING.UseAnonymousMode.get()) {
            if (iDisplaySet == null || iDisplaySet.isEmpty()) {
                this.setData(null);
            } else {
                this.setData(iDisplaySet.getOneObject().getParent());
            }
        }
    }

    private void clear() {
        this.subActions[1].updateAll(LABEL_SPACE, LABEL_SPACE, null);
        this.subActions[0].changeIcon2(null);
        this.mergeStatus = null;
    }

    private synchronized void setData(ISeriesData iSeriesData) {
        PAction pAction = PActionRegistry.getAction("SET_ASIDE_STORE");
        if (pAction != null) {
            pAction.setEnabled(true);
        }
        if (iSeriesData != null) {
            String string;
            StringBuilder stringBuilder = new StringBuilder(32);
            String string2 = LABEL_SPACE;
            IPatientData iPatientData = iSeriesData.getParent().getParent();
            Attributes attributes = iPatientData.getDicomObject();
            Attributes attributes2 = iSeriesData.getParent().getDicomObject();
            string2 = attributes.getString(0x100010);
            if (string2 != null) {
                string2 = PersonNameUtilities.personNameToHRReverse((PersonName)new PersonName(string2, true));
            }
            Date date = null;
            try {
                date = Dcm4cheUtils.getDate((int)0x100030, (Attributes)attributes);
                if (date != null) {
                    stringBuilder.append(DateTimeUtils.date2String((Date)date));
                    stringBuilder.append(" (").append(AgeUtil.getCurrentAgeLocalized((Date)date)).append(')');
                } else if (attributes2.containsValue(0x101010)) {
                    string = attributes2.getString(0x101010);
                    stringBuilder.append(AgeUtil.formatPatientAge((String)string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Could not parse Birthday", (Throwable)numberFormatException);
            }
            this.mergeStatus = PatientMergeUtilities.getPatientMergeStatus((Attributes)iPatientData.getQueryObject().getAttributes());
            if (this.mergeStatus != PatientMergeUtilities.PatientMergeStatus.NotMerged) {
                string2 = String.valueOf(string2) + " (!)";
                if (pAction != null) {
                    pAction.setEnabled(false);
                }
            }
            this.subActions[1].updateAll(string2, stringBuilder.toString(), this.compileTooltipText(string2, stringBuilder.toString(), -1, -1, this.mergeStatus));
            string = attributes.getString(0x100040);
            this.subActions[0].changeIcon2(this.getIcon(PatientSex.getByCode((String)string)));
            this.updateToolTip();
        } else {
            this.clear();
        }
    }

    private void updateToolTip() {
        PatientNavigation.PatientPositionInfo patientPositionInfo = PatientNavigation.getInstance().getCurrentPatientPosition();
        this.subActions[1].updateToolTipText(this.compileTooltipText(this.subActions[1].getPatientName(), this.subActions[1].getPatientBirthdate(), patientPositionInfo != null ? patientPositionInfo.getCurrentPatientPosition() : -1, patientPositionInfo != null ? patientPositionInfo.getTotalPatientCount() : 0, this.mergeStatus));
    }

    @Override
    public PAction.ActionType getActionType() {
        return PAction.ActionType.FlatGroup;
    }

    @Override
    public PAction[] getSubactions() {
        return this.subActions;
    }

    @Override
    public String getCaption() {
        return Messages.getString("PatientInfoAction.Caption");
    }

    @Override
    public String getGroupName() {
        return "INTERNAL";
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return this.subActions[1].getToolTipText();
    }

    @Override
    public boolean perform(Component component) {
        throw new UnsupportedOperationException();
    }

    private String compileTooltipText(String string, String string2, int n, int n2, PatientMergeUtilities.PatientMergeStatus patientMergeStatus) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("<html>");
        stringBuilder.append("<b><font size=\"+");
        stringBuilder.append(ComponentFactory.instance.scaleInt(1));
        stringBuilder.append("\">");
        if (string != null) {
            stringBuilder.append(string);
            if (n > 0 && n2 > 0) {
                stringBuilder.append(' ');
                stringBuilder.append('(');
                stringBuilder.append(n);
                stringBuilder.append(' ');
                stringBuilder.append(Messages.getString("PatInfo.Of.Text"));
                stringBuilder.append(' ');
                stringBuilder.append(n2);
                stringBuilder.append(')');
            }
        } else {
            stringBuilder.append("<font color=\"#ff0000\">");
            stringBuilder.append(Messages.getString("PatInfoCommanderLabel.NoPatientName"));
            stringBuilder.append("</font>");
        }
        stringBuilder.append("</font></b>");
        stringBuilder.append("<br>");
        if (string2 != null) {
            stringBuilder.append(string2);
        } else {
            stringBuilder.append("<font color=\"#ff0000\">");
            stringBuilder.append(Messages.getString("PatInfoCommanderLabel.NoBirthDate"));
            stringBuilder.append("</font>");
        }
        stringBuilder.append("<br>");
        if (patientMergeStatus == PatientMergeUtilities.PatientMergeStatus.MergedDifferentName) {
            stringBuilder.append("<b>").append(Messages.getString("PatInfoCommanderLabel.PatientIsMergedDifferentNames")).append("</b>");
            stringBuilder.append("<br>");
        } else if (patientMergeStatus == PatientMergeUtilities.PatientMergeStatus.MergedSameName) {
            stringBuilder.append("<b>").append(Messages.getString("PatInfoCommanderLabel.PatientIsMergedSameNames")).append("</b>");
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public void configurationChanged(String string) {
        if (Config.impaxee.jvision.MAPPING.UseAnonymousMode.get()) {
            this.clear();
        } else {
            this.setCurrentData(VisData.getLastModified().getParent().getDisplaySet());
        }
    }

    private abstract class LabelAction
    extends AbstractPAction {
        private String patientName = "";
        private String patientBirthdate = "";
        private String tooltip;

        private LabelAction() {
        }

        @Override
        public String getCaption() {
            return String.valueOf(this.patientName) + " " + this.patientBirthdate;
        }

        @Override
        public String getGroupName() {
            return "INTERNAL";
        }

        public void updateAll(String string, String string2, String string3) {
            this.patientName = string;
            this.patientBirthdate = string2;
            this.tooltip = string3;
            this.fireContentChanged(false);
        }

        public void updateToolTipText(String string) {
            this.tooltip = string;
            this.fireContentChanged(false);
        }

        public void changeIcon2(PActionIcon pActionIcon) {
            this.changeIcon(pActionIcon);
        }

        @Override
        public PAction.ActionType getActionType() {
            return PAction.ActionType.TextLabel;
        }

        @Override
        public String getToolTipText() {
            return this.tooltip;
        }

        public String getPatientName() {
            return this.patientName;
        }

        public String getPatientBirthdate() {
            return this.patientBirthdate;
        }

        @Override
        public boolean perform(Component component) {
            throw new UnsupportedOperationException();
        }
    }

    private class PatientSexAction
    extends LabelAction {
        private PatientSexAction() {
        }

        @Override
        public String getID() {
            return PatientInfoAction.SEX_ID;
        }

        @Override
        public String getCaption() {
            return PatientInfoAction.LABEL_SPACE;
        }

        @Override
        public PAction.ActionType getActionType() {
            return PAction.ActionType.None;
        }

        @Override
        protected boolean isEnabledImpl() {
            return false;
        }

        @Override
        public boolean perform(Component component) {
            return false;
        }
    }

    private class PatientTextAction
    extends LabelAction {
        private PatientTextAction() {
        }

        @Override
        public String getID() {
            return PatientInfoAction.TEXT_ID;
        }
    }
}

