/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.swing.util.EventConst;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklist;
import com.agfa.pacs.listtext.lta.base.worklists.NormalizedWorklistManager;
import com.agfa.pacs.listtext.lta.base.worklists.NormalizedWorklistUtils;
import com.agfa.pacs.listtext.lta.util.AsyncWaitingMonitor;
import com.agfa.pacs.listtext.lta.util.WeakListenerSupport;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.awt.Component;
import org.dcm4che3.data.PersonName;

public class PatientNavigation {
    private static PatientNavigation instance;
    private final DataManager dataManager = DataManager.getInstance();
    private final DataSelectionManager selectionManager = DataSelectionManager.getInstance();
    private final NormalizedWorklistManager worklistManager = NormalizedWorklistManager.getInstance();
    private final WeakListenerSupport<IPatientNavigationListener> support = new WeakListenerSupport();
    private final IConfigurationChangeListener onlyOnePatientHandler;
    private WorklistChangeHandler worklistChangeHandler;
    private PatientPositionInfo patientPos;

    private PatientNavigation() {
        this.selectionManager.addListener(new DataSelectionListenerAdapter(){

            @Override
            public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
                PatientNavigation.this.update();
            }
        });
        this.dataManager.addListener(new DataManagerListenerAdapter(){

            @Override
            public void patientRemoved(IPatientRepresentation iPatientRepresentation, boolean bl) {
                if (!Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get()) {
                    PatientNavigation.this.update();
                }
            }

            @Override
            public void patientAdded(IPatientRepresentation iPatientRepresentation) {
                if (!Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get()) {
                    PatientNavigation.this.update();
                }
            }
        });
        this.onlyOnePatientHandler = new IConfigurationChangeListener(){

            public void configurationChanged(String string) {
                PatientNavigation.this.update();
            }
        };
        Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.registerChangeListener(this.onlyOnePatientHandler);
        this.worklistManager.addListener(new NormalizedWorklistManager.INormalizedWorklistManagerListener(){

            public void searchWorklistChanged(INormalizedWorklist iNormalizedWorklist) {
            }

            public void openedWorklistChanged(INormalizedWorklist iNormalizedWorklist, boolean bl) {
                if (PatientNavigation.this.worklistChangeHandler != null) {
                    PatientNavigation.this.worklistChangeHandler.unregister();
                    PatientNavigation.this.worklistChangeHandler = null;
                }
                PatientNavigation.this.update();
                if (iNormalizedWorklist != null) {
                    PatientNavigation.this.worklistChangeHandler = WorklistChangeHandler.register(iNormalizedWorklist);
                }
            }
        });
    }

    public static synchronized PatientNavigation getInstance() {
        if (instance == null) {
            instance = new PatientNavigation();
        }
        return instance;
    }

    public PatientPositionInfo getCurrentPatientPosition() {
        return this.patientPos;
    }

    public boolean hasNextPatient() {
        if (PatientNavigation.isWorklistNavigationUsed()) {
            INormalizedWorklist iNormalizedWorklist = PatientNavigation.getNavigatedWorklist();
            if (iNormalizedWorklist != null) {
                return this.patientPos == null ? iNormalizedWorklist.getDefaultItemWalker().getItemCount() > 0 : this.patientPos.getNextPatient() != null;
            }
            return false;
        }
        return this.patientPos == null ? this.dataManager.getPatientCount() > 0 : this.patientPos.getNextPatient() != null;
    }

    public boolean hasPreviousPatient() {
        if (PatientNavigation.isWorklistNavigationUsed()) {
            INormalizedWorklist iNormalizedWorklist = PatientNavigation.getNavigatedWorklist();
            if (iNormalizedWorklist != null) {
                return this.patientPos == null ? iNormalizedWorklist.getDefaultItemWalker().getItemCount() > 0 : this.patientPos.getPreviousPatient() != null;
            }
            return false;
        }
        return this.patientPos == null ? this.dataManager.getPatientCount() > 0 : this.patientPos.getPreviousPatient() != null;
    }

    public boolean nextPatient(Component component) {
        return this.scrollPatient(true, component);
    }

    public boolean previousPatient(Component component) {
        return this.scrollPatient(false, component);
    }

    public boolean isUsingWorklistAsSource() {
        return PatientNavigation.isWorklistNavigationUsed();
    }

    public void addNavigationListener(IPatientNavigationListener iPatientNavigationListener, boolean bl) {
        this.support.addListener((Object)iPatientNavigationListener, bl);
    }

    public void removeNavigationListener(IPatientNavigationListener iPatientNavigationListener) {
        this.support.removeListener((Object)iPatientNavigationListener);
    }

    private void update() {
        PatientPositionInfo patientPositionInfo = null;
        if (PatientNavigation.isWorklistNavigationUsed()) {
            INormalizedWorklist iNormalizedWorklist = PatientNavigation.getNavigatedWorklist();
            if (iNormalizedWorklist != null) {
                if (iNormalizedWorklist.hasProperty(INormalizedWorklist.WorklistProperty.DataLoaded)) {
                    NormalizedWorklistUtils.NormalizedWorklistItemPositionInfo normalizedWorklistItemPositionInfo = NormalizedWorklistUtils.NormalizedWorklistItemPositionInfo.currentPosition((INormalizedWorklist)iNormalizedWorklist);
                    if (normalizedWorklistItemPositionInfo != null) {
                        patientPositionInfo = new PatientPositionInfo(normalizedWorklistItemPositionInfo);
                    }
                } else {
                    new AsyncWaitingMonitor(() -> iNormalizedWorklist.hasProperty(INormalizedWorklist.WorklistProperty.DataLoaded), 300000L).invokeWhenReady(() -> this.update());
                }
            }
        } else {
            IPatientRepresentation iPatientRepresentation = this.selectionManager.getCurrentPatient();
            if (iPatientRepresentation != null) {
                int n = this.dataManager.getPatientCount();
                int n2 = this.dataManager.getPatientPosition(iPatientRepresentation);
                if (n2 >= 0 && n > 0) {
                    String string = PersonNameUtilities.personNameToHRReverse((PersonName)this.dataManager.getPatientOnPosition(n2).getPatientData().getPatientName());
                    String string2 = null;
                    if (n2 - 1 >= 0 && n2 - 1 < n) {
                        string2 = PersonNameUtilities.personNameToHRReverse((PersonName)this.dataManager.getPatientOnPosition(n2 - 1).getPatientData().getPatientName());
                    }
                    String string3 = null;
                    if (n2 + 1 < n) {
                        string3 = PersonNameUtilities.personNameToHRReverse((PersonName)this.dataManager.getPatientOnPosition(n2 + 1).getPatientData().getPatientName());
                    }
                    patientPositionInfo = new PatientPositionInfo(string, string2, string3, n2 + 1, n);
                }
            }
        }
        this.patientPos = patientPositionInfo;
        this.notifyChange();
    }

    private void notifyChange() {
        this.support.getAllListeners().forEach(iPatientNavigationListener -> iPatientNavigationListener.onChange(this));
    }

    private boolean scrollPatient(boolean bl, Component component) {
        if (PatientNavigation.isWorklistNavigationUsed()) {
            if (bl) {
                PatientNavigation.sendPatientEvent(EventConst.NEXT_PATIENT_EVENT_ID, component);
            } else {
                PatientNavigation.sendPatientEvent(EventConst.PREVIOUS_PATIENT_EVENT_ID, component);
            }
            return true;
        }
        int n = this.dataManager.getPatientPosition(this.selectionManager.getCurrentPatient());
        if ((n += bl ? 1 : -1) >= 0 && n < this.dataManager.getPatientCount()) {
            this.selectionManager.setCurrentPatient(this.dataManager.getPatientOnPosition(n));
            return true;
        }
        return false;
    }

    private static void sendPatientEvent(int n, Component component) {
        IEventEngine iEventEngine = EventEngineFactory.getInstance();
        IEvent iEvent = iEventEngine.createEvent(n);
        iEvent.setRemoteDispatch(false);
        iEvent.setPayload(null);
        iEvent.setSource((Object)component);
        iEvent.setDestination(null, "lta.listarea.ui");
        iEventEngine.sendEvent(iEvent);
    }

    private static boolean isWorklistNavigationUsed() {
        return Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get();
    }

    private static INormalizedWorklist getNavigatedWorklist() {
        return NormalizedWorklistManager.getInstance().getOpenedWorklist();
    }

    public static interface IPatientNavigationListener {
        public void onChange(PatientNavigation var1);
    }

    public static final class PatientPositionInfo {
        private final String currentPatient;
        private final String prevPatient;
        private final String nextPatient;
        private final int currentPatientPos;
        private final int totalPatientCount;
        private final NormalizedWorklistUtils.NormalizedWorklistItemPositionInfo worklistPos;

        public PatientPositionInfo(String string, String string2, String string3, int n, int n2) {
            this.currentPatient = string;
            this.prevPatient = string2;
            this.nextPatient = string3;
            this.currentPatientPos = n;
            this.totalPatientCount = n2;
            this.worklistPos = null;
        }

        public PatientPositionInfo(NormalizedWorklistUtils.NormalizedWorklistItemPositionInfo normalizedWorklistItemPositionInfo) {
            this.currentPatient = normalizedWorklistItemPositionInfo.getItem() != null ? normalizedWorklistItemPositionInfo.getItem().getCaption() : null;
            this.prevPatient = normalizedWorklistItemPositionInfo.getPreviousItem() != null ? normalizedWorklistItemPositionInfo.getPreviousItem().getCaption() : null;
            this.nextPatient = normalizedWorklistItemPositionInfo.getNextItem() != null ? normalizedWorklistItemPositionInfo.getNextItem().getCaption() : null;
            this.currentPatientPos = normalizedWorklistItemPositionInfo.getItemPosition() + 1;
            this.totalPatientCount = normalizedWorklistItemPositionInfo.getTotalItemCount();
            this.worklistPos = normalizedWorklistItemPositionInfo;
        }

        public String getCurrentPatient() {
            return this.currentPatient;
        }

        public String getPreviousPatient() {
            return this.prevPatient;
        }

        public String getNextPatient() {
            return this.nextPatient;
        }

        public int getCurrentPatientPosition() {
            return this.currentPatientPos;
        }

        public int getTotalPatientCount() {
            return this.totalPatientCount;
        }

        public NormalizedWorklistUtils.NormalizedWorklistItemPositionInfo getWorklistPosition() {
            return this.worklistPos;
        }
    }

    private static class WorklistChangeHandler
    implements INormalizedWorklist.INormalizedWorklistListener {
        private final INormalizedWorklist worklist;

        private WorklistChangeHandler(INormalizedWorklist iNormalizedWorklist) {
            this.worklist = iNormalizedWorklist;
        }

        public static WorklistChangeHandler register(INormalizedWorklist iNormalizedWorklist) {
            WorklistChangeHandler worklistChangeHandler = new WorklistChangeHandler(iNormalizedWorklist);
            if (iNormalizedWorklist != null) {
                iNormalizedWorklist.addWorklistListener((INormalizedWorklist.INormalizedWorklistListener)worklistChangeHandler);
            }
            return worklistChangeHandler;
        }

        public void unregister() {
            if (this.worklist != null) {
                this.worklist.removeWorklistListener((INormalizedWorklist.INormalizedWorklistListener)this);
            }
        }

        public void worklistChanged() {
            PatientNavigation.getInstance().update();
        }

        public void worklistTableSorted() {
            PatientNavigation.getInstance().update();
        }
    }
}

