/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.FixTextPAction;
import com.agfa.pacs.impaxee.actions.impl.FlatCompoundAbstractPAction;
import com.agfa.pacs.impaxee.config.Config;
import com.tiani.jvision.toptoolbar.PatientNavigation;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class PatientNavigationProvider
implements PActionProvider {
    public static final String NEXT_PATIENT = "NEXT_PATIENT";
    public static final String PREVIOUS_PATIENT = "PREVIOUS_PATIENT";
    public static final String PATIENT_NAVIGATION = "PATIENT_NAVIGATION";
    public static final String PATIENT_NAVIGATION_AND_POSITION = "PATIENT_NAVIGATION_AND_POSITION";
    private static final NextPatientAction next = new NextPatientAction();
    private static final PreviousPatientAction previous = new PreviousPatientAction();
    private static final PatientNavigationAction nav = new PatientNavigationAction(previous, next);
    private static final PatientNavigationAndPositionAction navAndPos = new PatientNavigationAndPositionAction(previous, next);

    public PatientNavigationProvider() {
        PatientNavigation.getInstance().addNavigationListener(new PatientNavigation.IPatientNavigationListener(){

            @Override
            public void onChange(PatientNavigation patientNavigation) {
                EventUtil.invoke(() -> PatientNavigationProvider.this.update(patientNavigation.getCurrentPatientPosition()));
            }
        }, false);
        Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.registerChangeListener(new IConfigurationChangeListener(){

            public void configurationChanged(String string) {
                EventUtil.invoke(() -> PatientNavigationProvider.this.update(PatientNavigation.getInstance().getCurrentPatientPosition()));
            }
        });
        this.update(PatientNavigation.getInstance().getCurrentPatientPosition());
    }

    private void update(PatientNavigation.PatientPositionInfo patientPositionInfo) {
        if (!PatientNavigation.getInstance().isUsingWorklistAsSource()) {
            previous.setEnabled(PatientNavigation.getInstance().hasPreviousPatient());
            next.setEnabled(PatientNavigation.getInstance().hasNextPatient());
        } else {
            previous.setEnabled(true);
            next.setEnabled(true);
        }
        if (patientPositionInfo == null) {
            previous.setPreviousPatientName(null);
            next.setNextPatientName(null);
            navAndPos.resetText();
        } else {
            previous.setPreviousPatientName(previous.isEnabled() ? patientPositionInfo.getPreviousPatient() : null);
            next.setNextPatientName(next.isEnabled() ? patientPositionInfo.getNextPatient() : null);
            navAndPos.updateText(patientPositionInfo.getCurrentPatientPosition(), patientPositionInfo.getTotalPatientCount());
        }
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(nav);
        arrayList.add(navAndPos);
        arrayList.add(next);
        arrayList.add(previous);
        return arrayList;
    }

    private static abstract class AbstractPatientNavigationAction
    extends FlatCompoundAbstractPAction {
        private final FixTextPAction textAction;

        public AbstractPatientNavigationAction(PAction pAction, PAction pAction2, FixTextPAction fixTextPAction) {
            super(new PAction[]{pAction, fixTextPAction, pAction2});
            this.textAction = fixTextPAction;
        }

        @Override
        public boolean isAvailable() {
            return !Product.isReducedVersion();
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        protected final FixTextPAction getTextAction() {
            return this.textAction;
        }
    }

    private static class NextPatientAction
    extends AbstractPAction {
        private String nextPatientName = null;

        public NextPatientAction() {
            super("next_item.svg");
        }

        @Override
        public String getName() {
            return Messages.getString("GeneralActions.nextPatient.Name");
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(39, 8);
        }

        @Override
        public String getID() {
            return PatientNavigationProvider.NEXT_PATIENT;
        }

        public void setNextPatientName(String string) {
            this.nextPatientName = string;
            this.fireContentChanged(false);
        }

        @Override
        public String getToolTipText() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(Messages.getString("GeneralActions.nextPatient.ToolTip"));
            if (this.nextPatientName != null) {
                stringBuilder.append("<br/><b>");
                stringBuilder.append(this.nextPatientName);
                stringBuilder.append("</b>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            return PatientNavigation.getInstance().nextPatient(component);
        }
    }

    private static class PatientNavigationAction
    extends AbstractPatientNavigationAction {
        public PatientNavigationAction(PAction pAction, PAction pAction2) {
            super(pAction, pAction2, new FixTextPAction(Messages.getString("GeneralActions.scrollPatients.Text")));
        }

        @Override
        public String getID() {
            return PatientNavigationProvider.PATIENT_NAVIGATION;
        }

        @Override
        public String getCaption() {
            return Messages.getString("GeneralActions.PatientNavigation.ToolTip");
        }
    }

    private static class PatientNavigationAndPositionAction
    extends AbstractPatientNavigationAction {
        private static final String TEXT = Messages.getString("GeneralActions.scrollPatients.Text");
        private static final String TEXT_PATTERN = Messages.getString("GeneralActions.scrollPatients.Pattern");

        public PatientNavigationAndPositionAction(PAction pAction, PAction pAction2) {
            super(pAction, pAction2, new FixTextPAction(TEXT));
        }

        @Override
        public String getID() {
            return PatientNavigationProvider.PATIENT_NAVIGATION_AND_POSITION;
        }

        @Override
        public String getCaption() {
            return Messages.getString("GeneralActions.PatientNavigationAndPosition.ToolTip");
        }

        public void resetText() {
            this.getTextAction().setCaption(TEXT);
        }

        public void updateText(int n, int n2) {
            if (n <= 0 || n2 <= 0) {
                this.resetText();
            } else {
                this.getTextAction().setCaption(MessageFormat.format(TEXT_PATTERN, n, n2));
            }
        }
    }

    private static class PreviousPatientAction
    extends AbstractPAction {
        private String previousPatientName = null;

        public PreviousPatientAction() {
            super("previous_item.svg");
        }

        @Override
        public String getName() {
            return Messages.getString("GeneralActions.previousPatient.Name");
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public String getID() {
            return PatientNavigationProvider.PREVIOUS_PATIENT;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(37, 8);
        }

        @Override
        public String getToolTipText() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(Messages.getString("GeneralActions.previousPatient.ToolTip"));
            if (this.previousPatientName != null) {
                stringBuilder.append("<br/><b>");
                stringBuilder.append(this.previousPatientName);
                stringBuilder.append("</b>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            return PatientNavigation.getInstance().previousPatient(component);
        }

        public void setPreviousPatientName(String string) {
            this.previousPatientName = string;
            this.fireContentChanged(false);
        }
    }
}

