/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataAction;
import com.agfa.pacs.impaxee.actions.PDataActionProvider;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.PSelectableAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.IconDefinition;
import com.agfa.pacs.impaxee.plugin.ManualPluginStarter;
import com.agfa.pacs.impaxee.plugin.PluginManager;
import com.tiani.jvision.plugin.DefaultPlugin;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class PluginActions
implements PDataActionProvider {
    public static final String PLUGIN_ID = "PLUGIN_";
    public static final String PLUGIN_OFF = PluginActions.getPluginActionID(PluginName.DEFAULT);

    public static String getPluginActionID(PluginName pluginName) {
        if (pluginName == null) {
            return PLUGIN_OFF;
        }
        return PLUGIN_ID + pluginName.name();
    }

    public static String getPluginActionID(String string) {
        if (string == null) {
            return PLUGIN_OFF;
        }
        return PLUGIN_ID + string;
    }

    @Override
    public List<PDataAction> getDataActions() {
        ArrayList<PDataAction> arrayList = new ArrayList<PDataAction>();
        arrayList.add(new PluginDataAction(PluginName.DEFAULT));
        PluginName[] pluginNameArray = PluginName.values();
        int n = pluginNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginName pluginName = pluginNameArray[n2];
            if (pluginName.isPlugin() && !pluginName.isAutostartPlugin() && pluginName != PluginName.DEFAULT) {
                arrayList.add(new PluginDataAction(pluginName));
            }
            ++n2;
        }
        return arrayList;
    }

    private static class PluginDataAction
    extends AbstractPDataAction {
        private PluginName type;

        public PluginDataAction(PluginName pluginName) {
            super(true);
            this.type = pluginName;
            this.init();
        }

        @Override
        protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            if (pDataScope == null && pDataProvider == null) {
                throw new ActionNotFoundException(this.getID());
            }
            return new PluginAction(pDataScope, pDataProvider);
        }

        @Override
        public PDataScope[] getAvailableScopes() {
            return new PDataScope[]{PDataScope.CurrentDisplay};
        }

        private IconDefinition getIcon() {
            if (this.type == PluginName.DEFAULT) {
                return new DefaultPlugin().getIconDefinition();
            }
            IPlugin iPlugin = PluginManager.getPluginByActionCode(PluginActions.PLUGIN_ID + this.type.name());
            if (iPlugin != null) {
                return iPlugin.getIconDefinition();
            }
            return null;
        }

        @Override
        public String getID() {
            return PluginActions.PLUGIN_ID + this.type.name();
        }

        private class PluginAction
        extends AbstractPDataAction.SelectableInnerPAction
        implements PSelectableAction {
            private boolean selected;

            PluginAction(PDataScope pDataScope, PDataProvider pDataProvider) {
                super(PluginDataAction.this.getIcon(), pDataScope, pDataProvider);
                this.selected = false;
            }

            @Override
            public KeyShortcut getDefaultShortcut() {
                if (PluginDataAction.this.type == PluginName.DEFAULT) {
                    return new KeyShortcut(49, 8);
                }
                if (PluginDataAction.this.type == PluginName.EMPR) {
                    return new KeyShortcut(50, 8);
                }
                if (PluginDataAction.this.type == PluginName.ANIM2D) {
                    return new KeyShortcut(51, 8);
                }
                return null;
            }

            @Override
            public String getCaption() {
                return PluginDataAction.this.type.getCaption();
            }

            @Override
            public String getGroupName() {
                return PluginDataAction.this.type.isInternalPlugin() ? "INTERNAL" : PLUGINS_GROUP;
            }

            @Override
            public String getToolTipText() {
                if (PluginDataAction.this.type == PluginName.DEFAULT) {
                    return Messages.getString("CustomActions1.pluginsChoice.pluginOff.ToolTip");
                }
                IPlugin iPlugin = PluginManager.getPluginByActionCode(PluginDataAction.this.getID());
                if (iPlugin == null) {
                    return null;
                }
                return iPlugin.getDescription();
            }

            @Override
            public boolean perform(Component component) {
                this.notifyActionPerformed();
                List<VisDisplay2> list = this.scope != null ? PluginDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
                if (list.isEmpty()) {
                    return false;
                }
                IPlugin iPlugin = PluginManager.getPluginByActionCode(PluginDataAction.this.getID());
                VisDisplay2 visDisplay2 = list.get(0);
                return new ManualPluginStarter(iPlugin, visDisplay2).start();
            }

            @Override
            public void setSelected(boolean bl) {
                if (this.provider != null) {
                    this.selected = bl;
                    this.fireSelectionChanged();
                }
            }

            @Override
            public boolean isEnabled(VisData visData) {
                if (!this.isEnabled()) {
                    return false;
                }
                IPlugin iPlugin = PluginManager.getPluginByActionCode(PluginDataAction.this.getID());
                return iPlugin != null && iPlugin.areDataSuitable(visData.getParent().getDisplaySet());
            }

            @Override
            public boolean isSelectedImpl() {
                return this.selected;
            }

            @Override
            public boolean isAvailable() {
                if (PluginDataAction.this.type == PluginName.DEFAULT) {
                    return true;
                }
                return PluginManager.getPluginByActionCode(PluginDataAction.this.getID()) != null;
            }
        }
    }
}

