/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.jvision.vis.PrintUtils;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.LytDisplay;
import com.tiani.jvision.vis.layout.LytScreen;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class PrintDataAction
extends AbstractPDataAction {
    public static final String ID = "PRINT";
    private static final boolean isAvailable = PrintUtils.isPrintingAvailable();

    public static boolean isAvailable() {
        return isAvailable;
    }

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new PrintAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay, PDataScope.AllDisplayed, PDataScope.SelectedImages, PDataScope.KeyImages, PDataScope.CurrentScreen, PDataScope.CurrentImage};
    }

    @Override
    public String getID() {
        return ID;
    }

    private static String getIconForType(PDataScope pDataScope, PDataProvider pDataProvider) {
        if (pDataScope == PDataScope.AllDisplayed) {
            return "print_screen.svg";
        }
        if (pDataScope == PDataScope.CurrentDisplay || pDataProvider != null) {
            return "print_display.svg";
        }
        return null;
    }

    public int[] getFormatsOnScreen(VisScreen2 visScreen2) {
        VisDisplay2 visDisplay2 = visScreen2.getVisDisplays().get(0);
        LytDisplay lytDisplay = visDisplay2.getLyt();
        for (VisDisplay2 object2 : visScreen2.getVisDisplays()) {
            if (!object2.hasData() || this.equalsLyt(lytDisplay, object2.getLyt())) continue;
            return null;
        }
        LytScreen lytScreen = visScreen2.getLyt();
        return new int[]{lytScreen.getRows() * lytDisplay.getRows(), lytScreen.getCols() * lytDisplay.getCols()};
    }

    private boolean equalsLyt(LytDisplay lytDisplay, LytDisplay lytDisplay2) {
        return lytDisplay.getMainLayoutType() == lytDisplay2.getMainLayoutType() && lytDisplay.getCols() == lytDisplay2.getCols() && lytDisplay.getRows() == lytDisplay2.getRows();
    }

    private class PrintAction
    extends AbstractPDataAction.AbstractInnerPAction {
        public PrintAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(PrintDataAction.getIconForType(pDataScope, pDataProvider), pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("CustomActions1.printAllImagesOnScreen.Caption");
            }
            if (this.scope == PDataScope.CurrentDisplay) {
                return Messages.getString("CustomActions1.printAllImagesInDisplay.Caption");
            }
            if (this.scope == PDataScope.SelectedImages) {
                return Messages.getString("CustomActions1.printSelectedImages.Caption");
            }
            if (this.scope == PDataScope.KeyImages) {
                return Messages.getString("CustomActions1.printKeyImages.Caption");
            }
            if (this.scope == PDataScope.CurrentImage) {
                return Messages.getString("PrintDataAction.PrintCurrentImage.Caption");
            }
            if (this.scope == PDataScope.CurrentScreen) {
                return Messages.getString("PrintDataAction.PrintCurrentScreen.Caption");
            }
            return Messages.getString(PrintDataAction.ID);
        }

        @Override
        public String getGroupName() {
            return EXPORT_PRINT_GROUP;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            if (this.scope == PDataScope.CurrentDisplay) {
                return new KeyShortcut(80, 2);
            }
            if (this.scope == PDataScope.AllDisplayed) {
                return new KeyShortcut(80, 3);
            }
            return null;
        }

        @Override
        public String getToolTipText() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("CustomActions1.printAllImagesOnScreen.ToolTip");
            }
            if (this.scope == PDataScope.CurrentDisplay || this.scope == null) {
                return Messages.getString("CustomActions1.printAllImagesInDisplay.ToolTip");
            }
            if (this.scope == PDataScope.SelectedImages) {
                return Messages.getString("CustomActions1.printSelectedImages.ToolTip");
            }
            if (this.scope == PDataScope.KeyImages) {
                return Messages.getString("CustomActions1.printKeyImages.ToolTip");
            }
            if (this.scope == PDataScope.CurrentImage) {
                return Messages.getString("PrintDataAction.PrintCurrentImage.ToolTip");
            }
            if (this.scope == PDataScope.CurrentScreen) {
                return Messages.getString("PrintDataAction.PrintCurrentScreen.ToolTip");
            }
            return null;
        }

        @Override
        public String getName() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("CustomActions1.printAllImagesOnScreen.Name");
            }
            if (this.scope == PDataScope.CurrentDisplay || this.scope == null) {
                return Messages.getString("CustomActions1.printAllImagesInDisplay.Name");
            }
            if (this.scope == PDataScope.SelectedImages) {
                return Messages.getString("CustomActions1.printSelectedImages.Name");
            }
            if (this.scope == PDataScope.KeyImages) {
                return Messages.getString("CustomActions1.printKeyImages.Name");
            }
            if (this.scope == PDataScope.CurrentImage) {
                return Messages.getString("PrintDataAction.PrintCurrentImage.Name");
            }
            if (this.scope == PDataScope.CurrentScreen) {
                return Messages.getString("PrintDataAction.PrintCurrentScreen.Name");
            }
            return null;
        }

        @Override
        public boolean isAvailable() {
            return isAvailable;
        }

        private List<VisData> getVisibleVisOnScreen(VisScreen2 visScreen2) {
            ArrayList<VisData> arrayList = new ArrayList<VisData>();
            for (VisDisplay2 visDisplay2 : visScreen2.getVisDisplays()) {
                for (Vis2 vis2 : visDisplay2.getVisViews()) {
                    if (!vis2.hasData()) continue;
                    arrayList.add(vis2.getView().getVis());
                }
            }
            return arrayList;
        }

        @Override
        public boolean perform(Component component) {
            List<VisData> list;
            this.notifyActionPerformed();
            int[] nArray = null;
            if (this.scope == PDataScope.CurrentScreen) {
                VisData visData = VisData.getLastModified();
                if (visData == null) {
                    return false;
                }
                VisScreen2 visScreen2 = visData.getParent().getVisDisplay().getVisScreen();
                list = this.getVisibleVisOnScreen(visScreen2);
                nArray = PrintDataAction.this.getFormatsOnScreen(visScreen2);
            } else {
                list = this.scope != null ? PrintDataAction.getVisDatas(this.scope) : this.provider.getVisDatas();
            }
            if (list.isEmpty()) {
                Message.info(Messages.getString("PrintDataAction.NoImagesDialog.Title"), Messages.getString("PrintDataAction.NoImagesDialog.Msg"));
                return false;
            }
            return PrintUtils.print(list, nArray);
        }
    }
}

