/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.Modes;
import com.tiani.jvision.toptoolbar.SeriesPaletteOrientationSelectionAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SeriesPaletteOrientationActionProvider
implements PActionProvider {
    private static final String ID_PREFIX = "SERIES_PALETTE_ORIENTATION_";

    public static String getIDForMode(Modes.PaletteOrientation paletteOrientation) {
        return ID_PREFIX + paletteOrientation.name();
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        Modes.PaletteOrientation[] paletteOrientationArray = Modes.PaletteOrientation.values();
        int n = paletteOrientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Modes.PaletteOrientation paletteOrientation = paletteOrientationArray[n2];
            arrayList.add(new SeriesPaletteOrientationAction(paletteOrientation));
            ++n2;
        }
        arrayList.add(new SeriesPaletteOrientationSelectionAction(new ArrayList<PAction>(arrayList)));
        return arrayList;
    }

    private String getIconImpl(Modes.PaletteOrientation paletteOrientation) {
        return "SeriesPaletteOrientation_" + paletteOrientation.name() + ".svg";
    }

    private class SeriesPaletteOrientationAction
    extends AbstractPAction {
        private Modes.PaletteOrientation orientation;

        public SeriesPaletteOrientationAction(Modes.PaletteOrientation paletteOrientation) {
            super(SeriesPaletteOrientationActionProvider.this.getIconImpl(paletteOrientation));
            this.orientation = paletteOrientation;
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getName() {
            return Messages.getString("SeriesPaletteOrientation." + this.orientation.name());
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SeriesPaletteOrientationActionProvider.getIDForMode(this.orientation);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("SeriesPaletteOrientation." + this.orientation.name() + ".ToolTip");
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isSelected() {
            return JVision2.getMainFrame().getPaletteOrientation() == this.orientation;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            JVision2.getMainFrame().setSeriesPaletteOrientation(this.orientation);
            return true;
        }
    }
}

