/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.FrameRateUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.tiani.jvision.toptoolbar.LoopModeActionProvider;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class SimplePlaybackDataAction
extends AbstractPDataAction {
    private static final String playIcon = "play_hr.svg";
    public static final String ID = "SIMPLE_PLAYBACK";
    private static final int DEFAULT_FRAME_RATE = 10;

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new SimplePlaybackAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay};
    }

    @Override
    public String getID() {
        return ID;
    }

    private class SimplePlaybackAction
    extends AbstractPDataAction.AbstractInnerPAction {
        private Timer timer;

        public SimplePlaybackAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(SimplePlaybackDataAction.playIcon, pDataScope, pDataProvider);
            this.timer = null;
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public boolean isEnabled(VisData visData) {
            return this.isEnabled() && visData.getParent().getDisplaySet().isNotEmpty();
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("TOOLTIP_BUTTON_PLAY");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            VisDisplay2 visDisplay2 = null;
            visDisplay2 = this.provider != null ? this.provider.getVisDisplays().get(0) : AbstractPDataAction.getVisDisplays(this.scope).get(0);
            if (visDisplay2 == null) {
                return false;
            }
            if (!visDisplay2.getData().hasData()) {
                return false;
            }
            this.start(visDisplay2, component);
            return true;
        }

        private void start(VisDisplay2 visDisplay2, Component component) {
            boolean bl;
            if (this.isSelected()) {
                this.stop();
                return;
            }
            try {
                PActionRegistry.getAction(LoopModeActionProvider.getIDForMode(LoopModeActionProvider.LoopMode.STOP)).perform(component);
            }
            catch (ActionNotFoundException actionNotFoundException) {}
            Integer n = FrameRateUtils.getRecommendedFrameRate(visDisplay2.getData().getDisplaySet());
            boolean bl2 = bl = n != null;
            if (n == null) {
                n = 10;
            }
            this.timer = new Timer(1000 / n, new PaintingTimer(visDisplay2, n, bl));
            this.timer.setCoalesce(true);
            this.timer.start();
        }

        private void stop() {
            final Timer timer = this.timer;
            if (this.isSelected()) {
                this.timer.stop();
                this.timer = null;
            }
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (timer != null) {
                        ActionListener[] actionListenerArray = timer.getActionListeners();
                        int n = actionListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ActionListener actionListener = actionListenerArray[n2];
                            if (actionListener instanceof PaintingTimer) {
                                ((PaintingTimer)actionListener).lastPaint();
                            }
                            ++n2;
                        }
                    }
                    SimplePlaybackAction.this.forcedSelectionChanged();
                }
            });
        }

        @Override
        public boolean isSelected() {
            if (this.timer != null) {
                return this.timer.isRunning();
            }
            return false;
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        private class PaintingTimer
        implements ActionListener {
            private VisDisplay2 display;
            private long end;
            private long start = Long.MAX_VALUE;
            private long delay;
            private int plannedDelay;
            private boolean frameRateSpecified;

            public PaintingTimer(VisDisplay2 visDisplay2, int n, boolean bl) {
                this.display = visDisplay2;
                this.plannedDelay = n;
                this.frameRateSpecified = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = this.display.performSimpleAnimation();
                if (bl) {
                    this.display.paintNow();
                    this.end = System.currentTimeMillis();
                    this.delay = (long)this.plannedDelay - (this.end - this.start);
                    this.start = this.end;
                    if (this.delay < 0L && this.frameRateSpecified) {
                        this.display.setFrameRateWarning(true);
                    }
                } else {
                    this.display.setNavigationPosition(0, new VisDisplay2.NavigationPositionOption[0]);
                    SimplePlaybackAction.this.stop();
                }
            }

            public void lastPaint() {
                if (this.display != null) {
                    this.display.setFrameRateWarning(false);
                    this.display.paintNow();
                }
                this.display = null;
            }
        }
    }
}

