/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.config.Config;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SyncOptionsActionProvider
implements PActionProvider {
    private static final String ID_PREFIX = "SYNC_OPTION_";

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        SyncOption.ZOOM_PAN.setSelected(Config.impaxee.jvision.SYNCHRONIZE.SyncZoomPan.get());
        SyncOption.SCROLLING.setSelected(Config.impaxee.jvision.SYNCHRONIZE.SyncScroll.get());
        SyncOption.WINDOW_LEVEL.setSelected(Config.impaxee.jvision.SYNCHRONIZE.SyncWindow.get());
        if (!Product.isReducedVersion()) {
            arrayList.add(new SyncOptionAction(SyncOption.ZOOM_PAN));
            arrayList.add(new SyncOptionAction(SyncOption.SCROLLING));
            arrayList.add(new SyncOptionAction(SyncOption.WINDOW_LEVEL));
        }
        return arrayList;
    }

    private String getIconImpl(SyncOption syncOption) {
        return "syncOption_" + syncOption.name() + ".svg";
    }

    public static String getIDForSyncOption(SyncOption syncOption) {
        return ID_PREFIX + syncOption.name();
    }

    public static enum SyncOption {
        ZOOM_PAN,
        SCROLLING,
        WINDOW_LEVEL;

        private boolean isSelected;

        private void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public boolean isSelected() {
            return this.isSelected;
        }
    }

    private class SyncOptionAction
    extends SelectablePAction {
        private SyncOption syncOption;

        public SyncOptionAction(SyncOption syncOption) {
            super(SyncOptionsActionProvider.this.getIconImpl(syncOption));
            this.syncOption = syncOption;
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getName() {
            return Messages.getString("FixedActions.syncOptions." + this.syncOption.name() + ".Name");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SyncOptionsActionProvider.getIDForSyncOption(this.syncOption);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("FixedActions.syncOptions." + this.syncOption.name() + ".ToolTip");
        }

        @Override
        public boolean perform(Component component) {
            this.syncOption.setSelected(!this.syncOption.isSelected());
            super.fireSelectionChanged();
            return true;
        }

        @Override
        public boolean isSelected() {
            return this.syncOption.isSelected();
        }
    }
}

