/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.sync.SynchronizationManager;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.List;

public class SynchronizeDataAction
extends AbstractPDataAction {
    public static final String ID = "SYNCHRONIZE";

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new SynchronizeAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay, PDataScope.AllDisplayed};
    }

    @Override
    public String getID() {
        return ID;
    }

    private class SynchronizeAction
    extends AbstractPDataAction.SelectableInnerPAction {
        public SynchronizeAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope != PDataScope.AllDisplayed ? "synchronize.svg" : null, pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("ACTION_SYNCHRONIZE_ALL");
            }
            return Messages.getString("CustomActions2.selectForSynchronization.ToolTip");
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            if (this.scope == PDataScope.AllDisplayed) {
                return new KeyShortcut(83, 2);
            }
            if (this.scope == PDataScope.CurrentDisplay) {
                return new KeyShortcut(83, 8);
            }
            return null;
        }

        @Override
        public boolean isSelectedImpl() {
            return this.provider.getVisDisplays().get(0).isSynchronized();
        }

        @Override
        public String getToolTipText() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("ACTION_SYNCHRONIZE_ALL_DESCRIPTION");
            }
            return Messages.getString("CustomActions2.selectForSynchronization.ToolTip");
        }

        @Override
        public boolean isEnabled(VisData visData) {
            return this.isEnabled();
        }

        private List<VisDisplay2> getDisplays(Component component) {
            List<VisDisplay2> list = this.provider != null ? this.provider.getVisDisplays() : (Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get() && component instanceof Vis2 ? SynchronizeDataAction.getVisDisplaysBasedOnMousePosition() : SynchronizeDataAction.getVisDisplays(this.scope));
            return list;
        }

        @Override
        public boolean perform(Component component) {
            List<VisDisplay2> list = this.getDisplays(component);
            if (list == null) {
                return false;
            }
            this.notifyActionPerformed();
            if (!SynchronizationManager.getInstance().toggleSynchronization(list)) {
                this.forcedSelectionChanged();
            }
            return true;
        }
    }
}

