/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.LytScreen;
import java.awt.Component;

public class VariableLayoutChooserDataAction
extends AbstractPDataAction {
    public static final String ID = "VARIABLE_LAYOUT_CHOOSER";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new VariableLayoutChooserAction(pDataScope, pDataProvider);
    }

    @Override
    public boolean canHandleDataProvider(PDataProvider.ProviderType providerType) {
        return providerType == PDataProvider.ProviderType.Screen;
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentScreen};
    }

    public class VariableLayoutChooserAction
    extends AbstractPDataAction.AbstractInnerPAction {
        public VariableLayoutChooserAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super("layout-configuration.svg", pDataScope, pDataProvider);
        }

        @Override
        public String getGroupName() {
            return LAYOUT_GROUP;
        }

        @Override
        public String getCaption() {
            VisScreen2 visScreen2 = this.getScreen();
            if (visScreen2 != null) {
                LytScreen lytScreen = visScreen2.getLyt();
                String string = lytScreen.getDescription();
                if (string != null) {
                    return string;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(lytScreen.getCols()).append("x").append(lytScreen.getRows());
                return stringBuilder.toString();
            }
            return "";
        }

        @Override
        public String getName() {
            return Messages.getString("VariableLayoutChooserAction.Caption");
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("VariableLayoutChooserAction.Tooltip");
        }

        @Override
        public PAction[] getSubactions() {
            return new PAction[]{this};
        }

        @Override
        protected boolean isEnabledImpl() {
            VisScreen2 visScreen2 = this.getScreen();
            if (visScreen2 == null || !visScreen2.isLayoutChangeAllowed()) {
                return false;
            }
            return visScreen2.getLytMode() == MainLayoutType.variable;
        }

        @Override
        public boolean perform(Component component) {
            return true;
        }

        public void updateComponent() {
            this.fireContentChanged(false);
        }

        public boolean perform(int n, int n2) {
            this.notifyActionPerformed();
            VisScreen2 visScreen2 = this.getScreen();
            if (visScreen2 != null) {
                visScreen2.setLytMode(MainLayoutType.variable, n, n2, true);
                this.fireContentChanged(false);
                return true;
            }
            return false;
        }
    }
}

