/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.swing.util.ComponentUtil;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.image.WindowLevelHelper;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.windowing.WindowingValue;
import com.tiani.jvision.main.windowing.WindowingValuesManager;
import com.tiani.jvision.main.windowing.gui.WindowingValuesDlg;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WindowingActions
implements PActionProvider {
    public static final String APPLY_PREFIX = "APPLY_WINDOWING_";
    public static final String EDIT_PREFIX = "EDIT_WINDOWING_";
    private static final ALogger log = ALogger.getLogger(WindowingActions.class);
    private static boolean isContextSensitiveHelpEnabled = Config.impaxee.jvision.Help.enableShortcutF1.get();

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        int n = 0;
        while (n <= 11) {
            arrayList.add(new WindowingAction(n));
            ++n;
        }
        n = 0;
        while (n <= 11) {
            arrayList.add(new EditWindowAction(n));
            ++n;
        }
        return arrayList;
    }

    static void disableContextSensitiveHelp() {
        isContextSensitiveHelpEnabled = false;
    }

    public static String formatSlot(int n) {
        return StringUtils.leftPad((String)Integer.toString(n), (int)3, (char)'0');
    }

    private static class EditWindowAction
    extends AbstractPAction {
        private int slot;

        public EditWindowAction(int n) {
            this.slot = n;
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_WINDOWINGVALUES_EDIT_VALUE_" + WindowingActions.formatSlot(this.slot));
        }

        @Override
        public String getGroupName() {
            return WINDOW_LEVEL_GROUP;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(112 + this.slot, 2);
        }

        @Override
        public String getID() {
            return WindowingActions.EDIT_PREFIX + WindowingActions.formatSlot(this.slot);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_WINDOWINGVALUES_EDIT_VALUE_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            WindowingValuesDlg windowingValuesDlg = new WindowingValuesDlg(JVision2.getMainFrame(), this.slot);
            windowingValuesDlg.setVisible(true);
            WindowingValuesManager.instance.write();
            return true;
        }
    }

    private static class WindowingAction
    extends AbstractPAction {
        private int slot;

        public WindowingAction(int n) {
            this.slot = n;
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_WINDOWINGVALUES_APPLY_VALUE_" + WindowingActions.formatSlot(this.slot));
        }

        @Override
        public PluginName[] getScopes() {
            if (this.slot == 0 && isContextSensitiveHelpEnabled) {
                PluginName[] pluginNameArray = new PluginName[2];
                pluginNameArray[0] = PluginName.LTA;
                return pluginNameArray;
            }
            return super.getScopes();
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(112 + this.slot);
        }

        @Override
        public String getGroupName() {
            return WINDOW_LEVEL_GROUP;
        }

        @Override
        public String getID() {
            return WindowingActions.APPLY_PREFIX + WindowingActions.formatSlot(this.slot);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_WINDOWINGVALUES_APPLY_VALUE_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            if (this.slot == 0 && isContextSensitiveHelpEnabled && !this.isMouseOverDisplay()) {
                try {
                    PAction pAction = PActionRegistry.getAction("CONTEXT_SENSITIVE_HELP");
                    return pAction.perform(component);
                }
                catch (ActionNotFoundException actionNotFoundException) {
                    log.warn("No context sensitive help action found, disabling F1 shortcut.");
                    WindowingActions.disableContextSensitiveHelp();
                }
            }
            this.notifyActionPerformed();
            WindowingValue windowingValue = WindowingValuesManager.instance.getWindowingValues().getValue(this.slot);
            int n = windowingValue.getCenter();
            int n2 = windowingValue.getWidth();
            if (n == 0 && n2 == 1) {
                return false;
            }
            log.debug("WINDOWINGVALUE " + windowingValue);
            WindowLevelHelper.setWindowLevelForLastModifiedVis(n, n2, this);
            return true;
        }

        private boolean isMouseOverDisplay() {
            Point point = MouseInfo.getPointerInfo().getLocation();
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            Component component = ComponentUtil.getDeepComponentAt((Container)window, (Point)point);
            while (component != null) {
                if (component instanceof VisDisplay2) {
                    return true;
                }
                component = component.getParent();
            }
            return false;
        }
    }
}

