/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.PSelectableAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.PixelIdentityFitHandler;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.toptoolbar.ZoomUtils;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.List;

public class ZoomModePixelDataAction
extends AbstractPDataAction {
    public static final String ID = "ZOOM_PIXEL_1x1";

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new ZoomModePixelAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay};
    }

    @Override
    public String getID() {
        return ID;
    }

    private class ZoomModePixelAction
    extends AbstractPDataAction.SelectableInnerPAction
    implements PSelectableAction {
        public ZoomModePixelAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super("zoom_one_to_one.svg", pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("FixedActions.zoom.zoomModeOneToOne.ToolTip");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(49, 2);
        }

        @Override
        public boolean isSelectedImpl() {
            AreaFitHandler areaFitHandler = this.getZoomHandler();
            if (areaFitHandler == null) {
                return false;
            }
            return areaFitHandler instanceof PixelIdentityFitHandler;
        }

        private AreaFitHandler getZoomHandler() {
            if (this.provider == null) {
                return null;
            }
            List<VisData> list = this.provider.getVisDatas();
            if (list.isEmpty()) {
                return null;
            }
            Renderer renderer = list.get(0).getView().getRenderer();
            if (renderer instanceof IRDCRenderer) {
                return ((IRDCRenderer)((Object)renderer)).getAreaFitHandler();
            }
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            List<VisDisplay2> list = this.scope != null ? ZoomModePixelDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
            if (list.size() != 1) {
                return false;
            }
            VisDisplay2 visDisplay2 = list.get(0);
            ZoomUtils.ensureDeactivatedMagnifyingGlass(visDisplay2);
            if (visDisplay2.getData().getZoomMode() != ZoomMode.PIXELIDENTITY) {
                ZoomUtils.setZoomMode(visDisplay2, ZoomMode.PIXELIDENTITY);
            } else {
                ZoomUtils.setZoomMode(visDisplay2, ZoomMode.NORMAL);
            }
            return true;
        }

        @Override
        public void setSelected(boolean bl) {
            if (this.provider != null) {
                this.fireSelectionChanged();
            }
        }
    }
}

