/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.PixelIdentityFitHandler;
import com.tiani.jvision.image.fithandler.TrueSizeFitHandler;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import java.util.Collections;

public class ZoomUtils {
    private static boolean trueSizeAllowed = PActionRegistry.getDataAction("ZOOM_TRUE_SIZE", PDataScope.CurrentDisplay).isAvailable();
    private static final ALogger log = ALogger.getLogger(ZoomUtils.class);

    public static boolean isTrueSizeZoomAllowed() {
        return trueSizeAllowed;
    }

    public static void setZoomMode(VisDisplay2 visDisplay2, ZoomMode zoomMode) {
        if (!visDisplay2.hasData()) {
            return;
        }
        AreaFitHandler areaFitHandler = null;
        TEvent tEvent = new TEvent();
        tEvent.id = 80;
        if (ZoomMode.NORMAL == zoomMode) {
            areaFitHandler = new FullVisualFitHandler(OutputDeviceMetric.screen);
        } else if (ZoomMode.TRUESIZE == zoomMode) {
            areaFitHandler = trueSizeAllowed ? new TrueSizeFitHandler() : new FullVisualFitHandler(OutputDeviceMetric.screen);
        } else if (ZoomMode.PIXELIDENTITY == zoomMode) {
            areaFitHandler = new PixelIdentityFitHandler();
        }
        if (zoomMode == ZoomMode.TRUESIZE && !trueSizeAllowed) {
            log.error("Cannot switch to true size zoom. Please make sure that the physical height and width of a screen pixel are defined.");
        } else {
            TEventDispatch.sendEvent(Collections.singletonList(visDisplay2), tEvent, (Object)areaFitHandler, false);
        }
        ZoomUtils.setDisplayZoomMode(visDisplay2, zoomMode);
    }

    public static ZoomMode viewportHandlerToZoomMode(AreaFitHandler areaFitHandler) {
        if (areaFitHandler instanceof TrueSizeFitHandler) {
            return ZoomMode.TRUESIZE;
        }
        if (areaFitHandler instanceof PixelIdentityFitHandler) {
            return ZoomMode.PIXELIDENTITY;
        }
        return ZoomMode.NORMAL;
    }

    public static void setDisplayZoomMode(VisDisplay2 visDisplay2, ZoomMode zoomMode) {
        visDisplay2.getData().setZoomMode(zoomMode);
        if (visDisplay2.hasAction("ZOOM_TRUE_SIZE")) {
            visDisplay2.getAction("ZOOM_TRUE_SIZE").fireSelectionChanged();
        }
        if (visDisplay2.hasAction("ZOOM_NORMAL")) {
            visDisplay2.getAction("ZOOM_NORMAL").fireSelectionChanged();
        }
        if (visDisplay2.hasAction("ZOOM_PIXEL_1x1")) {
            visDisplay2.getAction("ZOOM_PIXEL_1x1").fireSelectionChanged();
        }
    }

    static void ensureDeactivatedMagnifyingGlass(VisDisplay2 visDisplay2) {
        for (Vis2 vis2 : visDisplay2.getVisViews()) {
            ImgView2 imgView2;
            View view = vis2.getView();
            if (!(view instanceof ImgView2) || !(imgView2 = (ImgView2)view).isMagnifierOn()) continue;
            imgView2.disableMagnifyingGlass();
        }
    }
}

