/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.util;

import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.util.Index;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;

public class TwoDArrayIterator<E>
implements Iterator<E>,
Iterable<E> {
    private int x = 0;
    private int y = 0;
    private E[][] data;

    public TwoDArrayIterator(E[][] EArray) {
        this.data = EArray;
    }

    @Override
    public boolean hasNext() {
        if (this.data == null) {
            return false;
        }
        return this.data.length > this.y && this.data[this.y].length > this.x;
    }

    @Override
    public E next() {
        if (this.y >= this.data.length || this.x >= this.data[this.y].length) {
            throw new NoSuchElementException();
        }
        E e = this.data[this.y][this.x];
        ++this.x;
        if (this.x >= this.data[this.y].length) {
            this.x = 0;
            ++this.y;
        }
        return e;
    }

    @Override
    public Iterator<E> iterator() {
        return new TwoDArrayIterator<E>(this.data);
    }

    public E[][] getData() {
        return this.data;
    }

    public static IFrameObjectData[] toArray(IFrameObjectData[][] iFrameObjectDataArray) {
        return (IFrameObjectData[])StreamSupport.stream(new TwoDArrayIterator<IFrameObjectData>(iFrameObjectDataArray).spliterator(), false).toArray(IFrameObjectData[]::new);
    }

    @CheckForNull
    public static Index indexOf(IFrameObjectData[][] iFrameObjectDataArray, IFrameObjectData iFrameObjectData) {
        String string = iFrameObjectData.getKey();
        int n = 0;
        while (n < iFrameObjectDataArray.length) {
            int n2 = 0;
            while (n2 < iFrameObjectDataArray[n].length) {
                if (Objects.equals(iFrameObjectDataArray[n][n2].getKey(), string)) {
                    return new Index(n2, n);
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }
}

