/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.tiani.config.LayoutConfig;
import com.tiani.gui.dialog.ImageAreaDialog;
import com.tiani.gui.util.GraphicsDeviceInfo;
import com.tiani.jvision.vis.EmptyVisDisplay2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.dcm4che3.data.PersonName;

public class DetachDisplay
extends AbstractPAction {
    public static final String ID = "DETACH_DISPLAY";
    private VisDisplay2 detachedDisplay;
    private EmptyVisDisplay2 placeHolder;
    private FloatingDisplayDialog detachedDialog;
    private Rectangle position;

    public DetachDisplay() {
        super("detachDisplay.svg");
        String string = Config.impaxee.workstation.DetachedWindowPosition.get();
        String[] stringArray = string.split(";");
        if (stringArray.length == 4) {
            try {
                this.position = new Rectangle();
                this.position.x = Integer.parseInt(stringArray[0]);
                this.position.y = Integer.parseInt(stringArray[1]);
                this.position.width = Integer.parseInt(stringArray[2]);
                this.position.height = Integer.parseInt(stringArray[3]);
                boolean bl = false;
                GraphicsDeviceInfo.RasterScreen[] rasterScreenArray = LayoutConfig.getInstance().getScreens();
                int n = rasterScreenArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GraphicsDeviceInfo.RasterScreen rasterScreen = rasterScreenArray[n2];
                    if (rasterScreen.bounds.contains(this.position.x, this.position.y)) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Exception exception) {
                this.position = new Rectangle(0, 0, 500, 500);
            }
        }
    }

    @Override
    public String getCaption() {
        return Messages.getString("DetachDisplay.DetachDisplay");
    }

    @Override
    public String getGroupName() {
        return GENERAL_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return Messages.getString("DetachDisplay.DetachDisplayDescription");
    }

    @Override
    public boolean perform(Component component) {
        this.notifyActionPerformed();
        VisDisplay2 visDisplay2 = AbstractPDataAction.getCurrentDisplay();
        if (visDisplay2 == null || visDisplay2.getScreen() == null) {
            return false;
        }
        this.closeDetached();
        if (visDisplay2.hasData()) {
            this.detachDisplay(visDisplay2);
            return true;
        }
        return false;
    }

    private void detachDisplay(VisDisplay2 visDisplay2) {
        this.placeHolder = visDisplay2.getScreen().detachDisplay(visDisplay2);
        this.detachedDisplay = visDisplay2;
        this.detachedDialog = new FloatingDisplayDialog(visDisplay2);
        this.detachedDialog.setBounds(this.position);
        this.detachedDialog.setVisible(true);
    }

    public void closeDetached() {
        if (this.detachedDialog != null && this.detachedDisplay != null) {
            this.detachedDialog.setVisible(false);
            this.attachDisplay(this.detachedDisplay);
        }
    }

    private void attachDisplay(VisDisplay2 visDisplay2) {
        VisScreen2 visScreen2 = this.detachedDisplay.getScreen();
        visScreen2.atachDisplay(this.detachedDisplay, this.placeHolder);
        this.detachedDisplay = null;
        this.placeHolder = null;
        this.detachedDialog = null;
    }

    private String getPatientName(IPatientRepresentation iPatientRepresentation) {
        PersonName personName = new PersonName(iPatientRepresentation.getPatientData().getDicomObject().getString(0x100010), true);
        return PersonNameUtilities.personNameToHRReverseShort((PersonName)personName);
    }

    private class FloatingDisplayDialog
    extends ImageAreaDialog
    implements WindowListener {
        private VisDisplay2 vd2;

        public FloatingDisplayDialog(VisDisplay2 visDisplay2) {
            super(DetachDisplay.this.getPatientName(visDisplay2.getData().getPatientRepresentation()), false);
            this.setName(DetachDisplay.ID);
            this.setSize(visDisplay2.getSize());
            this.setDefaultCloseOperation(1);
            this.vd2 = visDisplay2;
            this.setLayout(new BorderLayout(0, 0));
            visDisplay2.setDoubleBuffered(false);
            this.getRootPane().setDoubleBuffered(false);
            this.getContentPane().setBackground(Color.BLACK);
            this.getContentPane().add((Component)visDisplay2, "Center");
            if (visDisplay2.getToolBar().isVisible()) {
                String string = Config.impaxee.jvision.DISPLAY.ToolBarAlign.get();
                String string2 = string.equals("TOP") ? "North" : (string.equals("BOTTOM") ? "South" : (string.equals("LEFT") ? "West" : "East"));
                this.getContentPane().add((Component)visDisplay2.getToolBar(), string2);
            }
            this.addWindowListener(this);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DetachDisplay.this.position = this.getBounds();
            String string = String.valueOf(((DetachDisplay)DetachDisplay.this).position.x) + ";" + ((DetachDisplay)DetachDisplay.this).position.y + ";" + ((DetachDisplay)DetachDisplay.this).position.width + ";" + ((DetachDisplay)DetachDisplay.this).position.height;
            Config.impaxee.workstation.DetachedWindowPosition.set(string);
            DetachDisplay.this.attachDisplay(this.vd2);
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

