/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.tiani.jvision.vis.DragHandler;
import com.tiani.jvision.vis.MouseConfiguration;
import com.tiani.jvision.vis.VisMouseHandler;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class DragInfo {
    private static MouseConfiguration configuration = MouseConfiguration.getInstance();
    private Point startPt = new Point();
    private Point lastPt = new Point();
    private int dragRelX = 0;
    private int dragRelY = 0;
    private int dragAbsX = 0;
    private int dragAbsY = 0;
    private DragHandler handler;
    private VisMouseHandler mouseHandler;

    public DragInfo(MouseEvent mouseEvent, VisMouseHandler visMouseHandler) {
        this.startPt.x = mouseEvent.getX();
        this.startPt.y = mouseEvent.getY();
        this.lastPt.x = this.startPt.x;
        this.lastPt.y = this.startPt.y;
        this.mouseHandler = visMouseHandler;
    }

    public void press(MouseEvent mouseEvent) {
        int n = ModifierKeys.getExtendedModifier((MouseEvent)mouseEvent);
        this.handler = configuration.getDragHandler(n);
        if (this.handler != null) {
            this.handler.startDragging(mouseEvent, this.mouseHandler);
        }
    }

    public int getDragRelY() {
        return this.dragRelY;
    }

    public int getDragAbsY() {
        return this.dragAbsY;
    }

    public int getDragAbsX() {
        return this.dragAbsX;
    }

    public int getDragRelX() {
        return this.dragRelX;
    }

    public int getAbsoluteDistance() {
        return (int)Math.sqrt(this.dragAbsX * this.dragAbsX + this.dragAbsY * this.dragAbsY);
    }

    public Point getLastPoint() {
        return this.lastPt;
    }

    public void drag(MouseEvent mouseEvent) {
        this.dragRelX = mouseEvent.getX() - this.lastPt.x;
        this.dragRelY = mouseEvent.getY() - this.lastPt.y;
        this.dragAbsX += this.dragRelX;
        this.dragAbsY += this.dragRelY;
        this.lastPt.x = mouseEvent.getX();
        this.lastPt.y = mouseEvent.getY();
        mouseEvent.translatePoint(-mouseEvent.getX(), -mouseEvent.getY());
        mouseEvent.translatePoint(this.startPt.x + this.dragAbsX, this.startPt.y + this.dragAbsY);
        if (this.handler != null) {
            this.handler.drag(mouseEvent, this, this.mouseHandler);
        }
    }

    public MouseEvent translatePoint(MouseEvent mouseEvent) {
        mouseEvent.translatePoint(-mouseEvent.getX(), -mouseEvent.getY());
        mouseEvent.translatePoint(this.startPt.x + this.dragAbsX, this.startPt.y + this.dragAbsY);
        return mouseEvent;
    }

    public void release(MouseEvent mouseEvent) {
        mouseEvent.translatePoint(-mouseEvent.getX(), -mouseEvent.getY());
        mouseEvent.translatePoint(this.startPt.x + this.dragAbsX, this.startPt.y + this.dragAbsY);
        if (this.handler != null) {
            this.handler.endDragging(mouseEvent, this.mouseHandler);
            this.handler = null;
            this.mouseHandler = null;
        }
    }
}

