/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.data.shared.primitives.IntHashMap;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.keypress.KeypressRegistry;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.DragHandler;
import com.tiani.jvision.vis.VisMouseHandler;
import com.tiani.jvision.vis.event.mouse.DefaultDraggerHandler;
import com.tiani.jvision.vis.event.mouse.PanDraggerHandler;
import com.tiani.jvision.vis.event.mouse.ScrollingWheeler;
import com.tiani.jvision.vis.event.mouse.WindowLevelDragger;
import java.awt.event.MouseWheelListener;

public class MouseConfiguration {
    private static final ALogger LOGGER = ALogger.getLogger(VisMouseHandler.class);
    private IntHashMap<MouseWheelListener> mouseWheel = new IntHashMap();
    private IntHashMap<DragHandler> mouseDragging = new IntHashMap();
    private KeypressRegistry registry = KeypressRegistry.getInstance();
    public static final int NO_MODIFIERS_MASK = 704;
    private static final boolean WINDOWING_IMPAX_ES = Config.impaxee.jvision.DISPLAY.WindowingIMPAX_ES.get();
    private static final MouseConfiguration INSTANCE = new MouseConfiguration();

    private MouseConfiguration() {
        this.init();
    }

    private void init() {
        this.mouseDragging.put(1024, (Object)new DefaultDraggerHandler());
        WindowLevelDragger windowLevelDragger = new WindowLevelDragger();
        int n = WINDOWING_IMPAX_ES ? 4096 : 2048;
        this.mouseDragging.put(n | 0x80, (Object)windowLevelDragger);
        this.mouseDragging.put(n | 0x40, (Object)windowLevelDragger);
        this.mouseDragging.put(n, (Object)windowLevelDragger);
        this.mouseDragging.put(1280, (Object)new PanDraggerHandler());
        ScrollingWheeler scrollingWheeler = new ScrollingWheeler();
        this.mouseWheel.put(0, (Object)scrollingWheeler);
        this.mouseWheel.put(256, (Object)scrollingWheeler);
        this.mouseWheel.put(128, (Object)scrollingWheeler);
        this.mouseWheel.put(512, (Object)scrollingWheeler);
    }

    public static MouseConfiguration getInstance() {
        return INSTANCE;
    }

    public boolean handleAction(KeyShortcut keyShortcut, VisMouseHandler visMouseHandler) {
        boolean bl;
        PluginName pluginName = PluginName.DEFAULT;
        if (visMouseHandler.getVis().hasData()) {
            pluginName = visMouseHandler.getVis().getVisDisplay().getData().getPlugin().getPluginName();
        }
        if (!(bl = this.registry.handleMouse(keyShortcut, visMouseHandler, pluginName))) {
            LOGGER.info("Not recognized click:{}", (Object)keyShortcut);
        }
        return bl;
    }

    public DragHandler getDragHandler(int n) {
        DragHandler dragHandler = (DragHandler)this.mouseDragging.get(n);
        if (dragHandler == null) {
            dragHandler = (DragHandler)this.mouseDragging.get(n &= 0x2C0);
        }
        return dragHandler;
    }

    public MouseWheelListener getWheelHandler(int n) {
        MouseWheelListener mouseWheelListener = (MouseWheelListener)this.mouseWheel.get(n);
        if (mouseWheelListener == null) {
            mouseWheelListener = (MouseWheelListener)this.mouseWheel.get(n &= 0x2C0);
        }
        return mouseWheelListener;
    }
}

