/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.event.IVisNavigationEventHandler;
import com.tiani.jvision.vis.event.VisNavigationEvent;

class NavigThread
extends Thread {
    private static final ALogger log = ALogger.getLogger(NavigThread.class);
    private final VisDisplay2 parent;
    private final IVisNavigationEventHandler handler;
    private final VisNavigationEvent event;
    private int direction = 0;
    private long millisPerFrame;
    private long frameStart;
    private long frameTime;
    private long delay;
    private boolean isActive;
    private long initialDelayMillis = 500L;

    NavigThread(VisDisplay2 visDisplay2) {
        this.parent = visDisplay2;
        this.handler = visDisplay2.getVisNavigationEventHandler();
        this.event = VisNavigationEvent.createRelativeMoveEvent(0);
        this.setFPS(30);
    }

    public void setFPS(int n) {
        if (n == 0) {
            this.direction = 0;
        } else {
            this.millisPerFrame = (long)(1000.0f / (float)n);
        }
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    boolean isActive() {
        return this.isActive;
    }

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        EventUtil.invokeSynchronous(this::showNextFrame);
        while (VisDisplay2.pjvi1754_isNavigDragActive() && this.parent == VisDisplay2.getNavigDrawOwner()) {
            if (System.currentTimeMillis() - l > this.initialDelayMillis) {
                this.isActive = true;
                try {
                    EventUtil.invokeSynchronous(this::doDrag);
                }
                catch (Exception exception) {
                    log.error("NavigThread", (Throwable)exception);
                }
                continue;
            }
            try {
                NavigThread.sleep(this.initialDelayMillis / 5L);
            }
            catch (Exception exception) {
                log.error("NavigThread", (Throwable)exception);
            }
        }
        this.isActive = false;
        this.parent.navigDragStopped();
    }

    private void doDrag() {
        try {
            if (this.direction != 0) {
                this.frameStart = System.currentTimeMillis();
                this.showNextFrame();
                if (!VisDisplay2.pjvi1754_isNavigDragActive() || this.parent != VisDisplay2.getNavigDrawOwner()) {
                    return;
                }
                this.frameTime = System.currentTimeMillis() - this.frameStart;
                this.delay = this.millisPerFrame - this.frameTime;
            } else {
                this.delay = 50L;
            }
            if (!VisDisplay2.pjvi1754_isNavigDragActive() || this.parent != VisDisplay2.getNavigDrawOwner()) {
                return;
            }
            if (this.delay > 10L) {
                try {
                    NavigThread.sleep(this.delay);
                }
                catch (Exception exception) {
                    log.error("NavigThread", (Throwable)exception);
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Throwable throwable) {
            log.error("NavigThread", throwable);
        }
    }

    private void showNextFrame() {
        this.event.setValue(this.direction);
        this.handler.handleNavigationEvent(this.event);
    }
}

