/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.User;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.presentationstate.PresentationStatePoolCollector;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateType;
import com.agfa.pacs.impaxee.save.gui.AbstractSaveWithDescriptionPanel;
import com.agfa.pacs.impaxee.save.gui.SaveWithDescriptionDialog;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisData;
import com.tiani.util.message.Message;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class PresentationStateStorePanel
extends AbstractSaveWithDescriptionPanel {
    private static final ALogger log = ALogger.getLogger(PresentationStateStorePanel.class);
    private List<VisData> visData;
    private String overrideLabel;
    private final List<IStoreHandler> storeHandlers;

    public PresentationStateStorePanel(List<VisData> list) {
        this(list, null);
    }

    private PresentationStateStorePanel(List<VisData> list, Integer n) {
        super(n);
        this.visData = list;
        this.storeHandlers = new ArrayList<IStoreHandler>(2);
    }

    public static SaveWithDescriptionDialog createDialog(List<VisData> list) {
        return new SaveWithDescriptionDialog((Frame)JVision2.getMainFrame(), Messages.getString("PresentationStateStoreDlg.Title"), new PresentationStateStorePanel(list, 35));
    }

    public void setLabel(String string) {
        this.overrideLabel = string;
    }

    @Override
    public List<IStoreHandler> getStoreHandlers() {
        return this.storeHandlers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean save(boolean bl) {
        void var3_10;
        StringBuilder stringBuilder;
        Map<IStudyData, List<IObjectData>> map;
        PresentationStatePoolCollector presentationStatePoolCollector = this.overrideLabel != null ? new PresentationStatePoolCollector(User.getUserNameAsPN(), this.overrideLabel, this.getDescription(), PresentationStateType.PERMANENT) : new PresentationStatePoolCollector(User.getUserNameAsPN(), User.getUserName().toUpperCase(), this.getDescription(), PresentationStateType.PERMANENT);
        for (VisData object : this.visData) {
            presentationStatePoolCollector.addVisData(object);
        }
        if (presentationStatePoolCollector.isEmpty() || presentationStatePoolCollector.isMissingData()) {
            void var3_7;
            if (presentationStatePoolCollector.isEmpty()) {
                String n = "NoData";
            } else {
                String string = "MissingData";
            }
            map = Messages.getString("PresentationStateStorePanel.CollectorFailure.Title");
            stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append("<p>");
            stringBuilder.append(Messages.getString("PresentationStateStorePanel.CollectorFailure.Message." + (String)var3_7));
            stringBuilder.append("<br /><br />");
            stringBuilder.append(Messages.getString("PresentationStateStorePanel.CollectorFailure.PossibleCause.Heading"));
            stringBuilder.append("</p>");
            stringBuilder.append("<ul>");
            int n = 1;
            while (n <= 3) {
                stringBuilder.append("<li>");
                stringBuilder.append(Messages.getString("PresentationStateStorePanel.CollectorFailure.PossibleCause." + n));
                stringBuilder.append("</li>");
                ++n;
            }
            stringBuilder.append("</ul>");
            stringBuilder.append("</html>");
            Message.warning(map, stringBuilder.toString());
        }
        presentationStatePoolCollector.storeInStudies(-1);
        boolean bl2 = false;
        map = presentationStatePoolCollector.getObjectData();
        stringBuilder = this.visData.get(0).getFrameData().getQueryObject().getSource();
        String string = stringBuilder.getSourceAET();
        for (Map.Entry<IStudyData, List<IObjectData>> entry : map.entrySet()) {
            IStudyData iStudyData = entry.getKey();
            IDataInfoSource iDataInfoSource = iStudyData.getQueryObject().getSource();
            boolean bl3 = false;
            if (string != null && !string.equals(iDataInfoSource.getSourceAET())) {
                bl3 = true;
                iStudyData.getQueryObject().setSource((IDataInfoSource)stringBuilder);
            }
            try {
                IStoreHandler iStoreHandler = DataManager.getInstance().getDataStore().store((Collection<IObjectData>)entry.getValue(), iStudyData, null);
                if (iStoreHandler == null) {
                    Message.error("Cannot store presentation states ! - Missing target");
                    log.error("Cannot store presentation states !");
                    ++var3_10;
                    continue;
                }
                this.storeHandlers.add(iStoreHandler);
            }
            finally {
                if (bl3) {
                    iStudyData.getQueryObject().setSource(iDataInfoSource);
                }
            }
        }
        if (var3_10 == false && Config.impaxee.jvision.MEASUREMENT.AutomaticKeyObjectCreation.get()) {
            List<Pair<IStudyData, Set<ReferencedImage>>> list = presentationStatePoolCollector.getImagesWithAnnotations();
            boolean bl4 = true;
            for (IStudyData iStudyData : list) {
                bl4 &= KeyImageManager.storeKeyObjects((IStudyData)iStudyData.getLeft(), KeyImageType.OfInterest, (Set)iStudyData.getRight(), (IDataInfoSource)stringBuilder);
            }
            if (!bl4) {
                log.error("Failed to store at least one key object!");
            }
        }
        return var3_10 == false;
    }
}

